# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.datafactory import DataFactoryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataFactoryManagementPipelinesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataFactoryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_pipelines_list_by_factory(self, resource_group):
        response = self.client.pipelines.list_by_factory(
            resource_group_name=resource_group.name,
            factory_name="str",
            api_version="2018-06-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_pipelines_create_or_update(self, resource_group):
        response = self.client.pipelines.create_or_update(
            resource_group_name=resource_group.name,
            factory_name="str",
            pipeline_name="str",
            pipeline={
                "activities": ["activity"],
                "annotations": [{}],
                "concurrency": 0,
                "description": "str",
                "etag": "str",
                "folder": {"name": "str"},
                "id": "str",
                "name": "str",
                "parameters": {"str": {"type": "str", "defaultValue": {}}},
                "policy": {"elapsedTimeMetric": {"duration": {}}},
                "runDimensions": {"str": {}},
                "type": "str",
                "variables": {"str": {"type": "str", "defaultValue": {}}},
            },
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_pipelines_get(self, resource_group):
        response = self.client.pipelines.get(
            resource_group_name=resource_group.name,
            factory_name="str",
            pipeline_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_pipelines_delete(self, resource_group):
        response = self.client.pipelines.delete(
            resource_group_name=resource_group.name,
            factory_name="str",
            pipeline_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_pipelines_create_run(self, resource_group):
        response = self.client.pipelines.create_run(
            resource_group_name=resource_group.name,
            factory_name="str",
            pipeline_name="str",
            api_version="2018-06-01",
        )

        # please add some check logic here by yourself
        # ...
