# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementWebApplicationFirewallPoliciesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_application_firewall_policies_list(self, resource_group):
        response = self.client.web_application_firewall_policies.list(
            resource_group_name=resource_group.name,
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_application_firewall_policies_list_all(self, resource_group):
        response = self.client.web_application_firewall_policies.list_all(
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_application_firewall_policies_get(self, resource_group):
        response = self.client.web_application_firewall_policies.get(
            resource_group_name=resource_group.name,
            policy_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_application_firewall_policies_create_or_update(self, resource_group):
        response = self.client.web_application_firewall_policies.create_or_update(
            resource_group_name=resource_group.name,
            policy_name="str",
            parameters={
                "applicationGatewayForContainers": [{"id": "str"}],
                "applicationGateways": [
                    {
                        "authenticationCertificates": [
                            {
                                "data": "str",
                                "etag": "str",
                                "id": "str",
                                "name": "str",
                                "provisioningState": "str",
                                "type": "str",
                            }
                        ],
                        "autoscaleConfiguration": {"minCapacity": 0, "maxCapacity": 0},
                        "backendAddressPools": [
                            {
                                "backendAddresses": [{"fqdn": "str", "ipAddress": "str"}],
                                "backendIPConfigurations": [
                                    {
                                        "applicationGatewayBackendAddressPools": [...],
                                        "applicationSecurityGroups": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            }
                                        ],
                                        "etag": "str",
                                        "gatewayLoadBalancer": {"id": "str"},
                                        "id": "str",
                                        "loadBalancerBackendAddressPools": [
                                            {
                                                "backendIPConfigurations": [...],
                                                "drainPeriodInSeconds": 0,
                                                "etag": "str",
                                                "id": "str",
                                                "inboundNatRules": [{"id": "str"}],
                                                "loadBalancerBackendAddresses": [
                                                    {
                                                        "adminState": "str",
                                                        "inboundNatRulesPortMapping": [
                                                            {
                                                                "backendPort": 0,
                                                                "frontendPort": 0,
                                                                "inboundNatRuleName": "str",
                                                            }
                                                        ],
                                                        "ipAddress": "str",
                                                        "loadBalancerFrontendIPConfiguration": {"id": "str"},
                                                        "name": "str",
                                                        "networkInterfaceIPConfiguration": {"id": "str"},
                                                        "subnet": {"id": "str"},
                                                        "virtualNetwork": {"id": "str"},
                                                    }
                                                ],
                                                "loadBalancingRules": [{"id": "str"}],
                                                "location": "str",
                                                "name": "str",
                                                "outboundRule": {"id": "str"},
                                                "outboundRules": [{"id": "str"}],
                                                "provisioningState": "str",
                                                "syncMode": "str",
                                                "tunnelInterfaces": [
                                                    {"identifier": 0, "port": 0, "protocol": "str", "type": "str"}
                                                ],
                                                "type": "str",
                                                "virtualNetwork": {"id": "str"},
                                            }
                                        ],
                                        "loadBalancerInboundNatRules": [
                                            {
                                                "backendAddressPool": {"id": "str"},
                                                "backendIPConfiguration": ...,
                                                "backendPort": 0,
                                                "enableFloatingIP": bool,
                                                "enableTcpReset": bool,
                                                "etag": "str",
                                                "frontendIPConfiguration": {"id": "str"},
                                                "frontendPort": 0,
                                                "frontendPortRangeEnd": 0,
                                                "frontendPortRangeStart": 0,
                                                "id": "str",
                                                "idleTimeoutInMinutes": 0,
                                                "name": "str",
                                                "protocol": "str",
                                                "provisioningState": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "name": "str",
                                        "primary": bool,
                                        "privateIPAddress": "str",
                                        "privateIPAddressPrefixLength": 0,
                                        "privateIPAddressVersion": "str",
                                        "privateIPAllocationMethod": "str",
                                        "privateLinkConnectionProperties": {
                                            "fqdns": ["str"],
                                            "groupId": "str",
                                            "requiredMemberName": "str",
                                        },
                                        "provisioningState": "str",
                                        "publicIPAddress": {
                                            "ddosSettings": {
                                                "ddosProtectionPlan": {"id": "str"},
                                                "protectionMode": "str",
                                            },
                                            "deleteOption": "str",
                                            "dnsSettings": {
                                                "domainNameLabel": "str",
                                                "domainNameLabelScope": "str",
                                                "fqdn": "str",
                                                "reverseFqdn": "str",
                                            },
                                            "etag": "str",
                                            "extendedLocation": {"name": "str", "type": "str"},
                                            "id": "str",
                                            "idleTimeoutInMinutes": 0,
                                            "ipAddress": "str",
                                            "ipConfiguration": {
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "privateIPAddress": "str",
                                                "privateIPAllocationMethod": "str",
                                                "provisioningState": "str",
                                                "publicIPAddress": ...,
                                                "subnet": {
                                                    "addressPrefix": "str",
                                                    "addressPrefixes": ["str"],
                                                    "applicationGatewayIPConfigurations": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "subnet": {"id": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "defaultOutboundAccess": bool,
                                                    "delegations": [
                                                        {
                                                            "actions": ["str"],
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "serviceName": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "etag": "str",
                                                    "id": "str",
                                                    "ipAllocations": [{"id": "str"}],
                                                    "ipConfigurationProfiles": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "subnet": ...,
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "ipConfigurations": [...],
                                                    "ipamPoolPrefixAllocations": [
                                                        {
                                                            "allocatedAddressPrefixes": ["str"],
                                                            "id": "str",
                                                            "numberOfIpAddresses": "str",
                                                        }
                                                    ],
                                                    "name": "str",
                                                    "natGateway": {"id": "str"},
                                                    "networkSecurityGroup": {
                                                        "defaultSecurityRules": [
                                                            {
                                                                "access": "str",
                                                                "description": "str",
                                                                "destinationAddressPrefix": "str",
                                                                "destinationAddressPrefixes": ["str"],
                                                                "destinationApplicationSecurityGroups": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "destinationPortRange": "str",
                                                                "destinationPortRanges": ["str"],
                                                                "direction": "str",
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "priority": 0,
                                                                "protocol": "str",
                                                                "provisioningState": "str",
                                                                "sourceAddressPrefix": "str",
                                                                "sourceAddressPrefixes": ["str"],
                                                                "sourceApplicationSecurityGroups": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "sourcePortRange": "str",
                                                                "sourcePortRanges": ["str"],
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "etag": "str",
                                                        "flowLogs": [
                                                            {
                                                                "enabled": bool,
                                                                "enabledFilteringCriteria": "str",
                                                                "etag": "str",
                                                                "flowAnalyticsConfiguration": {
                                                                    "networkWatcherFlowAnalyticsConfiguration": {
                                                                        "enabled": bool,
                                                                        "trafficAnalyticsInterval": 0,
                                                                        "workspaceId": "str",
                                                                        "workspaceRegion": "str",
                                                                        "workspaceResourceId": "str",
                                                                    }
                                                                },
                                                                "format": {"type": "str", "version": 0},
                                                                "id": "str",
                                                                "identity": {
                                                                    "principalId": "str",
                                                                    "tenantId": "str",
                                                                    "type": "str",
                                                                    "userAssignedIdentities": {
                                                                        "str": {"clientId": "str", "principalId": "str"}
                                                                    },
                                                                },
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "recordTypes": "str",
                                                                "retentionPolicy": {"days": 0, "enabled": False},
                                                                "storageId": "str",
                                                                "tags": {"str": "str"},
                                                                "targetResourceGuid": "str",
                                                                "targetResourceId": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "flushConnection": bool,
                                                        "id": "str",
                                                        "location": "str",
                                                        "name": "str",
                                                        "networkInterfaces": [
                                                            {
                                                                "auxiliaryMode": "str",
                                                                "auxiliarySku": "str",
                                                                "defaultOutboundConnectivityEnabled": bool,
                                                                "disableTcpStateTracking": bool,
                                                                "dnsSettings": {
                                                                    "appliedDnsServers": ["str"],
                                                                    "dnsServers": ["str"],
                                                                    "internalDnsNameLabel": "str",
                                                                    "internalDomainNameSuffix": "str",
                                                                    "internalFqdn": "str",
                                                                },
                                                                "dscpConfiguration": {"id": "str"},
                                                                "enableAcceleratedNetworking": bool,
                                                                "enableIPForwarding": bool,
                                                                "etag": "str",
                                                                "extendedLocation": {"name": "str", "type": "str"},
                                                                "hostedWorkloads": ["str"],
                                                                "id": "str",
                                                                "ipConfigurations": [...],
                                                                "location": "str",
                                                                "macAddress": "str",
                                                                "migrationPhase": "str",
                                                                "name": "str",
                                                                "networkSecurityGroup": ...,
                                                                "nicType": "str",
                                                                "primary": bool,
                                                                "privateEndpoint": {
                                                                    "applicationSecurityGroups": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "customDnsConfigs": [
                                                                        {"fqdn": "str", "ipAddresses": ["str"]}
                                                                    ],
                                                                    "customNetworkInterfaceName": "str",
                                                                    "etag": "str",
                                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                                    "id": "str",
                                                                    "ipConfigurations": [
                                                                        {
                                                                            "etag": "str",
                                                                            "groupId": "str",
                                                                            "memberName": "str",
                                                                            "name": "str",
                                                                            "privateIPAddress": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "ipVersionType": "IPv4",
                                                                    "location": "str",
                                                                    "manualPrivateLinkServiceConnections": [
                                                                        {
                                                                            "etag": "str",
                                                                            "groupIds": ["str"],
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "privateLinkServiceConnectionState": {
                                                                                "actionsRequired": "str",
                                                                                "description": "str",
                                                                                "status": "str",
                                                                            },
                                                                            "privateLinkServiceId": "str",
                                                                            "provisioningState": "str",
                                                                            "requestMessage": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "name": "str",
                                                                    "networkInterfaces": [...],
                                                                    "privateLinkServiceConnections": [
                                                                        {
                                                                            "etag": "str",
                                                                            "groupIds": ["str"],
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "privateLinkServiceConnectionState": {
                                                                                "actionsRequired": "str",
                                                                                "description": "str",
                                                                                "status": "str",
                                                                            },
                                                                            "privateLinkServiceId": "str",
                                                                            "provisioningState": "str",
                                                                            "requestMessage": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "provisioningState": "str",
                                                                    "subnet": ...,
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                },
                                                                "privateLinkService": {
                                                                    "accessMode": "str",
                                                                    "alias": "str",
                                                                    "autoApproval": {"subscriptions": ["str"]},
                                                                    "destinationIPAddress": "str",
                                                                    "enableProxyProtocol": bool,
                                                                    "etag": "str",
                                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                                    "fqdns": ["str"],
                                                                    "id": "str",
                                                                    "ipConfigurations": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "primary": bool,
                                                                            "privateIPAddress": "str",
                                                                            "privateIPAddressVersion": "str",
                                                                            "privateIPAllocationMethod": "str",
                                                                            "provisioningState": "str",
                                                                            "subnet": ...,
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "loadBalancerFrontendIpConfigurations": [
                                                                        {
                                                                            "etag": "str",
                                                                            "gatewayLoadBalancer": {"id": "str"},
                                                                            "id": "str",
                                                                            "inboundNatPools": [{"id": "str"}],
                                                                            "inboundNatRules": [{"id": "str"}],
                                                                            "loadBalancingRules": [{"id": "str"}],
                                                                            "name": "str",
                                                                            "outboundRules": [{"id": "str"}],
                                                                            "privateIPAddress": "str",
                                                                            "privateIPAddressVersion": "str",
                                                                            "privateIPAllocationMethod": "str",
                                                                            "provisioningState": "str",
                                                                            "publicIPAddress": ...,
                                                                            "publicIPPrefix": {"id": "str"},
                                                                            "subnet": ...,
                                                                            "type": "str",
                                                                            "zones": ["str"],
                                                                        }
                                                                    ],
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "networkInterfaces": [...],
                                                                    "privateEndpointConnections": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "linkIdentifier": "str",
                                                                            "name": "str",
                                                                            "privateEndpoint": {
                                                                                "applicationSecurityGroups": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "resourceGuid": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "customDnsConfigs": [
                                                                                    {
                                                                                        "fqdn": "str",
                                                                                        "ipAddresses": ["str"],
                                                                                    }
                                                                                ],
                                                                                "customNetworkInterfaceName": "str",
                                                                                "etag": "str",
                                                                                "extendedLocation": {
                                                                                    "name": "str",
                                                                                    "type": "str",
                                                                                },
                                                                                "id": "str",
                                                                                "ipConfigurations": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "groupId": "str",
                                                                                        "memberName": "str",
                                                                                        "name": "str",
                                                                                        "privateIPAddress": "str",
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "ipVersionType": "IPv4",
                                                                                "location": "str",
                                                                                "manualPrivateLinkServiceConnections": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "groupIds": ["str"],
                                                                                        "id": "str",
                                                                                        "name": "str",
                                                                                        "privateLinkServiceConnectionState": {
                                                                                            "actionsRequired": "str",
                                                                                            "description": "str",
                                                                                            "status": "str",
                                                                                        },
                                                                                        "privateLinkServiceId": "str",
                                                                                        "provisioningState": "str",
                                                                                        "requestMessage": "str",
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "name": "str",
                                                                                "networkInterfaces": [...],
                                                                                "privateLinkServiceConnections": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "groupIds": ["str"],
                                                                                        "id": "str",
                                                                                        "name": "str",
                                                                                        "privateLinkServiceConnectionState": {
                                                                                            "actionsRequired": "str",
                                                                                            "description": "str",
                                                                                            "status": "str",
                                                                                        },
                                                                                        "privateLinkServiceId": "str",
                                                                                        "provisioningState": "str",
                                                                                        "requestMessage": "str",
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "provisioningState": "str",
                                                                                "subnet": ...,
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            },
                                                                            "privateEndpointLocation": "str",
                                                                            "privateLinkServiceConnectionState": {
                                                                                "actionsRequired": "str",
                                                                                "description": "str",
                                                                                "status": "str",
                                                                            },
                                                                            "provisioningState": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "provisioningState": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                    "visibility": {"subscriptions": ["str"]},
                                                                },
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "tapConfigurations": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "type": "str",
                                                                        "virtualNetworkTap": {
                                                                            "destinationLoadBalancerFrontEndIPConfiguration": {
                                                                                "etag": "str",
                                                                                "gatewayLoadBalancer": {"id": "str"},
                                                                                "id": "str",
                                                                                "inboundNatPools": [{"id": "str"}],
                                                                                "inboundNatRules": [{"id": "str"}],
                                                                                "loadBalancingRules": [{"id": "str"}],
                                                                                "name": "str",
                                                                                "outboundRules": [{"id": "str"}],
                                                                                "privateIPAddress": "str",
                                                                                "privateIPAddressVersion": "str",
                                                                                "privateIPAllocationMethod": "str",
                                                                                "provisioningState": "str",
                                                                                "publicIPAddress": ...,
                                                                                "publicIPPrefix": {"id": "str"},
                                                                                "subnet": ...,
                                                                                "type": "str",
                                                                                "zones": ["str"],
                                                                            },
                                                                            "destinationNetworkInterfaceIPConfiguration": ...,
                                                                            "destinationPort": 0,
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "networkInterfaceTapConfigurations": [...],
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        },
                                                                    }
                                                                ],
                                                                "type": "str",
                                                                "virtualMachine": {"id": "str"},
                                                                "vnetEncryptionSupported": bool,
                                                                "workloadType": "str",
                                                            }
                                                        ],
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "securityRules": [
                                                            {
                                                                "access": "str",
                                                                "description": "str",
                                                                "destinationAddressPrefix": "str",
                                                                "destinationAddressPrefixes": ["str"],
                                                                "destinationApplicationSecurityGroups": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "destinationPortRange": "str",
                                                                "destinationPortRanges": ["str"],
                                                                "direction": "str",
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "priority": 0,
                                                                "protocol": "str",
                                                                "provisioningState": "str",
                                                                "sourceAddressPrefix": "str",
                                                                "sourceAddressPrefixes": ["str"],
                                                                "sourceApplicationSecurityGroups": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "sourcePortRange": "str",
                                                                "sourcePortRanges": ["str"],
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "subnets": [...],
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                    },
                                                    "privateEndpointNetworkPolicies": "Disabled",
                                                    "privateEndpoints": [
                                                        {
                                                            "applicationSecurityGroups": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "customDnsConfigs": [
                                                                {"fqdn": "str", "ipAddresses": ["str"]}
                                                            ],
                                                            "customNetworkInterfaceName": "str",
                                                            "etag": "str",
                                                            "extendedLocation": {"name": "str", "type": "str"},
                                                            "id": "str",
                                                            "ipConfigurations": [
                                                                {
                                                                    "etag": "str",
                                                                    "groupId": "str",
                                                                    "memberName": "str",
                                                                    "name": "str",
                                                                    "privateIPAddress": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "ipVersionType": "IPv4",
                                                            "location": "str",
                                                            "manualPrivateLinkServiceConnections": [
                                                                {
                                                                    "etag": "str",
                                                                    "groupIds": ["str"],
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "privateLinkServiceConnectionState": {
                                                                        "actionsRequired": "str",
                                                                        "description": "str",
                                                                        "status": "str",
                                                                    },
                                                                    "privateLinkServiceId": "str",
                                                                    "provisioningState": "str",
                                                                    "requestMessage": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "name": "str",
                                                            "networkInterfaces": [
                                                                {
                                                                    "auxiliaryMode": "str",
                                                                    "auxiliarySku": "str",
                                                                    "defaultOutboundConnectivityEnabled": bool,
                                                                    "disableTcpStateTracking": bool,
                                                                    "dnsSettings": {
                                                                        "appliedDnsServers": ["str"],
                                                                        "dnsServers": ["str"],
                                                                        "internalDnsNameLabel": "str",
                                                                        "internalDomainNameSuffix": "str",
                                                                        "internalFqdn": "str",
                                                                    },
                                                                    "dscpConfiguration": {"id": "str"},
                                                                    "enableAcceleratedNetworking": bool,
                                                                    "enableIPForwarding": bool,
                                                                    "etag": "str",
                                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                                    "hostedWorkloads": ["str"],
                                                                    "id": "str",
                                                                    "ipConfigurations": [...],
                                                                    "location": "str",
                                                                    "macAddress": "str",
                                                                    "migrationPhase": "str",
                                                                    "name": "str",
                                                                    "networkSecurityGroup": {
                                                                        "defaultSecurityRules": [
                                                                            {
                                                                                "access": "str",
                                                                                "description": "str",
                                                                                "destinationAddressPrefix": "str",
                                                                                "destinationAddressPrefixes": ["str"],
                                                                                "destinationApplicationSecurityGroups": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "resourceGuid": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "destinationPortRange": "str",
                                                                                "destinationPortRanges": ["str"],
                                                                                "direction": "str",
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "priority": 0,
                                                                                "protocol": "str",
                                                                                "provisioningState": "str",
                                                                                "sourceAddressPrefix": "str",
                                                                                "sourceAddressPrefixes": ["str"],
                                                                                "sourceApplicationSecurityGroups": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "resourceGuid": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "sourcePortRange": "str",
                                                                                "sourcePortRanges": ["str"],
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "etag": "str",
                                                                        "flowLogs": [
                                                                            {
                                                                                "enabled": bool,
                                                                                "enabledFilteringCriteria": "str",
                                                                                "etag": "str",
                                                                                "flowAnalyticsConfiguration": {
                                                                                    "networkWatcherFlowAnalyticsConfiguration": {
                                                                                        "enabled": bool,
                                                                                        "trafficAnalyticsInterval": 0,
                                                                                        "workspaceId": "str",
                                                                                        "workspaceRegion": "str",
                                                                                        "workspaceResourceId": "str",
                                                                                    }
                                                                                },
                                                                                "format": {"type": "str", "version": 0},
                                                                                "id": "str",
                                                                                "identity": {
                                                                                    "principalId": "str",
                                                                                    "tenantId": "str",
                                                                                    "type": "str",
                                                                                    "userAssignedIdentities": {
                                                                                        "str": {
                                                                                            "clientId": "str",
                                                                                            "principalId": "str",
                                                                                        }
                                                                                    },
                                                                                },
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "recordTypes": "str",
                                                                                "retentionPolicy": {
                                                                                    "days": 0,
                                                                                    "enabled": False,
                                                                                },
                                                                                "storageId": "str",
                                                                                "tags": {"str": "str"},
                                                                                "targetResourceGuid": "str",
                                                                                "targetResourceId": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "flushConnection": bool,
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "networkInterfaces": [...],
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "securityRules": [
                                                                            {
                                                                                "access": "str",
                                                                                "description": "str",
                                                                                "destinationAddressPrefix": "str",
                                                                                "destinationAddressPrefixes": ["str"],
                                                                                "destinationApplicationSecurityGroups": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "resourceGuid": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "destinationPortRange": "str",
                                                                                "destinationPortRanges": ["str"],
                                                                                "direction": "str",
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "priority": 0,
                                                                                "protocol": "str",
                                                                                "provisioningState": "str",
                                                                                "sourceAddressPrefix": "str",
                                                                                "sourceAddressPrefixes": ["str"],
                                                                                "sourceApplicationSecurityGroups": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "resourceGuid": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "sourcePortRange": "str",
                                                                                "sourcePortRanges": ["str"],
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "subnets": [...],
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    },
                                                                    "nicType": "str",
                                                                    "primary": bool,
                                                                    "privateEndpoint": ...,
                                                                    "privateLinkService": {
                                                                        "accessMode": "str",
                                                                        "alias": "str",
                                                                        "autoApproval": {"subscriptions": ["str"]},
                                                                        "destinationIPAddress": "str",
                                                                        "enableProxyProtocol": bool,
                                                                        "etag": "str",
                                                                        "extendedLocation": {
                                                                            "name": "str",
                                                                            "type": "str",
                                                                        },
                                                                        "fqdns": ["str"],
                                                                        "id": "str",
                                                                        "ipConfigurations": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "primary": bool,
                                                                                "privateIPAddress": "str",
                                                                                "privateIPAddressVersion": "str",
                                                                                "privateIPAllocationMethod": "str",
                                                                                "provisioningState": "str",
                                                                                "subnet": ...,
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "loadBalancerFrontendIpConfigurations": [
                                                                            {
                                                                                "etag": "str",
                                                                                "gatewayLoadBalancer": {"id": "str"},
                                                                                "id": "str",
                                                                                "inboundNatPools": [{"id": "str"}],
                                                                                "inboundNatRules": [{"id": "str"}],
                                                                                "loadBalancingRules": [{"id": "str"}],
                                                                                "name": "str",
                                                                                "outboundRules": [{"id": "str"}],
                                                                                "privateIPAddress": "str",
                                                                                "privateIPAddressVersion": "str",
                                                                                "privateIPAllocationMethod": "str",
                                                                                "provisioningState": "str",
                                                                                "publicIPAddress": ...,
                                                                                "publicIPPrefix": {"id": "str"},
                                                                                "subnet": ...,
                                                                                "type": "str",
                                                                                "zones": ["str"],
                                                                            }
                                                                        ],
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "networkInterfaces": [...],
                                                                        "privateEndpointConnections": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "linkIdentifier": "str",
                                                                                "name": "str",
                                                                                "privateEndpoint": ...,
                                                                                "privateEndpointLocation": "str",
                                                                                "privateLinkServiceConnectionState": {
                                                                                    "actionsRequired": "str",
                                                                                    "description": "str",
                                                                                    "status": "str",
                                                                                },
                                                                                "provisioningState": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "provisioningState": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                        "visibility": {"subscriptions": ["str"]},
                                                                    },
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "tapConfigurations": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "type": "str",
                                                                            "virtualNetworkTap": {
                                                                                "destinationLoadBalancerFrontEndIPConfiguration": {
                                                                                    "etag": "str",
                                                                                    "gatewayLoadBalancer": {
                                                                                        "id": "str"
                                                                                    },
                                                                                    "id": "str",
                                                                                    "inboundNatPools": [{"id": "str"}],
                                                                                    "inboundNatRules": [{"id": "str"}],
                                                                                    "loadBalancingRules": [
                                                                                        {"id": "str"}
                                                                                    ],
                                                                                    "name": "str",
                                                                                    "outboundRules": [{"id": "str"}],
                                                                                    "privateIPAddress": "str",
                                                                                    "privateIPAddressVersion": "str",
                                                                                    "privateIPAllocationMethod": "str",
                                                                                    "provisioningState": "str",
                                                                                    "publicIPAddress": ...,
                                                                                    "publicIPPrefix": {"id": "str"},
                                                                                    "subnet": ...,
                                                                                    "type": "str",
                                                                                    "zones": ["str"],
                                                                                },
                                                                                "destinationNetworkInterfaceIPConfiguration": ...,
                                                                                "destinationPort": 0,
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "networkInterfaceTapConfigurations": [
                                                                                    ...
                                                                                ],
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            },
                                                                        }
                                                                    ],
                                                                    "type": "str",
                                                                    "virtualMachine": {"id": "str"},
                                                                    "vnetEncryptionSupported": bool,
                                                                    "workloadType": "str",
                                                                }
                                                            ],
                                                            "privateLinkServiceConnections": [
                                                                {
                                                                    "etag": "str",
                                                                    "groupIds": ["str"],
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "privateLinkServiceConnectionState": {
                                                                        "actionsRequired": "str",
                                                                        "description": "str",
                                                                        "status": "str",
                                                                    },
                                                                    "privateLinkServiceId": "str",
                                                                    "provisioningState": "str",
                                                                    "requestMessage": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "provisioningState": "str",
                                                            "subnet": ...,
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "privateLinkServiceNetworkPolicies": "Enabled",
                                                    "provisioningState": "str",
                                                    "purpose": "str",
                                                    "resourceNavigationLinks": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "link": "str",
                                                            "linkedResourceType": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "routeTable": {
                                                        "disableBgpRoutePropagation": bool,
                                                        "etag": "str",
                                                        "id": "str",
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "routes": [
                                                            {
                                                                "addressPrefix": "str",
                                                                "etag": "str",
                                                                "hasBgpOverride": bool,
                                                                "id": "str",
                                                                "name": "str",
                                                                "nextHopIpAddress": "str",
                                                                "nextHopType": "str",
                                                                "provisioningState": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "subnets": [...],
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                    },
                                                    "serviceAssociationLinks": [
                                                        {
                                                            "allowDelete": bool,
                                                            "etag": "str",
                                                            "id": "str",
                                                            "link": "str",
                                                            "linkedResourceType": "str",
                                                            "locations": ["str"],
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "serviceEndpointPolicies": [
                                                        {
                                                            "contextualServiceEndpointPolicies": ["str"],
                                                            "etag": "str",
                                                            "id": "str",
                                                            "kind": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "serviceAlias": "str",
                                                            "serviceEndpointPolicyDefinitions": [
                                                                {
                                                                    "description": "str",
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "service": "str",
                                                                    "serviceResources": ["str"],
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "subnets": [...],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "serviceEndpoints": [
                                                        {
                                                            "locations": ["str"],
                                                            "networkIdentifier": {"id": "str"},
                                                            "provisioningState": "str",
                                                            "service": "str",
                                                        }
                                                    ],
                                                    "sharingScope": "str",
                                                    "type": "str",
                                                },
                                            },
                                            "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                            "linkedPublicIPAddress": ...,
                                            "location": "str",
                                            "migrationPhase": "str",
                                            "name": "str",
                                            "natGateway": {
                                                "etag": "str",
                                                "id": "str",
                                                "idleTimeoutInMinutes": 0,
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "publicIpAddresses": [{"id": "str"}],
                                                "publicIpAddressesV6": [{"id": "str"}],
                                                "publicIpPrefixes": [{"id": "str"}],
                                                "publicIpPrefixesV6": [{"id": "str"}],
                                                "resourceGuid": "str",
                                                "sku": {"name": "str"},
                                                "sourceVirtualNetwork": {"id": "str"},
                                                "subnets": [{"id": "str"}],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                                "zones": ["str"],
                                            },
                                            "provisioningState": "str",
                                            "publicIPAddressVersion": "str",
                                            "publicIPAllocationMethod": "str",
                                            "publicIPPrefix": {"id": "str"},
                                            "resourceGuid": "str",
                                            "servicePublicIPAddress": ...,
                                            "sku": {"name": "str", "tier": "str"},
                                            "tags": {"str": "str"},
                                            "type": "str",
                                            "zones": ["str"],
                                        },
                                        "subnet": {
                                            "addressPrefix": "str",
                                            "addressPrefixes": ["str"],
                                            "applicationGatewayIPConfigurations": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "subnet": {"id": "str"},
                                                    "type": "str",
                                                }
                                            ],
                                            "defaultOutboundAccess": bool,
                                            "delegations": [
                                                {
                                                    "actions": ["str"],
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "serviceName": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "etag": "str",
                                            "id": "str",
                                            "ipAllocations": [{"id": "str"}],
                                            "ipConfigurationProfiles": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "subnet": ...,
                                                    "type": "str",
                                                }
                                            ],
                                            "ipConfigurations": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "privateIPAddress": "str",
                                                    "privateIPAllocationMethod": "str",
                                                    "provisioningState": "str",
                                                    "publicIPAddress": {
                                                        "ddosSettings": {
                                                            "ddosProtectionPlan": {"id": "str"},
                                                            "protectionMode": "str",
                                                        },
                                                        "deleteOption": "str",
                                                        "dnsSettings": {
                                                            "domainNameLabel": "str",
                                                            "domainNameLabelScope": "str",
                                                            "fqdn": "str",
                                                            "reverseFqdn": "str",
                                                        },
                                                        "etag": "str",
                                                        "extendedLocation": {"name": "str", "type": "str"},
                                                        "id": "str",
                                                        "idleTimeoutInMinutes": 0,
                                                        "ipAddress": "str",
                                                        "ipConfiguration": ...,
                                                        "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                        "linkedPublicIPAddress": ...,
                                                        "location": "str",
                                                        "migrationPhase": "str",
                                                        "name": "str",
                                                        "natGateway": {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "idleTimeoutInMinutes": 0,
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "publicIpAddresses": [{"id": "str"}],
                                                            "publicIpAddressesV6": [{"id": "str"}],
                                                            "publicIpPrefixes": [{"id": "str"}],
                                                            "publicIpPrefixesV6": [{"id": "str"}],
                                                            "resourceGuid": "str",
                                                            "sku": {"name": "str"},
                                                            "sourceVirtualNetwork": {"id": "str"},
                                                            "subnets": [{"id": "str"}],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                            "zones": ["str"],
                                                        },
                                                        "provisioningState": "str",
                                                        "publicIPAddressVersion": "str",
                                                        "publicIPAllocationMethod": "str",
                                                        "publicIPPrefix": {"id": "str"},
                                                        "resourceGuid": "str",
                                                        "servicePublicIPAddress": ...,
                                                        "sku": {"name": "str", "tier": "str"},
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                        "zones": ["str"],
                                                    },
                                                    "subnet": ...,
                                                }
                                            ],
                                            "ipamPoolPrefixAllocations": [
                                                {
                                                    "allocatedAddressPrefixes": ["str"],
                                                    "id": "str",
                                                    "numberOfIpAddresses": "str",
                                                }
                                            ],
                                            "name": "str",
                                            "natGateway": {"id": "str"},
                                            "networkSecurityGroup": {
                                                "defaultSecurityRules": [
                                                    {
                                                        "access": "str",
                                                        "description": "str",
                                                        "destinationAddressPrefix": "str",
                                                        "destinationAddressPrefixes": ["str"],
                                                        "destinationApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "destinationPortRange": "str",
                                                        "destinationPortRanges": ["str"],
                                                        "direction": "str",
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "priority": 0,
                                                        "protocol": "str",
                                                        "provisioningState": "str",
                                                        "sourceAddressPrefix": "str",
                                                        "sourceAddressPrefixes": ["str"],
                                                        "sourceApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "sourcePortRange": "str",
                                                        "sourcePortRanges": ["str"],
                                                        "type": "str",
                                                    }
                                                ],
                                                "etag": "str",
                                                "flowLogs": [
                                                    {
                                                        "enabled": bool,
                                                        "enabledFilteringCriteria": "str",
                                                        "etag": "str",
                                                        "flowAnalyticsConfiguration": {
                                                            "networkWatcherFlowAnalyticsConfiguration": {
                                                                "enabled": bool,
                                                                "trafficAnalyticsInterval": 0,
                                                                "workspaceId": "str",
                                                                "workspaceRegion": "str",
                                                                "workspaceResourceId": "str",
                                                            }
                                                        },
                                                        "format": {"type": "str", "version": 0},
                                                        "id": "str",
                                                        "identity": {
                                                            "principalId": "str",
                                                            "tenantId": "str",
                                                            "type": "str",
                                                            "userAssignedIdentities": {
                                                                "str": {"clientId": "str", "principalId": "str"}
                                                            },
                                                        },
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "recordTypes": "str",
                                                        "retentionPolicy": {"days": 0, "enabled": False},
                                                        "storageId": "str",
                                                        "tags": {"str": "str"},
                                                        "targetResourceGuid": "str",
                                                        "targetResourceId": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "flushConnection": bool,
                                                "id": "str",
                                                "location": "str",
                                                "name": "str",
                                                "networkInterfaces": [
                                                    {
                                                        "auxiliaryMode": "str",
                                                        "auxiliarySku": "str",
                                                        "defaultOutboundConnectivityEnabled": bool,
                                                        "disableTcpStateTracking": bool,
                                                        "dnsSettings": {
                                                            "appliedDnsServers": ["str"],
                                                            "dnsServers": ["str"],
                                                            "internalDnsNameLabel": "str",
                                                            "internalDomainNameSuffix": "str",
                                                            "internalFqdn": "str",
                                                        },
                                                        "dscpConfiguration": {"id": "str"},
                                                        "enableAcceleratedNetworking": bool,
                                                        "enableIPForwarding": bool,
                                                        "etag": "str",
                                                        "extendedLocation": {"name": "str", "type": "str"},
                                                        "hostedWorkloads": ["str"],
                                                        "id": "str",
                                                        "ipConfigurations": [...],
                                                        "location": "str",
                                                        "macAddress": "str",
                                                        "migrationPhase": "str",
                                                        "name": "str",
                                                        "networkSecurityGroup": ...,
                                                        "nicType": "str",
                                                        "primary": bool,
                                                        "privateEndpoint": {
                                                            "applicationSecurityGroups": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "customDnsConfigs": [
                                                                {"fqdn": "str", "ipAddresses": ["str"]}
                                                            ],
                                                            "customNetworkInterfaceName": "str",
                                                            "etag": "str",
                                                            "extendedLocation": {"name": "str", "type": "str"},
                                                            "id": "str",
                                                            "ipConfigurations": [
                                                                {
                                                                    "etag": "str",
                                                                    "groupId": "str",
                                                                    "memberName": "str",
                                                                    "name": "str",
                                                                    "privateIPAddress": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "ipVersionType": "IPv4",
                                                            "location": "str",
                                                            "manualPrivateLinkServiceConnections": [
                                                                {
                                                                    "etag": "str",
                                                                    "groupIds": ["str"],
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "privateLinkServiceConnectionState": {
                                                                        "actionsRequired": "str",
                                                                        "description": "str",
                                                                        "status": "str",
                                                                    },
                                                                    "privateLinkServiceId": "str",
                                                                    "provisioningState": "str",
                                                                    "requestMessage": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "name": "str",
                                                            "networkInterfaces": [...],
                                                            "privateLinkServiceConnections": [
                                                                {
                                                                    "etag": "str",
                                                                    "groupIds": ["str"],
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "privateLinkServiceConnectionState": {
                                                                        "actionsRequired": "str",
                                                                        "description": "str",
                                                                        "status": "str",
                                                                    },
                                                                    "privateLinkServiceId": "str",
                                                                    "provisioningState": "str",
                                                                    "requestMessage": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "provisioningState": "str",
                                                            "subnet": ...,
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        },
                                                        "privateLinkService": {
                                                            "accessMode": "str",
                                                            "alias": "str",
                                                            "autoApproval": {"subscriptions": ["str"]},
                                                            "destinationIPAddress": "str",
                                                            "enableProxyProtocol": bool,
                                                            "etag": "str",
                                                            "extendedLocation": {"name": "str", "type": "str"},
                                                            "fqdns": ["str"],
                                                            "id": "str",
                                                            "ipConfigurations": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "primary": bool,
                                                                    "privateIPAddress": "str",
                                                                    "privateIPAddressVersion": "str",
                                                                    "privateIPAllocationMethod": "str",
                                                                    "provisioningState": "str",
                                                                    "subnet": ...,
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "loadBalancerFrontendIpConfigurations": [
                                                                {
                                                                    "etag": "str",
                                                                    "gatewayLoadBalancer": {"id": "str"},
                                                                    "id": "str",
                                                                    "inboundNatPools": [{"id": "str"}],
                                                                    "inboundNatRules": [{"id": "str"}],
                                                                    "loadBalancingRules": [{"id": "str"}],
                                                                    "name": "str",
                                                                    "outboundRules": [{"id": "str"}],
                                                                    "privateIPAddress": "str",
                                                                    "privateIPAddressVersion": "str",
                                                                    "privateIPAllocationMethod": "str",
                                                                    "provisioningState": "str",
                                                                    "publicIPAddress": {
                                                                        "ddosSettings": {
                                                                            "ddosProtectionPlan": {"id": "str"},
                                                                            "protectionMode": "str",
                                                                        },
                                                                        "deleteOption": "str",
                                                                        "dnsSettings": {
                                                                            "domainNameLabel": "str",
                                                                            "domainNameLabelScope": "str",
                                                                            "fqdn": "str",
                                                                            "reverseFqdn": "str",
                                                                        },
                                                                        "etag": "str",
                                                                        "extendedLocation": {
                                                                            "name": "str",
                                                                            "type": "str",
                                                                        },
                                                                        "id": "str",
                                                                        "idleTimeoutInMinutes": 0,
                                                                        "ipAddress": "str",
                                                                        "ipConfiguration": {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "privateIPAddress": "str",
                                                                            "privateIPAllocationMethod": "str",
                                                                            "provisioningState": "str",
                                                                            "publicIPAddress": ...,
                                                                            "subnet": ...,
                                                                        },
                                                                        "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                        "linkedPublicIPAddress": ...,
                                                                        "location": "str",
                                                                        "migrationPhase": "str",
                                                                        "name": "str",
                                                                        "natGateway": {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "idleTimeoutInMinutes": 0,
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "publicIpAddresses": [{"id": "str"}],
                                                                            "publicIpAddressesV6": [{"id": "str"}],
                                                                            "publicIpPrefixes": [{"id": "str"}],
                                                                            "publicIpPrefixesV6": [{"id": "str"}],
                                                                            "resourceGuid": "str",
                                                                            "sku": {"name": "str"},
                                                                            "sourceVirtualNetwork": {"id": "str"},
                                                                            "subnets": [{"id": "str"}],
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                            "zones": ["str"],
                                                                        },
                                                                        "provisioningState": "str",
                                                                        "publicIPAddressVersion": "str",
                                                                        "publicIPAllocationMethod": "str",
                                                                        "publicIPPrefix": {"id": "str"},
                                                                        "resourceGuid": "str",
                                                                        "servicePublicIPAddress": ...,
                                                                        "sku": {"name": "str", "tier": "str"},
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                        "zones": ["str"],
                                                                    },
                                                                    "publicIPPrefix": {"id": "str"},
                                                                    "subnet": ...,
                                                                    "type": "str",
                                                                    "zones": ["str"],
                                                                }
                                                            ],
                                                            "location": "str",
                                                            "name": "str",
                                                            "networkInterfaces": [...],
                                                            "privateEndpointConnections": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "linkIdentifier": "str",
                                                                    "name": "str",
                                                                    "privateEndpoint": {
                                                                        "applicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "customDnsConfigs": [
                                                                            {"fqdn": "str", "ipAddresses": ["str"]}
                                                                        ],
                                                                        "customNetworkInterfaceName": "str",
                                                                        "etag": "str",
                                                                        "extendedLocation": {
                                                                            "name": "str",
                                                                            "type": "str",
                                                                        },
                                                                        "id": "str",
                                                                        "ipConfigurations": [
                                                                            {
                                                                                "etag": "str",
                                                                                "groupId": "str",
                                                                                "memberName": "str",
                                                                                "name": "str",
                                                                                "privateIPAddress": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "ipVersionType": "IPv4",
                                                                        "location": "str",
                                                                        "manualPrivateLinkServiceConnections": [
                                                                            {
                                                                                "etag": "str",
                                                                                "groupIds": ["str"],
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "privateLinkServiceConnectionState": {
                                                                                    "actionsRequired": "str",
                                                                                    "description": "str",
                                                                                    "status": "str",
                                                                                },
                                                                                "privateLinkServiceId": "str",
                                                                                "provisioningState": "str",
                                                                                "requestMessage": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "name": "str",
                                                                        "networkInterfaces": [...],
                                                                        "privateLinkServiceConnections": [
                                                                            {
                                                                                "etag": "str",
                                                                                "groupIds": ["str"],
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "privateLinkServiceConnectionState": {
                                                                                    "actionsRequired": "str",
                                                                                    "description": "str",
                                                                                    "status": "str",
                                                                                },
                                                                                "privateLinkServiceId": "str",
                                                                                "provisioningState": "str",
                                                                                "requestMessage": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "provisioningState": "str",
                                                                        "subnet": ...,
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    },
                                                                    "privateEndpointLocation": "str",
                                                                    "privateLinkServiceConnectionState": {
                                                                        "actionsRequired": "str",
                                                                        "description": "str",
                                                                        "status": "str",
                                                                    },
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "provisioningState": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                            "visibility": {"subscriptions": ["str"]},
                                                        },
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "tags": {"str": "str"},
                                                        "tapConfigurations": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "type": "str",
                                                                "virtualNetworkTap": {
                                                                    "destinationLoadBalancerFrontEndIPConfiguration": {
                                                                        "etag": "str",
                                                                        "gatewayLoadBalancer": {"id": "str"},
                                                                        "id": "str",
                                                                        "inboundNatPools": [{"id": "str"}],
                                                                        "inboundNatRules": [{"id": "str"}],
                                                                        "loadBalancingRules": [{"id": "str"}],
                                                                        "name": "str",
                                                                        "outboundRules": [{"id": "str"}],
                                                                        "privateIPAddress": "str",
                                                                        "privateIPAddressVersion": "str",
                                                                        "privateIPAllocationMethod": "str",
                                                                        "provisioningState": "str",
                                                                        "publicIPAddress": {
                                                                            "ddosSettings": {
                                                                                "ddosProtectionPlan": {"id": "str"},
                                                                                "protectionMode": "str",
                                                                            },
                                                                            "deleteOption": "str",
                                                                            "dnsSettings": {
                                                                                "domainNameLabel": "str",
                                                                                "domainNameLabelScope": "str",
                                                                                "fqdn": "str",
                                                                                "reverseFqdn": "str",
                                                                            },
                                                                            "etag": "str",
                                                                            "extendedLocation": {
                                                                                "name": "str",
                                                                                "type": "str",
                                                                            },
                                                                            "id": "str",
                                                                            "idleTimeoutInMinutes": 0,
                                                                            "ipAddress": "str",
                                                                            "ipConfiguration": {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "privateIPAddress": "str",
                                                                                "privateIPAllocationMethod": "str",
                                                                                "provisioningState": "str",
                                                                                "publicIPAddress": ...,
                                                                                "subnet": ...,
                                                                            },
                                                                            "ipTags": [
                                                                                {"ipTagType": "str", "tag": "str"}
                                                                            ],
                                                                            "linkedPublicIPAddress": ...,
                                                                            "location": "str",
                                                                            "migrationPhase": "str",
                                                                            "name": "str",
                                                                            "natGateway": {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "idleTimeoutInMinutes": 0,
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "publicIpAddresses": [{"id": "str"}],
                                                                                "publicIpAddressesV6": [{"id": "str"}],
                                                                                "publicIpPrefixes": [{"id": "str"}],
                                                                                "publicIpPrefixesV6": [{"id": "str"}],
                                                                                "resourceGuid": "str",
                                                                                "sku": {"name": "str"},
                                                                                "sourceVirtualNetwork": {"id": "str"},
                                                                                "subnets": [{"id": "str"}],
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                                "zones": ["str"],
                                                                            },
                                                                            "provisioningState": "str",
                                                                            "publicIPAddressVersion": "str",
                                                                            "publicIPAllocationMethod": "str",
                                                                            "publicIPPrefix": {"id": "str"},
                                                                            "resourceGuid": "str",
                                                                            "servicePublicIPAddress": ...,
                                                                            "sku": {"name": "str", "tier": "str"},
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                            "zones": ["str"],
                                                                        },
                                                                        "publicIPPrefix": {"id": "str"},
                                                                        "subnet": ...,
                                                                        "type": "str",
                                                                        "zones": ["str"],
                                                                    },
                                                                    "destinationNetworkInterfaceIPConfiguration": ...,
                                                                    "destinationPort": 0,
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "networkInterfaceTapConfigurations": [...],
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                },
                                                            }
                                                        ],
                                                        "type": "str",
                                                        "virtualMachine": {"id": "str"},
                                                        "vnetEncryptionSupported": bool,
                                                        "workloadType": "str",
                                                    }
                                                ],
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "securityRules": [
                                                    {
                                                        "access": "str",
                                                        "description": "str",
                                                        "destinationAddressPrefix": "str",
                                                        "destinationAddressPrefixes": ["str"],
                                                        "destinationApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "destinationPortRange": "str",
                                                        "destinationPortRanges": ["str"],
                                                        "direction": "str",
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "priority": 0,
                                                        "protocol": "str",
                                                        "provisioningState": "str",
                                                        "sourceAddressPrefix": "str",
                                                        "sourceAddressPrefixes": ["str"],
                                                        "sourceApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "sourcePortRange": "str",
                                                        "sourcePortRanges": ["str"],
                                                        "type": "str",
                                                    }
                                                ],
                                                "subnets": [...],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            },
                                            "privateEndpointNetworkPolicies": "Disabled",
                                            "privateEndpoints": [
                                                {
                                                    "applicationSecurityGroups": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "customDnsConfigs": [{"fqdn": "str", "ipAddresses": ["str"]}],
                                                    "customNetworkInterfaceName": "str",
                                                    "etag": "str",
                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                    "id": "str",
                                                    "ipConfigurations": [
                                                        {
                                                            "etag": "str",
                                                            "groupId": "str",
                                                            "memberName": "str",
                                                            "name": "str",
                                                            "privateIPAddress": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "ipVersionType": "IPv4",
                                                    "location": "str",
                                                    "manualPrivateLinkServiceConnections": [
                                                        {
                                                            "etag": "str",
                                                            "groupIds": ["str"],
                                                            "id": "str",
                                                            "name": "str",
                                                            "privateLinkServiceConnectionState": {
                                                                "actionsRequired": "str",
                                                                "description": "str",
                                                                "status": "str",
                                                            },
                                                            "privateLinkServiceId": "str",
                                                            "provisioningState": "str",
                                                            "requestMessage": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "name": "str",
                                                    "networkInterfaces": [
                                                        {
                                                            "auxiliaryMode": "str",
                                                            "auxiliarySku": "str",
                                                            "defaultOutboundConnectivityEnabled": bool,
                                                            "disableTcpStateTracking": bool,
                                                            "dnsSettings": {
                                                                "appliedDnsServers": ["str"],
                                                                "dnsServers": ["str"],
                                                                "internalDnsNameLabel": "str",
                                                                "internalDomainNameSuffix": "str",
                                                                "internalFqdn": "str",
                                                            },
                                                            "dscpConfiguration": {"id": "str"},
                                                            "enableAcceleratedNetworking": bool,
                                                            "enableIPForwarding": bool,
                                                            "etag": "str",
                                                            "extendedLocation": {"name": "str", "type": "str"},
                                                            "hostedWorkloads": ["str"],
                                                            "id": "str",
                                                            "ipConfigurations": [...],
                                                            "location": "str",
                                                            "macAddress": "str",
                                                            "migrationPhase": "str",
                                                            "name": "str",
                                                            "networkSecurityGroup": {
                                                                "defaultSecurityRules": [
                                                                    {
                                                                        "access": "str",
                                                                        "description": "str",
                                                                        "destinationAddressPrefix": "str",
                                                                        "destinationAddressPrefixes": ["str"],
                                                                        "destinationApplicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "destinationPortRange": "str",
                                                                        "destinationPortRanges": ["str"],
                                                                        "direction": "str",
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "priority": 0,
                                                                        "protocol": "str",
                                                                        "provisioningState": "str",
                                                                        "sourceAddressPrefix": "str",
                                                                        "sourceAddressPrefixes": ["str"],
                                                                        "sourceApplicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "sourcePortRange": "str",
                                                                        "sourcePortRanges": ["str"],
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "etag": "str",
                                                                "flowLogs": [
                                                                    {
                                                                        "enabled": bool,
                                                                        "enabledFilteringCriteria": "str",
                                                                        "etag": "str",
                                                                        "flowAnalyticsConfiguration": {
                                                                            "networkWatcherFlowAnalyticsConfiguration": {
                                                                                "enabled": bool,
                                                                                "trafficAnalyticsInterval": 0,
                                                                                "workspaceId": "str",
                                                                                "workspaceRegion": "str",
                                                                                "workspaceResourceId": "str",
                                                                            }
                                                                        },
                                                                        "format": {"type": "str", "version": 0},
                                                                        "id": "str",
                                                                        "identity": {
                                                                            "principalId": "str",
                                                                            "tenantId": "str",
                                                                            "type": "str",
                                                                            "userAssignedIdentities": {
                                                                                "str": {
                                                                                    "clientId": "str",
                                                                                    "principalId": "str",
                                                                                }
                                                                            },
                                                                        },
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "recordTypes": "str",
                                                                        "retentionPolicy": {
                                                                            "days": 0,
                                                                            "enabled": False,
                                                                        },
                                                                        "storageId": "str",
                                                                        "tags": {"str": "str"},
                                                                        "targetResourceGuid": "str",
                                                                        "targetResourceId": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "flushConnection": bool,
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "networkInterfaces": [...],
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "securityRules": [
                                                                    {
                                                                        "access": "str",
                                                                        "description": "str",
                                                                        "destinationAddressPrefix": "str",
                                                                        "destinationAddressPrefixes": ["str"],
                                                                        "destinationApplicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "destinationPortRange": "str",
                                                                        "destinationPortRanges": ["str"],
                                                                        "direction": "str",
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "priority": 0,
                                                                        "protocol": "str",
                                                                        "provisioningState": "str",
                                                                        "sourceAddressPrefix": "str",
                                                                        "sourceAddressPrefixes": ["str"],
                                                                        "sourceApplicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "sourcePortRange": "str",
                                                                        "sourcePortRanges": ["str"],
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "subnets": [...],
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            },
                                                            "nicType": "str",
                                                            "primary": bool,
                                                            "privateEndpoint": ...,
                                                            "privateLinkService": {
                                                                "accessMode": "str",
                                                                "alias": "str",
                                                                "autoApproval": {"subscriptions": ["str"]},
                                                                "destinationIPAddress": "str",
                                                                "enableProxyProtocol": bool,
                                                                "etag": "str",
                                                                "extendedLocation": {"name": "str", "type": "str"},
                                                                "fqdns": ["str"],
                                                                "id": "str",
                                                                "ipConfigurations": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "primary": bool,
                                                                        "privateIPAddress": "str",
                                                                        "privateIPAddressVersion": "str",
                                                                        "privateIPAllocationMethod": "str",
                                                                        "provisioningState": "str",
                                                                        "subnet": ...,
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "loadBalancerFrontendIpConfigurations": [
                                                                    {
                                                                        "etag": "str",
                                                                        "gatewayLoadBalancer": {"id": "str"},
                                                                        "id": "str",
                                                                        "inboundNatPools": [{"id": "str"}],
                                                                        "inboundNatRules": [{"id": "str"}],
                                                                        "loadBalancingRules": [{"id": "str"}],
                                                                        "name": "str",
                                                                        "outboundRules": [{"id": "str"}],
                                                                        "privateIPAddress": "str",
                                                                        "privateIPAddressVersion": "str",
                                                                        "privateIPAllocationMethod": "str",
                                                                        "provisioningState": "str",
                                                                        "publicIPAddress": {
                                                                            "ddosSettings": {
                                                                                "ddosProtectionPlan": {"id": "str"},
                                                                                "protectionMode": "str",
                                                                            },
                                                                            "deleteOption": "str",
                                                                            "dnsSettings": {
                                                                                "domainNameLabel": "str",
                                                                                "domainNameLabelScope": "str",
                                                                                "fqdn": "str",
                                                                                "reverseFqdn": "str",
                                                                            },
                                                                            "etag": "str",
                                                                            "extendedLocation": {
                                                                                "name": "str",
                                                                                "type": "str",
                                                                            },
                                                                            "id": "str",
                                                                            "idleTimeoutInMinutes": 0,
                                                                            "ipAddress": "str",
                                                                            "ipConfiguration": {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "privateIPAddress": "str",
                                                                                "privateIPAllocationMethod": "str",
                                                                                "provisioningState": "str",
                                                                                "publicIPAddress": ...,
                                                                                "subnet": ...,
                                                                            },
                                                                            "ipTags": [
                                                                                {"ipTagType": "str", "tag": "str"}
                                                                            ],
                                                                            "linkedPublicIPAddress": ...,
                                                                            "location": "str",
                                                                            "migrationPhase": "str",
                                                                            "name": "str",
                                                                            "natGateway": {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "idleTimeoutInMinutes": 0,
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "publicIpAddresses": [{"id": "str"}],
                                                                                "publicIpAddressesV6": [{"id": "str"}],
                                                                                "publicIpPrefixes": [{"id": "str"}],
                                                                                "publicIpPrefixesV6": [{"id": "str"}],
                                                                                "resourceGuid": "str",
                                                                                "sku": {"name": "str"},
                                                                                "sourceVirtualNetwork": {"id": "str"},
                                                                                "subnets": [{"id": "str"}],
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                                "zones": ["str"],
                                                                            },
                                                                            "provisioningState": "str",
                                                                            "publicIPAddressVersion": "str",
                                                                            "publicIPAllocationMethod": "str",
                                                                            "publicIPPrefix": {"id": "str"},
                                                                            "resourceGuid": "str",
                                                                            "servicePublicIPAddress": ...,
                                                                            "sku": {"name": "str", "tier": "str"},
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                            "zones": ["str"],
                                                                        },
                                                                        "publicIPPrefix": {"id": "str"},
                                                                        "subnet": ...,
                                                                        "type": "str",
                                                                        "zones": ["str"],
                                                                    }
                                                                ],
                                                                "location": "str",
                                                                "name": "str",
                                                                "networkInterfaces": [...],
                                                                "privateEndpointConnections": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "linkIdentifier": "str",
                                                                        "name": "str",
                                                                        "privateEndpoint": ...,
                                                                        "privateEndpointLocation": "str",
                                                                        "privateLinkServiceConnectionState": {
                                                                            "actionsRequired": "str",
                                                                            "description": "str",
                                                                            "status": "str",
                                                                        },
                                                                        "provisioningState": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "provisioningState": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                                "visibility": {"subscriptions": ["str"]},
                                                            },
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "tapConfigurations": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                    "virtualNetworkTap": {
                                                                        "destinationLoadBalancerFrontEndIPConfiguration": {
                                                                            "etag": "str",
                                                                            "gatewayLoadBalancer": {"id": "str"},
                                                                            "id": "str",
                                                                            "inboundNatPools": [{"id": "str"}],
                                                                            "inboundNatRules": [{"id": "str"}],
                                                                            "loadBalancingRules": [{"id": "str"}],
                                                                            "name": "str",
                                                                            "outboundRules": [{"id": "str"}],
                                                                            "privateIPAddress": "str",
                                                                            "privateIPAddressVersion": "str",
                                                                            "privateIPAllocationMethod": "str",
                                                                            "provisioningState": "str",
                                                                            "publicIPAddress": {
                                                                                "ddosSettings": {
                                                                                    "ddosProtectionPlan": {"id": "str"},
                                                                                    "protectionMode": "str",
                                                                                },
                                                                                "deleteOption": "str",
                                                                                "dnsSettings": {
                                                                                    "domainNameLabel": "str",
                                                                                    "domainNameLabelScope": "str",
                                                                                    "fqdn": "str",
                                                                                    "reverseFqdn": "str",
                                                                                },
                                                                                "etag": "str",
                                                                                "extendedLocation": {
                                                                                    "name": "str",
                                                                                    "type": "str",
                                                                                },
                                                                                "id": "str",
                                                                                "idleTimeoutInMinutes": 0,
                                                                                "ipAddress": "str",
                                                                                "ipConfiguration": {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "privateIPAddress": "str",
                                                                                    "privateIPAllocationMethod": "str",
                                                                                    "provisioningState": "str",
                                                                                    "publicIPAddress": ...,
                                                                                    "subnet": ...,
                                                                                },
                                                                                "ipTags": [
                                                                                    {"ipTagType": "str", "tag": "str"}
                                                                                ],
                                                                                "linkedPublicIPAddress": ...,
                                                                                "location": "str",
                                                                                "migrationPhase": "str",
                                                                                "name": "str",
                                                                                "natGateway": {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "idleTimeoutInMinutes": 0,
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "publicIpAddresses": [
                                                                                        {"id": "str"}
                                                                                    ],
                                                                                    "publicIpAddressesV6": [
                                                                                        {"id": "str"}
                                                                                    ],
                                                                                    "publicIpPrefixes": [{"id": "str"}],
                                                                                    "publicIpPrefixesV6": [
                                                                                        {"id": "str"}
                                                                                    ],
                                                                                    "resourceGuid": "str",
                                                                                    "sku": {"name": "str"},
                                                                                    "sourceVirtualNetwork": {
                                                                                        "id": "str"
                                                                                    },
                                                                                    "subnets": [{"id": "str"}],
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                    "zones": ["str"],
                                                                                },
                                                                                "provisioningState": "str",
                                                                                "publicIPAddressVersion": "str",
                                                                                "publicIPAllocationMethod": "str",
                                                                                "publicIPPrefix": {"id": "str"},
                                                                                "resourceGuid": "str",
                                                                                "servicePublicIPAddress": ...,
                                                                                "sku": {"name": "str", "tier": "str"},
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                                "zones": ["str"],
                                                                            },
                                                                            "publicIPPrefix": {"id": "str"},
                                                                            "subnet": ...,
                                                                            "type": "str",
                                                                            "zones": ["str"],
                                                                        },
                                                                        "destinationNetworkInterfaceIPConfiguration": ...,
                                                                        "destinationPort": 0,
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "networkInterfaceTapConfigurations": [...],
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    },
                                                                }
                                                            ],
                                                            "type": "str",
                                                            "virtualMachine": {"id": "str"},
                                                            "vnetEncryptionSupported": bool,
                                                            "workloadType": "str",
                                                        }
                                                    ],
                                                    "privateLinkServiceConnections": [
                                                        {
                                                            "etag": "str",
                                                            "groupIds": ["str"],
                                                            "id": "str",
                                                            "name": "str",
                                                            "privateLinkServiceConnectionState": {
                                                                "actionsRequired": "str",
                                                                "description": "str",
                                                                "status": "str",
                                                            },
                                                            "privateLinkServiceId": "str",
                                                            "provisioningState": "str",
                                                            "requestMessage": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "provisioningState": "str",
                                                    "subnet": ...,
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                }
                                            ],
                                            "privateLinkServiceNetworkPolicies": "Enabled",
                                            "provisioningState": "str",
                                            "purpose": "str",
                                            "resourceNavigationLinks": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "link": "str",
                                                    "linkedResourceType": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "routeTable": {
                                                "disableBgpRoutePropagation": bool,
                                                "etag": "str",
                                                "id": "str",
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "routes": [
                                                    {
                                                        "addressPrefix": "str",
                                                        "etag": "str",
                                                        "hasBgpOverride": bool,
                                                        "id": "str",
                                                        "name": "str",
                                                        "nextHopIpAddress": "str",
                                                        "nextHopType": "str",
                                                        "provisioningState": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "subnets": [...],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            },
                                            "serviceAssociationLinks": [
                                                {
                                                    "allowDelete": bool,
                                                    "etag": "str",
                                                    "id": "str",
                                                    "link": "str",
                                                    "linkedResourceType": "str",
                                                    "locations": ["str"],
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "serviceEndpointPolicies": [
                                                {
                                                    "contextualServiceEndpointPolicies": ["str"],
                                                    "etag": "str",
                                                    "id": "str",
                                                    "kind": "str",
                                                    "location": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "resourceGuid": "str",
                                                    "serviceAlias": "str",
                                                    "serviceEndpointPolicyDefinitions": [
                                                        {
                                                            "description": "str",
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "service": "str",
                                                            "serviceResources": ["str"],
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "subnets": [...],
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                }
                                            ],
                                            "serviceEndpoints": [
                                                {
                                                    "locations": ["str"],
                                                    "networkIdentifier": {"id": "str"},
                                                    "provisioningState": "str",
                                                    "service": "str",
                                                }
                                            ],
                                            "sharingScope": "str",
                                            "type": "str",
                                        },
                                        "type": "str",
                                        "virtualNetworkTaps": [
                                            {
                                                "destinationLoadBalancerFrontEndIPConfiguration": {
                                                    "etag": "str",
                                                    "gatewayLoadBalancer": {"id": "str"},
                                                    "id": "str",
                                                    "inboundNatPools": [{"id": "str"}],
                                                    "inboundNatRules": [{"id": "str"}],
                                                    "loadBalancingRules": [{"id": "str"}],
                                                    "name": "str",
                                                    "outboundRules": [{"id": "str"}],
                                                    "privateIPAddress": "str",
                                                    "privateIPAddressVersion": "str",
                                                    "privateIPAllocationMethod": "str",
                                                    "provisioningState": "str",
                                                    "publicIPAddress": {
                                                        "ddosSettings": {
                                                            "ddosProtectionPlan": {"id": "str"},
                                                            "protectionMode": "str",
                                                        },
                                                        "deleteOption": "str",
                                                        "dnsSettings": {
                                                            "domainNameLabel": "str",
                                                            "domainNameLabelScope": "str",
                                                            "fqdn": "str",
                                                            "reverseFqdn": "str",
                                                        },
                                                        "etag": "str",
                                                        "extendedLocation": {"name": "str", "type": "str"},
                                                        "id": "str",
                                                        "idleTimeoutInMinutes": 0,
                                                        "ipAddress": "str",
                                                        "ipConfiguration": {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "privateIPAddress": "str",
                                                            "privateIPAllocationMethod": "str",
                                                            "provisioningState": "str",
                                                            "publicIPAddress": ...,
                                                            "subnet": {
                                                                "addressPrefix": "str",
                                                                "addressPrefixes": ["str"],
                                                                "applicationGatewayIPConfigurations": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "subnet": {"id": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "defaultOutboundAccess": bool,
                                                                "delegations": [
                                                                    {
                                                                        "actions": ["str"],
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "serviceName": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "etag": "str",
                                                                "id": "str",
                                                                "ipAllocations": [{"id": "str"}],
                                                                "ipConfigurationProfiles": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "subnet": ...,
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "ipConfigurations": [...],
                                                                "ipamPoolPrefixAllocations": [
                                                                    {
                                                                        "allocatedAddressPrefixes": ["str"],
                                                                        "id": "str",
                                                                        "numberOfIpAddresses": "str",
                                                                    }
                                                                ],
                                                                "name": "str",
                                                                "natGateway": {"id": "str"},
                                                                "networkSecurityGroup": {
                                                                    "defaultSecurityRules": [
                                                                        {
                                                                            "access": "str",
                                                                            "description": "str",
                                                                            "destinationAddressPrefix": "str",
                                                                            "destinationAddressPrefixes": ["str"],
                                                                            "destinationApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "destinationPortRange": "str",
                                                                            "destinationPortRanges": ["str"],
                                                                            "direction": "str",
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "priority": 0,
                                                                            "protocol": "str",
                                                                            "provisioningState": "str",
                                                                            "sourceAddressPrefix": "str",
                                                                            "sourceAddressPrefixes": ["str"],
                                                                            "sourceApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "sourcePortRange": "str",
                                                                            "sourcePortRanges": ["str"],
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "etag": "str",
                                                                    "flowLogs": [
                                                                        {
                                                                            "enabled": bool,
                                                                            "enabledFilteringCriteria": "str",
                                                                            "etag": "str",
                                                                            "flowAnalyticsConfiguration": {
                                                                                "networkWatcherFlowAnalyticsConfiguration": {
                                                                                    "enabled": bool,
                                                                                    "trafficAnalyticsInterval": 0,
                                                                                    "workspaceId": "str",
                                                                                    "workspaceRegion": "str",
                                                                                    "workspaceResourceId": "str",
                                                                                }
                                                                            },
                                                                            "format": {"type": "str", "version": 0},
                                                                            "id": "str",
                                                                            "identity": {
                                                                                "principalId": "str",
                                                                                "tenantId": "str",
                                                                                "type": "str",
                                                                                "userAssignedIdentities": {
                                                                                    "str": {
                                                                                        "clientId": "str",
                                                                                        "principalId": "str",
                                                                                    }
                                                                                },
                                                                            },
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "recordTypes": "str",
                                                                            "retentionPolicy": {
                                                                                "days": 0,
                                                                                "enabled": False,
                                                                            },
                                                                            "storageId": "str",
                                                                            "tags": {"str": "str"},
                                                                            "targetResourceGuid": "str",
                                                                            "targetResourceId": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "flushConnection": bool,
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "networkInterfaces": [
                                                                        {
                                                                            "auxiliaryMode": "str",
                                                                            "auxiliarySku": "str",
                                                                            "defaultOutboundConnectivityEnabled": bool,
                                                                            "disableTcpStateTracking": bool,
                                                                            "dnsSettings": {
                                                                                "appliedDnsServers": ["str"],
                                                                                "dnsServers": ["str"],
                                                                                "internalDnsNameLabel": "str",
                                                                                "internalDomainNameSuffix": "str",
                                                                                "internalFqdn": "str",
                                                                            },
                                                                            "dscpConfiguration": {"id": "str"},
                                                                            "enableAcceleratedNetworking": bool,
                                                                            "enableIPForwarding": bool,
                                                                            "etag": "str",
                                                                            "extendedLocation": {
                                                                                "name": "str",
                                                                                "type": "str",
                                                                            },
                                                                            "hostedWorkloads": ["str"],
                                                                            "id": "str",
                                                                            "ipConfigurations": [...],
                                                                            "location": "str",
                                                                            "macAddress": "str",
                                                                            "migrationPhase": "str",
                                                                            "name": "str",
                                                                            "networkSecurityGroup": ...,
                                                                            "nicType": "str",
                                                                            "primary": bool,
                                                                            "privateEndpoint": {
                                                                                "applicationSecurityGroups": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "resourceGuid": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "customDnsConfigs": [
                                                                                    {
                                                                                        "fqdn": "str",
                                                                                        "ipAddresses": ["str"],
                                                                                    }
                                                                                ],
                                                                                "customNetworkInterfaceName": "str",
                                                                                "etag": "str",
                                                                                "extendedLocation": {
                                                                                    "name": "str",
                                                                                    "type": "str",
                                                                                },
                                                                                "id": "str",
                                                                                "ipConfigurations": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "groupId": "str",
                                                                                        "memberName": "str",
                                                                                        "name": "str",
                                                                                        "privateIPAddress": "str",
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "ipVersionType": "IPv4",
                                                                                "location": "str",
                                                                                "manualPrivateLinkServiceConnections": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "groupIds": ["str"],
                                                                                        "id": "str",
                                                                                        "name": "str",
                                                                                        "privateLinkServiceConnectionState": {
                                                                                            "actionsRequired": "str",
                                                                                            "description": "str",
                                                                                            "status": "str",
                                                                                        },
                                                                                        "privateLinkServiceId": "str",
                                                                                        "provisioningState": "str",
                                                                                        "requestMessage": "str",
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "name": "str",
                                                                                "networkInterfaces": [...],
                                                                                "privateLinkServiceConnections": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "groupIds": ["str"],
                                                                                        "id": "str",
                                                                                        "name": "str",
                                                                                        "privateLinkServiceConnectionState": {
                                                                                            "actionsRequired": "str",
                                                                                            "description": "str",
                                                                                            "status": "str",
                                                                                        },
                                                                                        "privateLinkServiceId": "str",
                                                                                        "provisioningState": "str",
                                                                                        "requestMessage": "str",
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "provisioningState": "str",
                                                                                "subnet": ...,
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            },
                                                                            "privateLinkService": {
                                                                                "accessMode": "str",
                                                                                "alias": "str",
                                                                                "autoApproval": {
                                                                                    "subscriptions": ["str"]
                                                                                },
                                                                                "destinationIPAddress": "str",
                                                                                "enableProxyProtocol": bool,
                                                                                "etag": "str",
                                                                                "extendedLocation": {
                                                                                    "name": "str",
                                                                                    "type": "str",
                                                                                },
                                                                                "fqdns": ["str"],
                                                                                "id": "str",
                                                                                "ipConfigurations": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "name": "str",
                                                                                        "primary": bool,
                                                                                        "privateIPAddress": "str",
                                                                                        "privateIPAddressVersion": "str",
                                                                                        "privateIPAllocationMethod": "str",
                                                                                        "provisioningState": "str",
                                                                                        "subnet": ...,
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "loadBalancerFrontendIpConfigurations": [
                                                                                    ...
                                                                                ],
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "networkInterfaces": [...],
                                                                                "privateEndpointConnections": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "linkIdentifier": "str",
                                                                                        "name": "str",
                                                                                        "privateEndpoint": {
                                                                                            "applicationSecurityGroups": [
                                                                                                {
                                                                                                    "etag": "str",
                                                                                                    "id": "str",
                                                                                                    "location": "str",
                                                                                                    "name": "str",
                                                                                                    "provisioningState": "str",
                                                                                                    "resourceGuid": "str",
                                                                                                    "tags": {
                                                                                                        "str": "str"
                                                                                                    },
                                                                                                    "type": "str",
                                                                                                }
                                                                                            ],
                                                                                            "customDnsConfigs": [
                                                                                                {
                                                                                                    "fqdn": "str",
                                                                                                    "ipAddresses": [
                                                                                                        "str"
                                                                                                    ],
                                                                                                }
                                                                                            ],
                                                                                            "customNetworkInterfaceName": "str",
                                                                                            "etag": "str",
                                                                                            "extendedLocation": {
                                                                                                "name": "str",
                                                                                                "type": "str",
                                                                                            },
                                                                                            "id": "str",
                                                                                            "ipConfigurations": [
                                                                                                {
                                                                                                    "etag": "str",
                                                                                                    "groupId": "str",
                                                                                                    "memberName": "str",
                                                                                                    "name": "str",
                                                                                                    "privateIPAddress": "str",
                                                                                                    "type": "str",
                                                                                                }
                                                                                            ],
                                                                                            "ipVersionType": "IPv4",
                                                                                            "location": "str",
                                                                                            "manualPrivateLinkServiceConnections": [
                                                                                                {
                                                                                                    "etag": "str",
                                                                                                    "groupIds": ["str"],
                                                                                                    "id": "str",
                                                                                                    "name": "str",
                                                                                                    "privateLinkServiceConnectionState": {
                                                                                                        "actionsRequired": "str",
                                                                                                        "description": "str",
                                                                                                        "status": "str",
                                                                                                    },
                                                                                                    "privateLinkServiceId": "str",
                                                                                                    "provisioningState": "str",
                                                                                                    "requestMessage": "str",
                                                                                                    "type": "str",
                                                                                                }
                                                                                            ],
                                                                                            "name": "str",
                                                                                            "networkInterfaces": [...],
                                                                                            "privateLinkServiceConnections": [
                                                                                                {
                                                                                                    "etag": "str",
                                                                                                    "groupIds": ["str"],
                                                                                                    "id": "str",
                                                                                                    "name": "str",
                                                                                                    "privateLinkServiceConnectionState": {
                                                                                                        "actionsRequired": "str",
                                                                                                        "description": "str",
                                                                                                        "status": "str",
                                                                                                    },
                                                                                                    "privateLinkServiceId": "str",
                                                                                                    "provisioningState": "str",
                                                                                                    "requestMessage": "str",
                                                                                                    "type": "str",
                                                                                                }
                                                                                            ],
                                                                                            "provisioningState": "str",
                                                                                            "subnet": ...,
                                                                                            "tags": {"str": "str"},
                                                                                            "type": "str",
                                                                                        },
                                                                                        "privateEndpointLocation": "str",
                                                                                        "privateLinkServiceConnectionState": {
                                                                                            "actionsRequired": "str",
                                                                                            "description": "str",
                                                                                            "status": "str",
                                                                                        },
                                                                                        "provisioningState": "str",
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "provisioningState": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                                "visibility": {
                                                                                    "subscriptions": ["str"]
                                                                                },
                                                                            },
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "tapConfigurations": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "type": "str",
                                                                                    "virtualNetworkTap": ...,
                                                                                }
                                                                            ],
                                                                            "type": "str",
                                                                            "virtualMachine": {"id": "str"},
                                                                            "vnetEncryptionSupported": bool,
                                                                            "workloadType": "str",
                                                                        }
                                                                    ],
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "securityRules": [
                                                                        {
                                                                            "access": "str",
                                                                            "description": "str",
                                                                            "destinationAddressPrefix": "str",
                                                                            "destinationAddressPrefixes": ["str"],
                                                                            "destinationApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "destinationPortRange": "str",
                                                                            "destinationPortRanges": ["str"],
                                                                            "direction": "str",
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "priority": 0,
                                                                            "protocol": "str",
                                                                            "provisioningState": "str",
                                                                            "sourceAddressPrefix": "str",
                                                                            "sourceAddressPrefixes": ["str"],
                                                                            "sourceApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "sourcePortRange": "str",
                                                                            "sourcePortRanges": ["str"],
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "subnets": [...],
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                },
                                                                "privateEndpointNetworkPolicies": "Disabled",
                                                                "privateEndpoints": [
                                                                    {
                                                                        "applicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "customDnsConfigs": [
                                                                            {"fqdn": "str", "ipAddresses": ["str"]}
                                                                        ],
                                                                        "customNetworkInterfaceName": "str",
                                                                        "etag": "str",
                                                                        "extendedLocation": {
                                                                            "name": "str",
                                                                            "type": "str",
                                                                        },
                                                                        "id": "str",
                                                                        "ipConfigurations": [
                                                                            {
                                                                                "etag": "str",
                                                                                "groupId": "str",
                                                                                "memberName": "str",
                                                                                "name": "str",
                                                                                "privateIPAddress": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "ipVersionType": "IPv4",
                                                                        "location": "str",
                                                                        "manualPrivateLinkServiceConnections": [
                                                                            {
                                                                                "etag": "str",
                                                                                "groupIds": ["str"],
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "privateLinkServiceConnectionState": {
                                                                                    "actionsRequired": "str",
                                                                                    "description": "str",
                                                                                    "status": "str",
                                                                                },
                                                                                "privateLinkServiceId": "str",
                                                                                "provisioningState": "str",
                                                                                "requestMessage": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "name": "str",
                                                                        "networkInterfaces": [
                                                                            {
                                                                                "auxiliaryMode": "str",
                                                                                "auxiliarySku": "str",
                                                                                "defaultOutboundConnectivityEnabled": bool,
                                                                                "disableTcpStateTracking": bool,
                                                                                "dnsSettings": {
                                                                                    "appliedDnsServers": ["str"],
                                                                                    "dnsServers": ["str"],
                                                                                    "internalDnsNameLabel": "str",
                                                                                    "internalDomainNameSuffix": "str",
                                                                                    "internalFqdn": "str",
                                                                                },
                                                                                "dscpConfiguration": {"id": "str"},
                                                                                "enableAcceleratedNetworking": bool,
                                                                                "enableIPForwarding": bool,
                                                                                "etag": "str",
                                                                                "extendedLocation": {
                                                                                    "name": "str",
                                                                                    "type": "str",
                                                                                },
                                                                                "hostedWorkloads": ["str"],
                                                                                "id": "str",
                                                                                "ipConfigurations": [...],
                                                                                "location": "str",
                                                                                "macAddress": "str",
                                                                                "migrationPhase": "str",
                                                                                "name": "str",
                                                                                "networkSecurityGroup": {
                                                                                    "defaultSecurityRules": [
                                                                                        {
                                                                                            "access": "str",
                                                                                            "description": "str",
                                                                                            "destinationAddressPrefix": "str",
                                                                                            "destinationAddressPrefixes": [
                                                                                                "str"
                                                                                            ],
                                                                                            "destinationApplicationSecurityGroups": [
                                                                                                {
                                                                                                    "etag": "str",
                                                                                                    "id": "str",
                                                                                                    "location": "str",
                                                                                                    "name": "str",
                                                                                                    "provisioningState": "str",
                                                                                                    "resourceGuid": "str",
                                                                                                    "tags": {
                                                                                                        "str": "str"
                                                                                                    },
                                                                                                    "type": "str",
                                                                                                }
                                                                                            ],
                                                                                            "destinationPortRange": "str",
                                                                                            "destinationPortRanges": [
                                                                                                "str"
                                                                                            ],
                                                                                            "direction": "str",
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "name": "str",
                                                                                            "priority": 0,
                                                                                            "protocol": "str",
                                                                                            "provisioningState": "str",
                                                                                            "sourceAddressPrefix": "str",
                                                                                            "sourceAddressPrefixes": [
                                                                                                "str"
                                                                                            ],
                                                                                            "sourceApplicationSecurityGroups": [
                                                                                                {
                                                                                                    "etag": "str",
                                                                                                    "id": "str",
                                                                                                    "location": "str",
                                                                                                    "name": "str",
                                                                                                    "provisioningState": "str",
                                                                                                    "resourceGuid": "str",
                                                                                                    "tags": {
                                                                                                        "str": "str"
                                                                                                    },
                                                                                                    "type": "str",
                                                                                                }
                                                                                            ],
                                                                                            "sourcePortRange": "str",
                                                                                            "sourcePortRanges": ["str"],
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "etag": "str",
                                                                                    "flowLogs": [
                                                                                        {
                                                                                            "enabled": bool,
                                                                                            "enabledFilteringCriteria": "str",
                                                                                            "etag": "str",
                                                                                            "flowAnalyticsConfiguration": {
                                                                                                "networkWatcherFlowAnalyticsConfiguration": {
                                                                                                    "enabled": bool,
                                                                                                    "trafficAnalyticsInterval": 0,
                                                                                                    "workspaceId": "str",
                                                                                                    "workspaceRegion": "str",
                                                                                                    "workspaceResourceId": "str",
                                                                                                }
                                                                                            },
                                                                                            "format": {
                                                                                                "type": "str",
                                                                                                "version": 0,
                                                                                            },
                                                                                            "id": "str",
                                                                                            "identity": {
                                                                                                "principalId": "str",
                                                                                                "tenantId": "str",
                                                                                                "type": "str",
                                                                                                "userAssignedIdentities": {
                                                                                                    "str": {
                                                                                                        "clientId": "str",
                                                                                                        "principalId": "str",
                                                                                                    }
                                                                                                },
                                                                                            },
                                                                                            "location": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "recordTypes": "str",
                                                                                            "retentionPolicy": {
                                                                                                "days": 0,
                                                                                                "enabled": False,
                                                                                            },
                                                                                            "storageId": "str",
                                                                                            "tags": {"str": "str"},
                                                                                            "targetResourceGuid": "str",
                                                                                            "targetResourceId": "str",
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "flushConnection": bool,
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "networkInterfaces": [...],
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "securityRules": [
                                                                                        {
                                                                                            "access": "str",
                                                                                            "description": "str",
                                                                                            "destinationAddressPrefix": "str",
                                                                                            "destinationAddressPrefixes": [
                                                                                                "str"
                                                                                            ],
                                                                                            "destinationApplicationSecurityGroups": [
                                                                                                {
                                                                                                    "etag": "str",
                                                                                                    "id": "str",
                                                                                                    "location": "str",
                                                                                                    "name": "str",
                                                                                                    "provisioningState": "str",
                                                                                                    "resourceGuid": "str",
                                                                                                    "tags": {
                                                                                                        "str": "str"
                                                                                                    },
                                                                                                    "type": "str",
                                                                                                }
                                                                                            ],
                                                                                            "destinationPortRange": "str",
                                                                                            "destinationPortRanges": [
                                                                                                "str"
                                                                                            ],
                                                                                            "direction": "str",
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "name": "str",
                                                                                            "priority": 0,
                                                                                            "protocol": "str",
                                                                                            "provisioningState": "str",
                                                                                            "sourceAddressPrefix": "str",
                                                                                            "sourceAddressPrefixes": [
                                                                                                "str"
                                                                                            ],
                                                                                            "sourceApplicationSecurityGroups": [
                                                                                                {
                                                                                                    "etag": "str",
                                                                                                    "id": "str",
                                                                                                    "location": "str",
                                                                                                    "name": "str",
                                                                                                    "provisioningState": "str",
                                                                                                    "resourceGuid": "str",
                                                                                                    "tags": {
                                                                                                        "str": "str"
                                                                                                    },
                                                                                                    "type": "str",
                                                                                                }
                                                                                            ],
                                                                                            "sourcePortRange": "str",
                                                                                            "sourcePortRanges": ["str"],
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "subnets": [...],
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                },
                                                                                "nicType": "str",
                                                                                "primary": bool,
                                                                                "privateEndpoint": ...,
                                                                                "privateLinkService": {
                                                                                    "accessMode": "str",
                                                                                    "alias": "str",
                                                                                    "autoApproval": {
                                                                                        "subscriptions": ["str"]
                                                                                    },
                                                                                    "destinationIPAddress": "str",
                                                                                    "enableProxyProtocol": bool,
                                                                                    "etag": "str",
                                                                                    "extendedLocation": {
                                                                                        "name": "str",
                                                                                        "type": "str",
                                                                                    },
                                                                                    "fqdns": ["str"],
                                                                                    "id": "str",
                                                                                    "ipConfigurations": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "name": "str",
                                                                                            "primary": bool,
                                                                                            "privateIPAddress": "str",
                                                                                            "privateIPAddressVersion": "str",
                                                                                            "privateIPAllocationMethod": "str",
                                                                                            "provisioningState": "str",
                                                                                            "subnet": ...,
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "loadBalancerFrontendIpConfigurations": [
                                                                                        ...
                                                                                    ],
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "networkInterfaces": [...],
                                                                                    "privateEndpointConnections": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "linkIdentifier": "str",
                                                                                            "name": "str",
                                                                                            "privateEndpoint": ...,
                                                                                            "privateEndpointLocation": "str",
                                                                                            "privateLinkServiceConnectionState": {
                                                                                                "actionsRequired": "str",
                                                                                                "description": "str",
                                                                                                "status": "str",
                                                                                            },
                                                                                            "provisioningState": "str",
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "provisioningState": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                    "visibility": {
                                                                                        "subscriptions": ["str"]
                                                                                    },
                                                                                },
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "tapConfigurations": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "type": "str",
                                                                                        "virtualNetworkTap": ...,
                                                                                    }
                                                                                ],
                                                                                "type": "str",
                                                                                "virtualMachine": {"id": "str"},
                                                                                "vnetEncryptionSupported": bool,
                                                                                "workloadType": "str",
                                                                            }
                                                                        ],
                                                                        "privateLinkServiceConnections": [
                                                                            {
                                                                                "etag": "str",
                                                                                "groupIds": ["str"],
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "privateLinkServiceConnectionState": {
                                                                                    "actionsRequired": "str",
                                                                                    "description": "str",
                                                                                    "status": "str",
                                                                                },
                                                                                "privateLinkServiceId": "str",
                                                                                "provisioningState": "str",
                                                                                "requestMessage": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "provisioningState": "str",
                                                                        "subnet": ...,
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "privateLinkServiceNetworkPolicies": "Enabled",
                                                                "provisioningState": "str",
                                                                "purpose": "str",
                                                                "resourceNavigationLinks": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "link": "str",
                                                                        "linkedResourceType": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "routeTable": {
                                                                    "disableBgpRoutePropagation": bool,
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "routes": [
                                                                        {
                                                                            "addressPrefix": "str",
                                                                            "etag": "str",
                                                                            "hasBgpOverride": bool,
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "nextHopIpAddress": "str",
                                                                            "nextHopType": "str",
                                                                            "provisioningState": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "subnets": [...],
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                },
                                                                "serviceAssociationLinks": [
                                                                    {
                                                                        "allowDelete": bool,
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "link": "str",
                                                                        "linkedResourceType": "str",
                                                                        "locations": ["str"],
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "serviceEndpointPolicies": [
                                                                    {
                                                                        "contextualServiceEndpointPolicies": ["str"],
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "kind": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "serviceAlias": "str",
                                                                        "serviceEndpointPolicyDefinitions": [
                                                                            {
                                                                                "description": "str",
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "service": "str",
                                                                                "serviceResources": ["str"],
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "subnets": [...],
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "serviceEndpoints": [
                                                                    {
                                                                        "locations": ["str"],
                                                                        "networkIdentifier": {"id": "str"},
                                                                        "provisioningState": "str",
                                                                        "service": "str",
                                                                    }
                                                                ],
                                                                "sharingScope": "str",
                                                                "type": "str",
                                                            },
                                                        },
                                                        "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                        "linkedPublicIPAddress": ...,
                                                        "location": "str",
                                                        "migrationPhase": "str",
                                                        "name": "str",
                                                        "natGateway": {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "idleTimeoutInMinutes": 0,
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "publicIpAddresses": [{"id": "str"}],
                                                            "publicIpAddressesV6": [{"id": "str"}],
                                                            "publicIpPrefixes": [{"id": "str"}],
                                                            "publicIpPrefixesV6": [{"id": "str"}],
                                                            "resourceGuid": "str",
                                                            "sku": {"name": "str"},
                                                            "sourceVirtualNetwork": {"id": "str"},
                                                            "subnets": [{"id": "str"}],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                            "zones": ["str"],
                                                        },
                                                        "provisioningState": "str",
                                                        "publicIPAddressVersion": "str",
                                                        "publicIPAllocationMethod": "str",
                                                        "publicIPPrefix": {"id": "str"},
                                                        "resourceGuid": "str",
                                                        "servicePublicIPAddress": ...,
                                                        "sku": {"name": "str", "tier": "str"},
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                        "zones": ["str"],
                                                    },
                                                    "publicIPPrefix": {"id": "str"},
                                                    "subnet": {
                                                        "addressPrefix": "str",
                                                        "addressPrefixes": ["str"],
                                                        "applicationGatewayIPConfigurations": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "subnet": {"id": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "defaultOutboundAccess": bool,
                                                        "delegations": [
                                                            {
                                                                "actions": ["str"],
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "serviceName": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "etag": "str",
                                                        "id": "str",
                                                        "ipAllocations": [{"id": "str"}],
                                                        "ipConfigurationProfiles": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "subnet": ...,
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "ipConfigurations": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "privateIPAddress": "str",
                                                                "privateIPAllocationMethod": "str",
                                                                "provisioningState": "str",
                                                                "publicIPAddress": {
                                                                    "ddosSettings": {
                                                                        "ddosProtectionPlan": {"id": "str"},
                                                                        "protectionMode": "str",
                                                                    },
                                                                    "deleteOption": "str",
                                                                    "dnsSettings": {
                                                                        "domainNameLabel": "str",
                                                                        "domainNameLabelScope": "str",
                                                                        "fqdn": "str",
                                                                        "reverseFqdn": "str",
                                                                    },
                                                                    "etag": "str",
                                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                                    "id": "str",
                                                                    "idleTimeoutInMinutes": 0,
                                                                    "ipAddress": "str",
                                                                    "ipConfiguration": ...,
                                                                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                    "linkedPublicIPAddress": ...,
                                                                    "location": "str",
                                                                    "migrationPhase": "str",
                                                                    "name": "str",
                                                                    "natGateway": {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "idleTimeoutInMinutes": 0,
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "publicIpAddresses": [{"id": "str"}],
                                                                        "publicIpAddressesV6": [{"id": "str"}],
                                                                        "publicIpPrefixes": [{"id": "str"}],
                                                                        "publicIpPrefixesV6": [{"id": "str"}],
                                                                        "resourceGuid": "str",
                                                                        "sku": {"name": "str"},
                                                                        "sourceVirtualNetwork": {"id": "str"},
                                                                        "subnets": [{"id": "str"}],
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                        "zones": ["str"],
                                                                    },
                                                                    "provisioningState": "str",
                                                                    "publicIPAddressVersion": "str",
                                                                    "publicIPAllocationMethod": "str",
                                                                    "publicIPPrefix": {"id": "str"},
                                                                    "resourceGuid": "str",
                                                                    "servicePublicIPAddress": ...,
                                                                    "sku": {"name": "str", "tier": "str"},
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                    "zones": ["str"],
                                                                },
                                                                "subnet": ...,
                                                            }
                                                        ],
                                                        "ipamPoolPrefixAllocations": [
                                                            {
                                                                "allocatedAddressPrefixes": ["str"],
                                                                "id": "str",
                                                                "numberOfIpAddresses": "str",
                                                            }
                                                        ],
                                                        "name": "str",
                                                        "natGateway": {"id": "str"},
                                                        "networkSecurityGroup": {
                                                            "defaultSecurityRules": [
                                                                {
                                                                    "access": "str",
                                                                    "description": "str",
                                                                    "destinationAddressPrefix": "str",
                                                                    "destinationAddressPrefixes": ["str"],
                                                                    "destinationApplicationSecurityGroups": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "destinationPortRange": "str",
                                                                    "destinationPortRanges": ["str"],
                                                                    "direction": "str",
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "priority": 0,
                                                                    "protocol": "str",
                                                                    "provisioningState": "str",
                                                                    "sourceAddressPrefix": "str",
                                                                    "sourceAddressPrefixes": ["str"],
                                                                    "sourceApplicationSecurityGroups": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "sourcePortRange": "str",
                                                                    "sourcePortRanges": ["str"],
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "etag": "str",
                                                            "flowLogs": [
                                                                {
                                                                    "enabled": bool,
                                                                    "enabledFilteringCriteria": "str",
                                                                    "etag": "str",
                                                                    "flowAnalyticsConfiguration": {
                                                                        "networkWatcherFlowAnalyticsConfiguration": {
                                                                            "enabled": bool,
                                                                            "trafficAnalyticsInterval": 0,
                                                                            "workspaceId": "str",
                                                                            "workspaceRegion": "str",
                                                                            "workspaceResourceId": "str",
                                                                        }
                                                                    },
                                                                    "format": {"type": "str", "version": 0},
                                                                    "id": "str",
                                                                    "identity": {
                                                                        "principalId": "str",
                                                                        "tenantId": "str",
                                                                        "type": "str",
                                                                        "userAssignedIdentities": {
                                                                            "str": {
                                                                                "clientId": "str",
                                                                                "principalId": "str",
                                                                            }
                                                                        },
                                                                    },
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "recordTypes": "str",
                                                                    "retentionPolicy": {"days": 0, "enabled": False},
                                                                    "storageId": "str",
                                                                    "tags": {"str": "str"},
                                                                    "targetResourceGuid": "str",
                                                                    "targetResourceId": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "flushConnection": bool,
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "networkInterfaces": [
                                                                {
                                                                    "auxiliaryMode": "str",
                                                                    "auxiliarySku": "str",
                                                                    "defaultOutboundConnectivityEnabled": bool,
                                                                    "disableTcpStateTracking": bool,
                                                                    "dnsSettings": {
                                                                        "appliedDnsServers": ["str"],
                                                                        "dnsServers": ["str"],
                                                                        "internalDnsNameLabel": "str",
                                                                        "internalDomainNameSuffix": "str",
                                                                        "internalFqdn": "str",
                                                                    },
                                                                    "dscpConfiguration": {"id": "str"},
                                                                    "enableAcceleratedNetworking": bool,
                                                                    "enableIPForwarding": bool,
                                                                    "etag": "str",
                                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                                    "hostedWorkloads": ["str"],
                                                                    "id": "str",
                                                                    "ipConfigurations": [...],
                                                                    "location": "str",
                                                                    "macAddress": "str",
                                                                    "migrationPhase": "str",
                                                                    "name": "str",
                                                                    "networkSecurityGroup": ...,
                                                                    "nicType": "str",
                                                                    "primary": bool,
                                                                    "privateEndpoint": {
                                                                        "applicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "customDnsConfigs": [
                                                                            {"fqdn": "str", "ipAddresses": ["str"]}
                                                                        ],
                                                                        "customNetworkInterfaceName": "str",
                                                                        "etag": "str",
                                                                        "extendedLocation": {
                                                                            "name": "str",
                                                                            "type": "str",
                                                                        },
                                                                        "id": "str",
                                                                        "ipConfigurations": [
                                                                            {
                                                                                "etag": "str",
                                                                                "groupId": "str",
                                                                                "memberName": "str",
                                                                                "name": "str",
                                                                                "privateIPAddress": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "ipVersionType": "IPv4",
                                                                        "location": "str",
                                                                        "manualPrivateLinkServiceConnections": [
                                                                            {
                                                                                "etag": "str",
                                                                                "groupIds": ["str"],
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "privateLinkServiceConnectionState": {
                                                                                    "actionsRequired": "str",
                                                                                    "description": "str",
                                                                                    "status": "str",
                                                                                },
                                                                                "privateLinkServiceId": "str",
                                                                                "provisioningState": "str",
                                                                                "requestMessage": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "name": "str",
                                                                        "networkInterfaces": [...],
                                                                        "privateLinkServiceConnections": [
                                                                            {
                                                                                "etag": "str",
                                                                                "groupIds": ["str"],
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "privateLinkServiceConnectionState": {
                                                                                    "actionsRequired": "str",
                                                                                    "description": "str",
                                                                                    "status": "str",
                                                                                },
                                                                                "privateLinkServiceId": "str",
                                                                                "provisioningState": "str",
                                                                                "requestMessage": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "provisioningState": "str",
                                                                        "subnet": ...,
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    },
                                                                    "privateLinkService": {
                                                                        "accessMode": "str",
                                                                        "alias": "str",
                                                                        "autoApproval": {"subscriptions": ["str"]},
                                                                        "destinationIPAddress": "str",
                                                                        "enableProxyProtocol": bool,
                                                                        "etag": "str",
                                                                        "extendedLocation": {
                                                                            "name": "str",
                                                                            "type": "str",
                                                                        },
                                                                        "fqdns": ["str"],
                                                                        "id": "str",
                                                                        "ipConfigurations": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "primary": bool,
                                                                                "privateIPAddress": "str",
                                                                                "privateIPAddressVersion": "str",
                                                                                "privateIPAllocationMethod": "str",
                                                                                "provisioningState": "str",
                                                                                "subnet": ...,
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "loadBalancerFrontendIpConfigurations": [...],
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "networkInterfaces": [...],
                                                                        "privateEndpointConnections": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "linkIdentifier": "str",
                                                                                "name": "str",
                                                                                "privateEndpoint": {
                                                                                    "applicationSecurityGroups": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "location": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "resourceGuid": "str",
                                                                                            "tags": {"str": "str"},
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "customDnsConfigs": [
                                                                                        {
                                                                                            "fqdn": "str",
                                                                                            "ipAddresses": ["str"],
                                                                                        }
                                                                                    ],
                                                                                    "customNetworkInterfaceName": "str",
                                                                                    "etag": "str",
                                                                                    "extendedLocation": {
                                                                                        "name": "str",
                                                                                        "type": "str",
                                                                                    },
                                                                                    "id": "str",
                                                                                    "ipConfigurations": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "groupId": "str",
                                                                                            "memberName": "str",
                                                                                            "name": "str",
                                                                                            "privateIPAddress": "str",
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "ipVersionType": "IPv4",
                                                                                    "location": "str",
                                                                                    "manualPrivateLinkServiceConnections": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "groupIds": ["str"],
                                                                                            "id": "str",
                                                                                            "name": "str",
                                                                                            "privateLinkServiceConnectionState": {
                                                                                                "actionsRequired": "str",
                                                                                                "description": "str",
                                                                                                "status": "str",
                                                                                            },
                                                                                            "privateLinkServiceId": "str",
                                                                                            "provisioningState": "str",
                                                                                            "requestMessage": "str",
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "name": "str",
                                                                                    "networkInterfaces": [...],
                                                                                    "privateLinkServiceConnections": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "groupIds": ["str"],
                                                                                            "id": "str",
                                                                                            "name": "str",
                                                                                            "privateLinkServiceConnectionState": {
                                                                                                "actionsRequired": "str",
                                                                                                "description": "str",
                                                                                                "status": "str",
                                                                                            },
                                                                                            "privateLinkServiceId": "str",
                                                                                            "provisioningState": "str",
                                                                                            "requestMessage": "str",
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "provisioningState": "str",
                                                                                    "subnet": ...,
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                },
                                                                                "privateEndpointLocation": "str",
                                                                                "privateLinkServiceConnectionState": {
                                                                                    "actionsRequired": "str",
                                                                                    "description": "str",
                                                                                    "status": "str",
                                                                                },
                                                                                "provisioningState": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "provisioningState": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                        "visibility": {"subscriptions": ["str"]},
                                                                    },
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "tapConfigurations": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "type": "str",
                                                                            "virtualNetworkTap": ...,
                                                                        }
                                                                    ],
                                                                    "type": "str",
                                                                    "virtualMachine": {"id": "str"},
                                                                    "vnetEncryptionSupported": bool,
                                                                    "workloadType": "str",
                                                                }
                                                            ],
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "securityRules": [
                                                                {
                                                                    "access": "str",
                                                                    "description": "str",
                                                                    "destinationAddressPrefix": "str",
                                                                    "destinationAddressPrefixes": ["str"],
                                                                    "destinationApplicationSecurityGroups": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "destinationPortRange": "str",
                                                                    "destinationPortRanges": ["str"],
                                                                    "direction": "str",
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "priority": 0,
                                                                    "protocol": "str",
                                                                    "provisioningState": "str",
                                                                    "sourceAddressPrefix": "str",
                                                                    "sourceAddressPrefixes": ["str"],
                                                                    "sourceApplicationSecurityGroups": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "sourcePortRange": "str",
                                                                    "sourcePortRanges": ["str"],
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "subnets": [...],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        },
                                                        "privateEndpointNetworkPolicies": "Disabled",
                                                        "privateEndpoints": [
                                                            {
                                                                "applicationSecurityGroups": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "customDnsConfigs": [
                                                                    {"fqdn": "str", "ipAddresses": ["str"]}
                                                                ],
                                                                "customNetworkInterfaceName": "str",
                                                                "etag": "str",
                                                                "extendedLocation": {"name": "str", "type": "str"},
                                                                "id": "str",
                                                                "ipConfigurations": [
                                                                    {
                                                                        "etag": "str",
                                                                        "groupId": "str",
                                                                        "memberName": "str",
                                                                        "name": "str",
                                                                        "privateIPAddress": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "ipVersionType": "IPv4",
                                                                "location": "str",
                                                                "manualPrivateLinkServiceConnections": [
                                                                    {
                                                                        "etag": "str",
                                                                        "groupIds": ["str"],
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "privateLinkServiceConnectionState": {
                                                                            "actionsRequired": "str",
                                                                            "description": "str",
                                                                            "status": "str",
                                                                        },
                                                                        "privateLinkServiceId": "str",
                                                                        "provisioningState": "str",
                                                                        "requestMessage": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "name": "str",
                                                                "networkInterfaces": [
                                                                    {
                                                                        "auxiliaryMode": "str",
                                                                        "auxiliarySku": "str",
                                                                        "defaultOutboundConnectivityEnabled": bool,
                                                                        "disableTcpStateTracking": bool,
                                                                        "dnsSettings": {
                                                                            "appliedDnsServers": ["str"],
                                                                            "dnsServers": ["str"],
                                                                            "internalDnsNameLabel": "str",
                                                                            "internalDomainNameSuffix": "str",
                                                                            "internalFqdn": "str",
                                                                        },
                                                                        "dscpConfiguration": {"id": "str"},
                                                                        "enableAcceleratedNetworking": bool,
                                                                        "enableIPForwarding": bool,
                                                                        "etag": "str",
                                                                        "extendedLocation": {
                                                                            "name": "str",
                                                                            "type": "str",
                                                                        },
                                                                        "hostedWorkloads": ["str"],
                                                                        "id": "str",
                                                                        "ipConfigurations": [...],
                                                                        "location": "str",
                                                                        "macAddress": "str",
                                                                        "migrationPhase": "str",
                                                                        "name": "str",
                                                                        "networkSecurityGroup": {
                                                                            "defaultSecurityRules": [
                                                                                {
                                                                                    "access": "str",
                                                                                    "description": "str",
                                                                                    "destinationAddressPrefix": "str",
                                                                                    "destinationAddressPrefixes": [
                                                                                        "str"
                                                                                    ],
                                                                                    "destinationApplicationSecurityGroups": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "location": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "resourceGuid": "str",
                                                                                            "tags": {"str": "str"},
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "destinationPortRange": "str",
                                                                                    "destinationPortRanges": ["str"],
                                                                                    "direction": "str",
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "priority": 0,
                                                                                    "protocol": "str",
                                                                                    "provisioningState": "str",
                                                                                    "sourceAddressPrefix": "str",
                                                                                    "sourceAddressPrefixes": ["str"],
                                                                                    "sourceApplicationSecurityGroups": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "location": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "resourceGuid": "str",
                                                                                            "tags": {"str": "str"},
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "sourcePortRange": "str",
                                                                                    "sourcePortRanges": ["str"],
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "etag": "str",
                                                                            "flowLogs": [
                                                                                {
                                                                                    "enabled": bool,
                                                                                    "enabledFilteringCriteria": "str",
                                                                                    "etag": "str",
                                                                                    "flowAnalyticsConfiguration": {
                                                                                        "networkWatcherFlowAnalyticsConfiguration": {
                                                                                            "enabled": bool,
                                                                                            "trafficAnalyticsInterval": 0,
                                                                                            "workspaceId": "str",
                                                                                            "workspaceRegion": "str",
                                                                                            "workspaceResourceId": "str",
                                                                                        }
                                                                                    },
                                                                                    "format": {
                                                                                        "type": "str",
                                                                                        "version": 0,
                                                                                    },
                                                                                    "id": "str",
                                                                                    "identity": {
                                                                                        "principalId": "str",
                                                                                        "tenantId": "str",
                                                                                        "type": "str",
                                                                                        "userAssignedIdentities": {
                                                                                            "str": {
                                                                                                "clientId": "str",
                                                                                                "principalId": "str",
                                                                                            }
                                                                                        },
                                                                                    },
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "recordTypes": "str",
                                                                                    "retentionPolicy": {
                                                                                        "days": 0,
                                                                                        "enabled": False,
                                                                                    },
                                                                                    "storageId": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "targetResourceGuid": "str",
                                                                                    "targetResourceId": "str",
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "flushConnection": bool,
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "networkInterfaces": [...],
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "securityRules": [
                                                                                {
                                                                                    "access": "str",
                                                                                    "description": "str",
                                                                                    "destinationAddressPrefix": "str",
                                                                                    "destinationAddressPrefixes": [
                                                                                        "str"
                                                                                    ],
                                                                                    "destinationApplicationSecurityGroups": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "location": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "resourceGuid": "str",
                                                                                            "tags": {"str": "str"},
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "destinationPortRange": "str",
                                                                                    "destinationPortRanges": ["str"],
                                                                                    "direction": "str",
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "priority": 0,
                                                                                    "protocol": "str",
                                                                                    "provisioningState": "str",
                                                                                    "sourceAddressPrefix": "str",
                                                                                    "sourceAddressPrefixes": ["str"],
                                                                                    "sourceApplicationSecurityGroups": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "location": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "resourceGuid": "str",
                                                                                            "tags": {"str": "str"},
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "sourcePortRange": "str",
                                                                                    "sourcePortRanges": ["str"],
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "subnets": [...],
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        },
                                                                        "nicType": "str",
                                                                        "primary": bool,
                                                                        "privateEndpoint": ...,
                                                                        "privateLinkService": {
                                                                            "accessMode": "str",
                                                                            "alias": "str",
                                                                            "autoApproval": {"subscriptions": ["str"]},
                                                                            "destinationIPAddress": "str",
                                                                            "enableProxyProtocol": bool,
                                                                            "etag": "str",
                                                                            "extendedLocation": {
                                                                                "name": "str",
                                                                                "type": "str",
                                                                            },
                                                                            "fqdns": ["str"],
                                                                            "id": "str",
                                                                            "ipConfigurations": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "primary": bool,
                                                                                    "privateIPAddress": "str",
                                                                                    "privateIPAddressVersion": "str",
                                                                                    "privateIPAllocationMethod": "str",
                                                                                    "provisioningState": "str",
                                                                                    "subnet": ...,
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "loadBalancerFrontendIpConfigurations": [
                                                                                ...
                                                                            ],
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "networkInterfaces": [...],
                                                                            "privateEndpointConnections": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "linkIdentifier": "str",
                                                                                    "name": "str",
                                                                                    "privateEndpoint": ...,
                                                                                    "privateEndpointLocation": "str",
                                                                                    "privateLinkServiceConnectionState": {
                                                                                        "actionsRequired": "str",
                                                                                        "description": "str",
                                                                                        "status": "str",
                                                                                    },
                                                                                    "provisioningState": "str",
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "provisioningState": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                            "visibility": {"subscriptions": ["str"]},
                                                                        },
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "tags": {"str": "str"},
                                                                        "tapConfigurations": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "type": "str",
                                                                                "virtualNetworkTap": ...,
                                                                            }
                                                                        ],
                                                                        "type": "str",
                                                                        "virtualMachine": {"id": "str"},
                                                                        "vnetEncryptionSupported": bool,
                                                                        "workloadType": "str",
                                                                    }
                                                                ],
                                                                "privateLinkServiceConnections": [
                                                                    {
                                                                        "etag": "str",
                                                                        "groupIds": ["str"],
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "privateLinkServiceConnectionState": {
                                                                            "actionsRequired": "str",
                                                                            "description": "str",
                                                                            "status": "str",
                                                                        },
                                                                        "privateLinkServiceId": "str",
                                                                        "provisioningState": "str",
                                                                        "requestMessage": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "provisioningState": "str",
                                                                "subnet": ...,
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "privateLinkServiceNetworkPolicies": "Enabled",
                                                        "provisioningState": "str",
                                                        "purpose": "str",
                                                        "resourceNavigationLinks": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "link": "str",
                                                                "linkedResourceType": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "routeTable": {
                                                            "disableBgpRoutePropagation": bool,
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "routes": [
                                                                {
                                                                    "addressPrefix": "str",
                                                                    "etag": "str",
                                                                    "hasBgpOverride": bool,
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "nextHopIpAddress": "str",
                                                                    "nextHopType": "str",
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "subnets": [...],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        },
                                                        "serviceAssociationLinks": [
                                                            {
                                                                "allowDelete": bool,
                                                                "etag": "str",
                                                                "id": "str",
                                                                "link": "str",
                                                                "linkedResourceType": "str",
                                                                "locations": ["str"],
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "serviceEndpointPolicies": [
                                                            {
                                                                "contextualServiceEndpointPolicies": ["str"],
                                                                "etag": "str",
                                                                "id": "str",
                                                                "kind": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "serviceAlias": "str",
                                                                "serviceEndpointPolicyDefinitions": [
                                                                    {
                                                                        "description": "str",
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "service": "str",
                                                                        "serviceResources": ["str"],
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "subnets": [...],
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "serviceEndpoints": [
                                                            {
                                                                "locations": ["str"],
                                                                "networkIdentifier": {"id": "str"},
                                                                "provisioningState": "str",
                                                                "service": "str",
                                                            }
                                                        ],
                                                        "sharingScope": "str",
                                                        "type": "str",
                                                    },
                                                    "type": "str",
                                                    "zones": ["str"],
                                                },
                                                "destinationNetworkInterfaceIPConfiguration": ...,
                                                "destinationPort": 0,
                                                "etag": "str",
                                                "id": "str",
                                                "location": "str",
                                                "name": "str",
                                                "networkInterfaceTapConfigurations": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "type": "str",
                                                        "virtualNetworkTap": ...,
                                                    }
                                                ],
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            }
                                        ],
                                    }
                                ],
                                "etag": "str",
                                "id": "str",
                                "name": "str",
                                "provisioningState": "str",
                                "type": "str",
                            }
                        ],
                        "backendHttpSettingsCollection": [
                            {
                                "affinityCookieName": "str",
                                "authenticationCertificates": [{"id": "str"}],
                                "connectionDraining": {"drainTimeoutInSec": 0, "enabled": bool},
                                "cookieBasedAffinity": "str",
                                "dedicatedBackendConnection": bool,
                                "etag": "str",
                                "hostName": "str",
                                "id": "str",
                                "name": "str",
                                "path": "str",
                                "pickHostNameFromBackendAddress": bool,
                                "port": 0,
                                "probe": {"id": "str"},
                                "probeEnabled": bool,
                                "protocol": "str",
                                "provisioningState": "str",
                                "requestTimeout": 0,
                                "sniName": "str",
                                "trustedRootCertificates": [{"id": "str"}],
                                "type": "str",
                                "validateCertChainAndExpiry": True,
                                "validateSNI": True,
                            }
                        ],
                        "backendSettingsCollection": [
                            {
                                "enableL4ClientIpPreservation": bool,
                                "etag": "str",
                                "hostName": "str",
                                "id": "str",
                                "name": "str",
                                "pickHostNameFromBackendAddress": bool,
                                "port": 0,
                                "probe": {"id": "str"},
                                "protocol": "str",
                                "provisioningState": "str",
                                "timeout": 0,
                                "trustedRootCertificates": [{"id": "str"}],
                                "type": "str",
                            }
                        ],
                        "customErrorConfigurations": [{"customErrorPageUrl": "str", "statusCode": "str"}],
                        "defaultPredefinedSslPolicy": "str",
                        "enableFips": bool,
                        "enableHttp2": bool,
                        "entraJWTValidationConfigs": [
                            {
                                "audiences": ["str"],
                                "clientId": "str",
                                "etag": "str",
                                "id": "str",
                                "name": "str",
                                "provisioningState": "str",
                                "tenantId": "str",
                                "unAuthorizedRequestAction": "str",
                            }
                        ],
                        "etag": "str",
                        "firewallPolicy": {"id": "str"},
                        "forceFirewallPolicyAssociation": bool,
                        "frontendIPConfigurations": [
                            {
                                "etag": "str",
                                "id": "str",
                                "name": "str",
                                "privateIPAddress": "str",
                                "privateIPAllocationMethod": "str",
                                "privateLinkConfiguration": {"id": "str"},
                                "provisioningState": "str",
                                "publicIPAddress": {"id": "str"},
                                "subnet": {"id": "str"},
                                "type": "str",
                            }
                        ],
                        "frontendPorts": [
                            {
                                "etag": "str",
                                "id": "str",
                                "name": "str",
                                "port": 0,
                                "provisioningState": "str",
                                "type": "str",
                            }
                        ],
                        "gatewayIPConfigurations": [
                            {
                                "etag": "str",
                                "id": "str",
                                "name": "str",
                                "provisioningState": "str",
                                "subnet": {"id": "str"},
                                "type": "str",
                            }
                        ],
                        "globalConfiguration": {"enableRequestBuffering": bool, "enableResponseBuffering": bool},
                        "httpListeners": [
                            {
                                "customErrorConfigurations": [{"customErrorPageUrl": "str", "statusCode": "str"}],
                                "etag": "str",
                                "firewallPolicy": {"id": "str"},
                                "frontendIPConfiguration": {"id": "str"},
                                "frontendPort": {"id": "str"},
                                "hostName": "str",
                                "hostNames": ["str"],
                                "id": "str",
                                "name": "str",
                                "protocol": "str",
                                "provisioningState": "str",
                                "requireServerNameIndication": bool,
                                "sslCertificate": {"id": "str"},
                                "sslProfile": {"id": "str"},
                                "type": "str",
                            }
                        ],
                        "id": "str",
                        "identity": {
                            "principalId": "str",
                            "tenantId": "str",
                            "type": "str",
                            "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                        },
                        "listeners": [
                            {
                                "etag": "str",
                                "frontendIPConfiguration": {"id": "str"},
                                "frontendPort": {"id": "str"},
                                "hostNames": ["str"],
                                "id": "str",
                                "name": "str",
                                "protocol": "str",
                                "provisioningState": "str",
                                "sslCertificate": {"id": "str"},
                                "sslProfile": {"id": "str"},
                                "type": "str",
                            }
                        ],
                        "loadDistributionPolicies": [
                            {
                                "etag": "str",
                                "id": "str",
                                "loadDistributionAlgorithm": "str",
                                "loadDistributionTargets": [
                                    {
                                        "backendAddressPool": {"id": "str"},
                                        "etag": "str",
                                        "id": "str",
                                        "name": "str",
                                        "type": "str",
                                        "weightPerServer": 0,
                                    }
                                ],
                                "name": "str",
                                "provisioningState": "str",
                                "type": "str",
                            }
                        ],
                        "location": "str",
                        "name": "str",
                        "operationalState": "str",
                        "privateEndpointConnections": [
                            {
                                "etag": "str",
                                "id": "str",
                                "linkIdentifier": "str",
                                "name": "str",
                                "privateEndpoint": {
                                    "applicationSecurityGroups": [
                                        {
                                            "etag": "str",
                                            "id": "str",
                                            "location": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "tags": {"str": "str"},
                                            "type": "str",
                                        }
                                    ],
                                    "customDnsConfigs": [{"fqdn": "str", "ipAddresses": ["str"]}],
                                    "customNetworkInterfaceName": "str",
                                    "etag": "str",
                                    "extendedLocation": {"name": "str", "type": "str"},
                                    "id": "str",
                                    "ipConfigurations": [
                                        {
                                            "etag": "str",
                                            "groupId": "str",
                                            "memberName": "str",
                                            "name": "str",
                                            "privateIPAddress": "str",
                                            "type": "str",
                                        }
                                    ],
                                    "ipVersionType": "IPv4",
                                    "location": "str",
                                    "manualPrivateLinkServiceConnections": [
                                        {
                                            "etag": "str",
                                            "groupIds": ["str"],
                                            "id": "str",
                                            "name": "str",
                                            "privateLinkServiceConnectionState": {
                                                "actionsRequired": "str",
                                                "description": "str",
                                                "status": "str",
                                            },
                                            "privateLinkServiceId": "str",
                                            "provisioningState": "str",
                                            "requestMessage": "str",
                                            "type": "str",
                                        }
                                    ],
                                    "name": "str",
                                    "networkInterfaces": [
                                        {
                                            "auxiliaryMode": "str",
                                            "auxiliarySku": "str",
                                            "defaultOutboundConnectivityEnabled": bool,
                                            "disableTcpStateTracking": bool,
                                            "dnsSettings": {
                                                "appliedDnsServers": ["str"],
                                                "dnsServers": ["str"],
                                                "internalDnsNameLabel": "str",
                                                "internalDomainNameSuffix": "str",
                                                "internalFqdn": "str",
                                            },
                                            "dscpConfiguration": {"id": "str"},
                                            "enableAcceleratedNetworking": bool,
                                            "enableIPForwarding": bool,
                                            "etag": "str",
                                            "extendedLocation": {"name": "str", "type": "str"},
                                            "hostedWorkloads": ["str"],
                                            "id": "str",
                                            "ipConfigurations": [
                                                {
                                                    "applicationGatewayBackendAddressPools": [
                                                        {
                                                            "backendAddresses": [{"fqdn": "str", "ipAddress": "str"}],
                                                            "backendIPConfigurations": [...],
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "applicationSecurityGroups": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "etag": "str",
                                                    "gatewayLoadBalancer": {"id": "str"},
                                                    "id": "str",
                                                    "loadBalancerBackendAddressPools": [
                                                        {
                                                            "backendIPConfigurations": [...],
                                                            "drainPeriodInSeconds": 0,
                                                            "etag": "str",
                                                            "id": "str",
                                                            "inboundNatRules": [{"id": "str"}],
                                                            "loadBalancerBackendAddresses": [
                                                                {
                                                                    "adminState": "str",
                                                                    "inboundNatRulesPortMapping": [
                                                                        {
                                                                            "backendPort": 0,
                                                                            "frontendPort": 0,
                                                                            "inboundNatRuleName": "str",
                                                                        }
                                                                    ],
                                                                    "ipAddress": "str",
                                                                    "loadBalancerFrontendIPConfiguration": {
                                                                        "id": "str"
                                                                    },
                                                                    "name": "str",
                                                                    "networkInterfaceIPConfiguration": {"id": "str"},
                                                                    "subnet": {"id": "str"},
                                                                    "virtualNetwork": {"id": "str"},
                                                                }
                                                            ],
                                                            "loadBalancingRules": [{"id": "str"}],
                                                            "location": "str",
                                                            "name": "str",
                                                            "outboundRule": {"id": "str"},
                                                            "outboundRules": [{"id": "str"}],
                                                            "provisioningState": "str",
                                                            "syncMode": "str",
                                                            "tunnelInterfaces": [
                                                                {
                                                                    "identifier": 0,
                                                                    "port": 0,
                                                                    "protocol": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "type": "str",
                                                            "virtualNetwork": {"id": "str"},
                                                        }
                                                    ],
                                                    "loadBalancerInboundNatRules": [
                                                        {
                                                            "backendAddressPool": {"id": "str"},
                                                            "backendIPConfiguration": ...,
                                                            "backendPort": 0,
                                                            "enableFloatingIP": bool,
                                                            "enableTcpReset": bool,
                                                            "etag": "str",
                                                            "frontendIPConfiguration": {"id": "str"},
                                                            "frontendPort": 0,
                                                            "frontendPortRangeEnd": 0,
                                                            "frontendPortRangeStart": 0,
                                                            "id": "str",
                                                            "idleTimeoutInMinutes": 0,
                                                            "name": "str",
                                                            "protocol": "str",
                                                            "provisioningState": "str",
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "name": "str",
                                                    "primary": bool,
                                                    "privateIPAddress": "str",
                                                    "privateIPAddressPrefixLength": 0,
                                                    "privateIPAddressVersion": "str",
                                                    "privateIPAllocationMethod": "str",
                                                    "privateLinkConnectionProperties": {
                                                        "fqdns": ["str"],
                                                        "groupId": "str",
                                                        "requiredMemberName": "str",
                                                    },
                                                    "provisioningState": "str",
                                                    "publicIPAddress": {
                                                        "ddosSettings": {
                                                            "ddosProtectionPlan": {"id": "str"},
                                                            "protectionMode": "str",
                                                        },
                                                        "deleteOption": "str",
                                                        "dnsSettings": {
                                                            "domainNameLabel": "str",
                                                            "domainNameLabelScope": "str",
                                                            "fqdn": "str",
                                                            "reverseFqdn": "str",
                                                        },
                                                        "etag": "str",
                                                        "extendedLocation": {"name": "str", "type": "str"},
                                                        "id": "str",
                                                        "idleTimeoutInMinutes": 0,
                                                        "ipAddress": "str",
                                                        "ipConfiguration": {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "privateIPAddress": "str",
                                                            "privateIPAllocationMethod": "str",
                                                            "provisioningState": "str",
                                                            "publicIPAddress": ...,
                                                            "subnet": {
                                                                "addressPrefix": "str",
                                                                "addressPrefixes": ["str"],
                                                                "applicationGatewayIPConfigurations": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "subnet": {"id": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "defaultOutboundAccess": bool,
                                                                "delegations": [
                                                                    {
                                                                        "actions": ["str"],
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "serviceName": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "etag": "str",
                                                                "id": "str",
                                                                "ipAllocations": [{"id": "str"}],
                                                                "ipConfigurationProfiles": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "subnet": ...,
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "ipConfigurations": [...],
                                                                "ipamPoolPrefixAllocations": [
                                                                    {
                                                                        "allocatedAddressPrefixes": ["str"],
                                                                        "id": "str",
                                                                        "numberOfIpAddresses": "str",
                                                                    }
                                                                ],
                                                                "name": "str",
                                                                "natGateway": {"id": "str"},
                                                                "networkSecurityGroup": {
                                                                    "defaultSecurityRules": [
                                                                        {
                                                                            "access": "str",
                                                                            "description": "str",
                                                                            "destinationAddressPrefix": "str",
                                                                            "destinationAddressPrefixes": ["str"],
                                                                            "destinationApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "destinationPortRange": "str",
                                                                            "destinationPortRanges": ["str"],
                                                                            "direction": "str",
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "priority": 0,
                                                                            "protocol": "str",
                                                                            "provisioningState": "str",
                                                                            "sourceAddressPrefix": "str",
                                                                            "sourceAddressPrefixes": ["str"],
                                                                            "sourceApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "sourcePortRange": "str",
                                                                            "sourcePortRanges": ["str"],
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "etag": "str",
                                                                    "flowLogs": [
                                                                        {
                                                                            "enabled": bool,
                                                                            "enabledFilteringCriteria": "str",
                                                                            "etag": "str",
                                                                            "flowAnalyticsConfiguration": {
                                                                                "networkWatcherFlowAnalyticsConfiguration": {
                                                                                    "enabled": bool,
                                                                                    "trafficAnalyticsInterval": 0,
                                                                                    "workspaceId": "str",
                                                                                    "workspaceRegion": "str",
                                                                                    "workspaceResourceId": "str",
                                                                                }
                                                                            },
                                                                            "format": {"type": "str", "version": 0},
                                                                            "id": "str",
                                                                            "identity": {
                                                                                "principalId": "str",
                                                                                "tenantId": "str",
                                                                                "type": "str",
                                                                                "userAssignedIdentities": {
                                                                                    "str": {
                                                                                        "clientId": "str",
                                                                                        "principalId": "str",
                                                                                    }
                                                                                },
                                                                            },
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "recordTypes": "str",
                                                                            "retentionPolicy": {
                                                                                "days": 0,
                                                                                "enabled": False,
                                                                            },
                                                                            "storageId": "str",
                                                                            "tags": {"str": "str"},
                                                                            "targetResourceGuid": "str",
                                                                            "targetResourceId": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "flushConnection": bool,
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "networkInterfaces": [...],
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "securityRules": [
                                                                        {
                                                                            "access": "str",
                                                                            "description": "str",
                                                                            "destinationAddressPrefix": "str",
                                                                            "destinationAddressPrefixes": ["str"],
                                                                            "destinationApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "destinationPortRange": "str",
                                                                            "destinationPortRanges": ["str"],
                                                                            "direction": "str",
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "priority": 0,
                                                                            "protocol": "str",
                                                                            "provisioningState": "str",
                                                                            "sourceAddressPrefix": "str",
                                                                            "sourceAddressPrefixes": ["str"],
                                                                            "sourceApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "sourcePortRange": "str",
                                                                            "sourcePortRanges": ["str"],
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "subnets": [...],
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                },
                                                                "privateEndpointNetworkPolicies": "Disabled",
                                                                "privateEndpoints": [...],
                                                                "privateLinkServiceNetworkPolicies": "Enabled",
                                                                "provisioningState": "str",
                                                                "purpose": "str",
                                                                "resourceNavigationLinks": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "link": "str",
                                                                        "linkedResourceType": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "routeTable": {
                                                                    "disableBgpRoutePropagation": bool,
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "routes": [
                                                                        {
                                                                            "addressPrefix": "str",
                                                                            "etag": "str",
                                                                            "hasBgpOverride": bool,
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "nextHopIpAddress": "str",
                                                                            "nextHopType": "str",
                                                                            "provisioningState": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "subnets": [...],
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                },
                                                                "serviceAssociationLinks": [
                                                                    {
                                                                        "allowDelete": bool,
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "link": "str",
                                                                        "linkedResourceType": "str",
                                                                        "locations": ["str"],
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "serviceEndpointPolicies": [
                                                                    {
                                                                        "contextualServiceEndpointPolicies": ["str"],
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "kind": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "serviceAlias": "str",
                                                                        "serviceEndpointPolicyDefinitions": [
                                                                            {
                                                                                "description": "str",
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "service": "str",
                                                                                "serviceResources": ["str"],
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "subnets": [...],
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "serviceEndpoints": [
                                                                    {
                                                                        "locations": ["str"],
                                                                        "networkIdentifier": {"id": "str"},
                                                                        "provisioningState": "str",
                                                                        "service": "str",
                                                                    }
                                                                ],
                                                                "sharingScope": "str",
                                                                "type": "str",
                                                            },
                                                        },
                                                        "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                        "linkedPublicIPAddress": ...,
                                                        "location": "str",
                                                        "migrationPhase": "str",
                                                        "name": "str",
                                                        "natGateway": {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "idleTimeoutInMinutes": 0,
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "publicIpAddresses": [{"id": "str"}],
                                                            "publicIpAddressesV6": [{"id": "str"}],
                                                            "publicIpPrefixes": [{"id": "str"}],
                                                            "publicIpPrefixesV6": [{"id": "str"}],
                                                            "resourceGuid": "str",
                                                            "sku": {"name": "str"},
                                                            "sourceVirtualNetwork": {"id": "str"},
                                                            "subnets": [{"id": "str"}],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                            "zones": ["str"],
                                                        },
                                                        "provisioningState": "str",
                                                        "publicIPAddressVersion": "str",
                                                        "publicIPAllocationMethod": "str",
                                                        "publicIPPrefix": {"id": "str"},
                                                        "resourceGuid": "str",
                                                        "servicePublicIPAddress": ...,
                                                        "sku": {"name": "str", "tier": "str"},
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                        "zones": ["str"],
                                                    },
                                                    "subnet": {
                                                        "addressPrefix": "str",
                                                        "addressPrefixes": ["str"],
                                                        "applicationGatewayIPConfigurations": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "subnet": {"id": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "defaultOutboundAccess": bool,
                                                        "delegations": [
                                                            {
                                                                "actions": ["str"],
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "serviceName": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "etag": "str",
                                                        "id": "str",
                                                        "ipAllocations": [{"id": "str"}],
                                                        "ipConfigurationProfiles": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "subnet": ...,
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "ipConfigurations": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "privateIPAddress": "str",
                                                                "privateIPAllocationMethod": "str",
                                                                "provisioningState": "str",
                                                                "publicIPAddress": {
                                                                    "ddosSettings": {
                                                                        "ddosProtectionPlan": {"id": "str"},
                                                                        "protectionMode": "str",
                                                                    },
                                                                    "deleteOption": "str",
                                                                    "dnsSettings": {
                                                                        "domainNameLabel": "str",
                                                                        "domainNameLabelScope": "str",
                                                                        "fqdn": "str",
                                                                        "reverseFqdn": "str",
                                                                    },
                                                                    "etag": "str",
                                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                                    "id": "str",
                                                                    "idleTimeoutInMinutes": 0,
                                                                    "ipAddress": "str",
                                                                    "ipConfiguration": ...,
                                                                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                    "linkedPublicIPAddress": ...,
                                                                    "location": "str",
                                                                    "migrationPhase": "str",
                                                                    "name": "str",
                                                                    "natGateway": {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "idleTimeoutInMinutes": 0,
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "publicIpAddresses": [{"id": "str"}],
                                                                        "publicIpAddressesV6": [{"id": "str"}],
                                                                        "publicIpPrefixes": [{"id": "str"}],
                                                                        "publicIpPrefixesV6": [{"id": "str"}],
                                                                        "resourceGuid": "str",
                                                                        "sku": {"name": "str"},
                                                                        "sourceVirtualNetwork": {"id": "str"},
                                                                        "subnets": [{"id": "str"}],
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                        "zones": ["str"],
                                                                    },
                                                                    "provisioningState": "str",
                                                                    "publicIPAddressVersion": "str",
                                                                    "publicIPAllocationMethod": "str",
                                                                    "publicIPPrefix": {"id": "str"},
                                                                    "resourceGuid": "str",
                                                                    "servicePublicIPAddress": ...,
                                                                    "sku": {"name": "str", "tier": "str"},
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                    "zones": ["str"],
                                                                },
                                                                "subnet": ...,
                                                            }
                                                        ],
                                                        "ipamPoolPrefixAllocations": [
                                                            {
                                                                "allocatedAddressPrefixes": ["str"],
                                                                "id": "str",
                                                                "numberOfIpAddresses": "str",
                                                            }
                                                        ],
                                                        "name": "str",
                                                        "natGateway": {"id": "str"},
                                                        "networkSecurityGroup": {
                                                            "defaultSecurityRules": [
                                                                {
                                                                    "access": "str",
                                                                    "description": "str",
                                                                    "destinationAddressPrefix": "str",
                                                                    "destinationAddressPrefixes": ["str"],
                                                                    "destinationApplicationSecurityGroups": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "destinationPortRange": "str",
                                                                    "destinationPortRanges": ["str"],
                                                                    "direction": "str",
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "priority": 0,
                                                                    "protocol": "str",
                                                                    "provisioningState": "str",
                                                                    "sourceAddressPrefix": "str",
                                                                    "sourceAddressPrefixes": ["str"],
                                                                    "sourceApplicationSecurityGroups": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "sourcePortRange": "str",
                                                                    "sourcePortRanges": ["str"],
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "etag": "str",
                                                            "flowLogs": [
                                                                {
                                                                    "enabled": bool,
                                                                    "enabledFilteringCriteria": "str",
                                                                    "etag": "str",
                                                                    "flowAnalyticsConfiguration": {
                                                                        "networkWatcherFlowAnalyticsConfiguration": {
                                                                            "enabled": bool,
                                                                            "trafficAnalyticsInterval": 0,
                                                                            "workspaceId": "str",
                                                                            "workspaceRegion": "str",
                                                                            "workspaceResourceId": "str",
                                                                        }
                                                                    },
                                                                    "format": {"type": "str", "version": 0},
                                                                    "id": "str",
                                                                    "identity": {
                                                                        "principalId": "str",
                                                                        "tenantId": "str",
                                                                        "type": "str",
                                                                        "userAssignedIdentities": {
                                                                            "str": {
                                                                                "clientId": "str",
                                                                                "principalId": "str",
                                                                            }
                                                                        },
                                                                    },
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "recordTypes": "str",
                                                                    "retentionPolicy": {"days": 0, "enabled": False},
                                                                    "storageId": "str",
                                                                    "tags": {"str": "str"},
                                                                    "targetResourceGuid": "str",
                                                                    "targetResourceId": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "flushConnection": bool,
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "networkInterfaces": [...],
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "securityRules": [
                                                                {
                                                                    "access": "str",
                                                                    "description": "str",
                                                                    "destinationAddressPrefix": "str",
                                                                    "destinationAddressPrefixes": ["str"],
                                                                    "destinationApplicationSecurityGroups": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "destinationPortRange": "str",
                                                                    "destinationPortRanges": ["str"],
                                                                    "direction": "str",
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "priority": 0,
                                                                    "protocol": "str",
                                                                    "provisioningState": "str",
                                                                    "sourceAddressPrefix": "str",
                                                                    "sourceAddressPrefixes": ["str"],
                                                                    "sourceApplicationSecurityGroups": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "sourcePortRange": "str",
                                                                    "sourcePortRanges": ["str"],
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "subnets": [...],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        },
                                                        "privateEndpointNetworkPolicies": "Disabled",
                                                        "privateEndpoints": [...],
                                                        "privateLinkServiceNetworkPolicies": "Enabled",
                                                        "provisioningState": "str",
                                                        "purpose": "str",
                                                        "resourceNavigationLinks": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "link": "str",
                                                                "linkedResourceType": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "routeTable": {
                                                            "disableBgpRoutePropagation": bool,
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "routes": [
                                                                {
                                                                    "addressPrefix": "str",
                                                                    "etag": "str",
                                                                    "hasBgpOverride": bool,
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "nextHopIpAddress": "str",
                                                                    "nextHopType": "str",
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "subnets": [...],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        },
                                                        "serviceAssociationLinks": [
                                                            {
                                                                "allowDelete": bool,
                                                                "etag": "str",
                                                                "id": "str",
                                                                "link": "str",
                                                                "linkedResourceType": "str",
                                                                "locations": ["str"],
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "serviceEndpointPolicies": [
                                                            {
                                                                "contextualServiceEndpointPolicies": ["str"],
                                                                "etag": "str",
                                                                "id": "str",
                                                                "kind": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "serviceAlias": "str",
                                                                "serviceEndpointPolicyDefinitions": [
                                                                    {
                                                                        "description": "str",
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "service": "str",
                                                                        "serviceResources": ["str"],
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "subnets": [...],
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "serviceEndpoints": [
                                                            {
                                                                "locations": ["str"],
                                                                "networkIdentifier": {"id": "str"},
                                                                "provisioningState": "str",
                                                                "service": "str",
                                                            }
                                                        ],
                                                        "sharingScope": "str",
                                                        "type": "str",
                                                    },
                                                    "type": "str",
                                                    "virtualNetworkTaps": [
                                                        {
                                                            "destinationLoadBalancerFrontEndIPConfiguration": {
                                                                "etag": "str",
                                                                "gatewayLoadBalancer": {"id": "str"},
                                                                "id": "str",
                                                                "inboundNatPools": [{"id": "str"}],
                                                                "inboundNatRules": [{"id": "str"}],
                                                                "loadBalancingRules": [{"id": "str"}],
                                                                "name": "str",
                                                                "outboundRules": [{"id": "str"}],
                                                                "privateIPAddress": "str",
                                                                "privateIPAddressVersion": "str",
                                                                "privateIPAllocationMethod": "str",
                                                                "provisioningState": "str",
                                                                "publicIPAddress": {
                                                                    "ddosSettings": {
                                                                        "ddosProtectionPlan": {"id": "str"},
                                                                        "protectionMode": "str",
                                                                    },
                                                                    "deleteOption": "str",
                                                                    "dnsSettings": {
                                                                        "domainNameLabel": "str",
                                                                        "domainNameLabelScope": "str",
                                                                        "fqdn": "str",
                                                                        "reverseFqdn": "str",
                                                                    },
                                                                    "etag": "str",
                                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                                    "id": "str",
                                                                    "idleTimeoutInMinutes": 0,
                                                                    "ipAddress": "str",
                                                                    "ipConfiguration": {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "privateIPAddress": "str",
                                                                        "privateIPAllocationMethod": "str",
                                                                        "provisioningState": "str",
                                                                        "publicIPAddress": ...,
                                                                        "subnet": {
                                                                            "addressPrefix": "str",
                                                                            "addressPrefixes": ["str"],
                                                                            "applicationGatewayIPConfigurations": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "subnet": {"id": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "defaultOutboundAccess": bool,
                                                                            "delegations": [
                                                                                {
                                                                                    "actions": ["str"],
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "serviceName": "str",
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "ipAllocations": [{"id": "str"}],
                                                                            "ipConfigurationProfiles": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "subnet": ...,
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "ipConfigurations": [...],
                                                                            "ipamPoolPrefixAllocations": [
                                                                                {
                                                                                    "allocatedAddressPrefixes": ["str"],
                                                                                    "id": "str",
                                                                                    "numberOfIpAddresses": "str",
                                                                                }
                                                                            ],
                                                                            "name": "str",
                                                                            "natGateway": {"id": "str"},
                                                                            "networkSecurityGroup": {
                                                                                "defaultSecurityRules": [
                                                                                    {
                                                                                        "access": "str",
                                                                                        "description": "str",
                                                                                        "destinationAddressPrefix": "str",
                                                                                        "destinationAddressPrefixes": [
                                                                                            "str"
                                                                                        ],
                                                                                        "destinationApplicationSecurityGroups": [
                                                                                            {
                                                                                                "etag": "str",
                                                                                                "id": "str",
                                                                                                "location": "str",
                                                                                                "name": "str",
                                                                                                "provisioningState": "str",
                                                                                                "resourceGuid": "str",
                                                                                                "tags": {"str": "str"},
                                                                                                "type": "str",
                                                                                            }
                                                                                        ],
                                                                                        "destinationPortRange": "str",
                                                                                        "destinationPortRanges": [
                                                                                            "str"
                                                                                        ],
                                                                                        "direction": "str",
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "name": "str",
                                                                                        "priority": 0,
                                                                                        "protocol": "str",
                                                                                        "provisioningState": "str",
                                                                                        "sourceAddressPrefix": "str",
                                                                                        "sourceAddressPrefixes": [
                                                                                            "str"
                                                                                        ],
                                                                                        "sourceApplicationSecurityGroups": [
                                                                                            {
                                                                                                "etag": "str",
                                                                                                "id": "str",
                                                                                                "location": "str",
                                                                                                "name": "str",
                                                                                                "provisioningState": "str",
                                                                                                "resourceGuid": "str",
                                                                                                "tags": {"str": "str"},
                                                                                                "type": "str",
                                                                                            }
                                                                                        ],
                                                                                        "sourcePortRange": "str",
                                                                                        "sourcePortRanges": ["str"],
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "etag": "str",
                                                                                "flowLogs": [
                                                                                    {
                                                                                        "enabled": bool,
                                                                                        "enabledFilteringCriteria": "str",
                                                                                        "etag": "str",
                                                                                        "flowAnalyticsConfiguration": {
                                                                                            "networkWatcherFlowAnalyticsConfiguration": {
                                                                                                "enabled": bool,
                                                                                                "trafficAnalyticsInterval": 0,
                                                                                                "workspaceId": "str",
                                                                                                "workspaceRegion": "str",
                                                                                                "workspaceResourceId": "str",
                                                                                            }
                                                                                        },
                                                                                        "format": {
                                                                                            "type": "str",
                                                                                            "version": 0,
                                                                                        },
                                                                                        "id": "str",
                                                                                        "identity": {
                                                                                            "principalId": "str",
                                                                                            "tenantId": "str",
                                                                                            "type": "str",
                                                                                            "userAssignedIdentities": {
                                                                                                "str": {
                                                                                                    "clientId": "str",
                                                                                                    "principalId": "str",
                                                                                                }
                                                                                            },
                                                                                        },
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "recordTypes": "str",
                                                                                        "retentionPolicy": {
                                                                                            "days": 0,
                                                                                            "enabled": False,
                                                                                        },
                                                                                        "storageId": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "targetResourceGuid": "str",
                                                                                        "targetResourceId": "str",
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "flushConnection": bool,
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "networkInterfaces": [...],
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "securityRules": [
                                                                                    {
                                                                                        "access": "str",
                                                                                        "description": "str",
                                                                                        "destinationAddressPrefix": "str",
                                                                                        "destinationAddressPrefixes": [
                                                                                            "str"
                                                                                        ],
                                                                                        "destinationApplicationSecurityGroups": [
                                                                                            {
                                                                                                "etag": "str",
                                                                                                "id": "str",
                                                                                                "location": "str",
                                                                                                "name": "str",
                                                                                                "provisioningState": "str",
                                                                                                "resourceGuid": "str",
                                                                                                "tags": {"str": "str"},
                                                                                                "type": "str",
                                                                                            }
                                                                                        ],
                                                                                        "destinationPortRange": "str",
                                                                                        "destinationPortRanges": [
                                                                                            "str"
                                                                                        ],
                                                                                        "direction": "str",
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "name": "str",
                                                                                        "priority": 0,
                                                                                        "protocol": "str",
                                                                                        "provisioningState": "str",
                                                                                        "sourceAddressPrefix": "str",
                                                                                        "sourceAddressPrefixes": [
                                                                                            "str"
                                                                                        ],
                                                                                        "sourceApplicationSecurityGroups": [
                                                                                            {
                                                                                                "etag": "str",
                                                                                                "id": "str",
                                                                                                "location": "str",
                                                                                                "name": "str",
                                                                                                "provisioningState": "str",
                                                                                                "resourceGuid": "str",
                                                                                                "tags": {"str": "str"},
                                                                                                "type": "str",
                                                                                            }
                                                                                        ],
                                                                                        "sourcePortRange": "str",
                                                                                        "sourcePortRanges": ["str"],
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "subnets": [...],
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            },
                                                                            "privateEndpointNetworkPolicies": "Disabled",
                                                                            "privateEndpoints": [...],
                                                                            "privateLinkServiceNetworkPolicies": "Enabled",
                                                                            "provisioningState": "str",
                                                                            "purpose": "str",
                                                                            "resourceNavigationLinks": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "link": "str",
                                                                                    "linkedResourceType": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "routeTable": {
                                                                                "disableBgpRoutePropagation": bool,
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "routes": [
                                                                                    {
                                                                                        "addressPrefix": "str",
                                                                                        "etag": "str",
                                                                                        "hasBgpOverride": bool,
                                                                                        "id": "str",
                                                                                        "name": "str",
                                                                                        "nextHopIpAddress": "str",
                                                                                        "nextHopType": "str",
                                                                                        "provisioningState": "str",
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "subnets": [...],
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            },
                                                                            "serviceAssociationLinks": [
                                                                                {
                                                                                    "allowDelete": bool,
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "link": "str",
                                                                                    "linkedResourceType": "str",
                                                                                    "locations": ["str"],
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "serviceEndpointPolicies": [
                                                                                {
                                                                                    "contextualServiceEndpointPolicies": [
                                                                                        "str"
                                                                                    ],
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "kind": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "serviceAlias": "str",
                                                                                    "serviceEndpointPolicyDefinitions": [
                                                                                        {
                                                                                            "description": "str",
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "service": "str",
                                                                                            "serviceResources": ["str"],
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "subnets": [...],
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "serviceEndpoints": [
                                                                                {
                                                                                    "locations": ["str"],
                                                                                    "networkIdentifier": {"id": "str"},
                                                                                    "provisioningState": "str",
                                                                                    "service": "str",
                                                                                }
                                                                            ],
                                                                            "sharingScope": "str",
                                                                            "type": "str",
                                                                        },
                                                                    },
                                                                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                    "linkedPublicIPAddress": ...,
                                                                    "location": "str",
                                                                    "migrationPhase": "str",
                                                                    "name": "str",
                                                                    "natGateway": {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "idleTimeoutInMinutes": 0,
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "publicIpAddresses": [{"id": "str"}],
                                                                        "publicIpAddressesV6": [{"id": "str"}],
                                                                        "publicIpPrefixes": [{"id": "str"}],
                                                                        "publicIpPrefixesV6": [{"id": "str"}],
                                                                        "resourceGuid": "str",
                                                                        "sku": {"name": "str"},
                                                                        "sourceVirtualNetwork": {"id": "str"},
                                                                        "subnets": [{"id": "str"}],
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                        "zones": ["str"],
                                                                    },
                                                                    "provisioningState": "str",
                                                                    "publicIPAddressVersion": "str",
                                                                    "publicIPAllocationMethod": "str",
                                                                    "publicIPPrefix": {"id": "str"},
                                                                    "resourceGuid": "str",
                                                                    "servicePublicIPAddress": ...,
                                                                    "sku": {"name": "str", "tier": "str"},
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                    "zones": ["str"],
                                                                },
                                                                "publicIPPrefix": {"id": "str"},
                                                                "subnet": {
                                                                    "addressPrefix": "str",
                                                                    "addressPrefixes": ["str"],
                                                                    "applicationGatewayIPConfigurations": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "subnet": {"id": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "defaultOutboundAccess": bool,
                                                                    "delegations": [
                                                                        {
                                                                            "actions": ["str"],
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "serviceName": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "ipAllocations": [{"id": "str"}],
                                                                    "ipConfigurationProfiles": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "subnet": ...,
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "ipConfigurations": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "privateIPAddress": "str",
                                                                            "privateIPAllocationMethod": "str",
                                                                            "provisioningState": "str",
                                                                            "publicIPAddress": {
                                                                                "ddosSettings": {
                                                                                    "ddosProtectionPlan": {"id": "str"},
                                                                                    "protectionMode": "str",
                                                                                },
                                                                                "deleteOption": "str",
                                                                                "dnsSettings": {
                                                                                    "domainNameLabel": "str",
                                                                                    "domainNameLabelScope": "str",
                                                                                    "fqdn": "str",
                                                                                    "reverseFqdn": "str",
                                                                                },
                                                                                "etag": "str",
                                                                                "extendedLocation": {
                                                                                    "name": "str",
                                                                                    "type": "str",
                                                                                },
                                                                                "id": "str",
                                                                                "idleTimeoutInMinutes": 0,
                                                                                "ipAddress": "str",
                                                                                "ipConfiguration": ...,
                                                                                "ipTags": [
                                                                                    {"ipTagType": "str", "tag": "str"}
                                                                                ],
                                                                                "linkedPublicIPAddress": ...,
                                                                                "location": "str",
                                                                                "migrationPhase": "str",
                                                                                "name": "str",
                                                                                "natGateway": {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "idleTimeoutInMinutes": 0,
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "publicIpAddresses": [
                                                                                        {"id": "str"}
                                                                                    ],
                                                                                    "publicIpAddressesV6": [
                                                                                        {"id": "str"}
                                                                                    ],
                                                                                    "publicIpPrefixes": [{"id": "str"}],
                                                                                    "publicIpPrefixesV6": [
                                                                                        {"id": "str"}
                                                                                    ],
                                                                                    "resourceGuid": "str",
                                                                                    "sku": {"name": "str"},
                                                                                    "sourceVirtualNetwork": {
                                                                                        "id": "str"
                                                                                    },
                                                                                    "subnets": [{"id": "str"}],
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                    "zones": ["str"],
                                                                                },
                                                                                "provisioningState": "str",
                                                                                "publicIPAddressVersion": "str",
                                                                                "publicIPAllocationMethod": "str",
                                                                                "publicIPPrefix": {"id": "str"},
                                                                                "resourceGuid": "str",
                                                                                "servicePublicIPAddress": ...,
                                                                                "sku": {"name": "str", "tier": "str"},
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                                "zones": ["str"],
                                                                            },
                                                                            "subnet": ...,
                                                                        }
                                                                    ],
                                                                    "ipamPoolPrefixAllocations": [
                                                                        {
                                                                            "allocatedAddressPrefixes": ["str"],
                                                                            "id": "str",
                                                                            "numberOfIpAddresses": "str",
                                                                        }
                                                                    ],
                                                                    "name": "str",
                                                                    "natGateway": {"id": "str"},
                                                                    "networkSecurityGroup": {
                                                                        "defaultSecurityRules": [
                                                                            {
                                                                                "access": "str",
                                                                                "description": "str",
                                                                                "destinationAddressPrefix": "str",
                                                                                "destinationAddressPrefixes": ["str"],
                                                                                "destinationApplicationSecurityGroups": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "resourceGuid": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "destinationPortRange": "str",
                                                                                "destinationPortRanges": ["str"],
                                                                                "direction": "str",
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "priority": 0,
                                                                                "protocol": "str",
                                                                                "provisioningState": "str",
                                                                                "sourceAddressPrefix": "str",
                                                                                "sourceAddressPrefixes": ["str"],
                                                                                "sourceApplicationSecurityGroups": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "resourceGuid": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "sourcePortRange": "str",
                                                                                "sourcePortRanges": ["str"],
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "etag": "str",
                                                                        "flowLogs": [
                                                                            {
                                                                                "enabled": bool,
                                                                                "enabledFilteringCriteria": "str",
                                                                                "etag": "str",
                                                                                "flowAnalyticsConfiguration": {
                                                                                    "networkWatcherFlowAnalyticsConfiguration": {
                                                                                        "enabled": bool,
                                                                                        "trafficAnalyticsInterval": 0,
                                                                                        "workspaceId": "str",
                                                                                        "workspaceRegion": "str",
                                                                                        "workspaceResourceId": "str",
                                                                                    }
                                                                                },
                                                                                "format": {"type": "str", "version": 0},
                                                                                "id": "str",
                                                                                "identity": {
                                                                                    "principalId": "str",
                                                                                    "tenantId": "str",
                                                                                    "type": "str",
                                                                                    "userAssignedIdentities": {
                                                                                        "str": {
                                                                                            "clientId": "str",
                                                                                            "principalId": "str",
                                                                                        }
                                                                                    },
                                                                                },
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "recordTypes": "str",
                                                                                "retentionPolicy": {
                                                                                    "days": 0,
                                                                                    "enabled": False,
                                                                                },
                                                                                "storageId": "str",
                                                                                "tags": {"str": "str"},
                                                                                "targetResourceGuid": "str",
                                                                                "targetResourceId": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "flushConnection": bool,
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "networkInterfaces": [...],
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "securityRules": [
                                                                            {
                                                                                "access": "str",
                                                                                "description": "str",
                                                                                "destinationAddressPrefix": "str",
                                                                                "destinationAddressPrefixes": ["str"],
                                                                                "destinationApplicationSecurityGroups": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "resourceGuid": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "destinationPortRange": "str",
                                                                                "destinationPortRanges": ["str"],
                                                                                "direction": "str",
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "priority": 0,
                                                                                "protocol": "str",
                                                                                "provisioningState": "str",
                                                                                "sourceAddressPrefix": "str",
                                                                                "sourceAddressPrefixes": ["str"],
                                                                                "sourceApplicationSecurityGroups": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "resourceGuid": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "sourcePortRange": "str",
                                                                                "sourcePortRanges": ["str"],
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "subnets": [...],
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    },
                                                                    "privateEndpointNetworkPolicies": "Disabled",
                                                                    "privateEndpoints": [...],
                                                                    "privateLinkServiceNetworkPolicies": "Enabled",
                                                                    "provisioningState": "str",
                                                                    "purpose": "str",
                                                                    "resourceNavigationLinks": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "link": "str",
                                                                            "linkedResourceType": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "routeTable": {
                                                                        "disableBgpRoutePropagation": bool,
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "routes": [
                                                                            {
                                                                                "addressPrefix": "str",
                                                                                "etag": "str",
                                                                                "hasBgpOverride": bool,
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "nextHopIpAddress": "str",
                                                                                "nextHopType": "str",
                                                                                "provisioningState": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "subnets": [...],
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    },
                                                                    "serviceAssociationLinks": [
                                                                        {
                                                                            "allowDelete": bool,
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "link": "str",
                                                                            "linkedResourceType": "str",
                                                                            "locations": ["str"],
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "serviceEndpointPolicies": [
                                                                        {
                                                                            "contextualServiceEndpointPolicies": [
                                                                                "str"
                                                                            ],
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "kind": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "serviceAlias": "str",
                                                                            "serviceEndpointPolicyDefinitions": [
                                                                                {
                                                                                    "description": "str",
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "service": "str",
                                                                                    "serviceResources": ["str"],
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "subnets": [...],
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "serviceEndpoints": [
                                                                        {
                                                                            "locations": ["str"],
                                                                            "networkIdentifier": {"id": "str"},
                                                                            "provisioningState": "str",
                                                                            "service": "str",
                                                                        }
                                                                    ],
                                                                    "sharingScope": "str",
                                                                    "type": "str",
                                                                },
                                                                "type": "str",
                                                                "zones": ["str"],
                                                            },
                                                            "destinationNetworkInterfaceIPConfiguration": ...,
                                                            "destinationPort": 0,
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "networkInterfaceTapConfigurations": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                    "virtualNetworkTap": ...,
                                                                }
                                                            ],
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                }
                                            ],
                                            "location": "str",
                                            "macAddress": "str",
                                            "migrationPhase": "str",
                                            "name": "str",
                                            "networkSecurityGroup": {
                                                "defaultSecurityRules": [
                                                    {
                                                        "access": "str",
                                                        "description": "str",
                                                        "destinationAddressPrefix": "str",
                                                        "destinationAddressPrefixes": ["str"],
                                                        "destinationApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "destinationPortRange": "str",
                                                        "destinationPortRanges": ["str"],
                                                        "direction": "str",
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "priority": 0,
                                                        "protocol": "str",
                                                        "provisioningState": "str",
                                                        "sourceAddressPrefix": "str",
                                                        "sourceAddressPrefixes": ["str"],
                                                        "sourceApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "sourcePortRange": "str",
                                                        "sourcePortRanges": ["str"],
                                                        "type": "str",
                                                    }
                                                ],
                                                "etag": "str",
                                                "flowLogs": [
                                                    {
                                                        "enabled": bool,
                                                        "enabledFilteringCriteria": "str",
                                                        "etag": "str",
                                                        "flowAnalyticsConfiguration": {
                                                            "networkWatcherFlowAnalyticsConfiguration": {
                                                                "enabled": bool,
                                                                "trafficAnalyticsInterval": 0,
                                                                "workspaceId": "str",
                                                                "workspaceRegion": "str",
                                                                "workspaceResourceId": "str",
                                                            }
                                                        },
                                                        "format": {"type": "str", "version": 0},
                                                        "id": "str",
                                                        "identity": {
                                                            "principalId": "str",
                                                            "tenantId": "str",
                                                            "type": "str",
                                                            "userAssignedIdentities": {
                                                                "str": {"clientId": "str", "principalId": "str"}
                                                            },
                                                        },
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "recordTypes": "str",
                                                        "retentionPolicy": {"days": 0, "enabled": False},
                                                        "storageId": "str",
                                                        "tags": {"str": "str"},
                                                        "targetResourceGuid": "str",
                                                        "targetResourceId": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "flushConnection": bool,
                                                "id": "str",
                                                "location": "str",
                                                "name": "str",
                                                "networkInterfaces": [...],
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "securityRules": [
                                                    {
                                                        "access": "str",
                                                        "description": "str",
                                                        "destinationAddressPrefix": "str",
                                                        "destinationAddressPrefixes": ["str"],
                                                        "destinationApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "destinationPortRange": "str",
                                                        "destinationPortRanges": ["str"],
                                                        "direction": "str",
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "priority": 0,
                                                        "protocol": "str",
                                                        "provisioningState": "str",
                                                        "sourceAddressPrefix": "str",
                                                        "sourceAddressPrefixes": ["str"],
                                                        "sourceApplicationSecurityGroups": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "sourcePortRange": "str",
                                                        "sourcePortRanges": ["str"],
                                                        "type": "str",
                                                    }
                                                ],
                                                "subnets": [
                                                    {
                                                        "addressPrefix": "str",
                                                        "addressPrefixes": ["str"],
                                                        "applicationGatewayIPConfigurations": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "subnet": {"id": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "defaultOutboundAccess": bool,
                                                        "delegations": [
                                                            {
                                                                "actions": ["str"],
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "serviceName": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "etag": "str",
                                                        "id": "str",
                                                        "ipAllocations": [{"id": "str"}],
                                                        "ipConfigurationProfiles": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "subnet": ...,
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "ipConfigurations": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "privateIPAddress": "str",
                                                                "privateIPAllocationMethod": "str",
                                                                "provisioningState": "str",
                                                                "publicIPAddress": {
                                                                    "ddosSettings": {
                                                                        "ddosProtectionPlan": {"id": "str"},
                                                                        "protectionMode": "str",
                                                                    },
                                                                    "deleteOption": "str",
                                                                    "dnsSettings": {
                                                                        "domainNameLabel": "str",
                                                                        "domainNameLabelScope": "str",
                                                                        "fqdn": "str",
                                                                        "reverseFqdn": "str",
                                                                    },
                                                                    "etag": "str",
                                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                                    "id": "str",
                                                                    "idleTimeoutInMinutes": 0,
                                                                    "ipAddress": "str",
                                                                    "ipConfiguration": ...,
                                                                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                    "linkedPublicIPAddress": ...,
                                                                    "location": "str",
                                                                    "migrationPhase": "str",
                                                                    "name": "str",
                                                                    "natGateway": {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "idleTimeoutInMinutes": 0,
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "publicIpAddresses": [{"id": "str"}],
                                                                        "publicIpAddressesV6": [{"id": "str"}],
                                                                        "publicIpPrefixes": [{"id": "str"}],
                                                                        "publicIpPrefixesV6": [{"id": "str"}],
                                                                        "resourceGuid": "str",
                                                                        "sku": {"name": "str"},
                                                                        "sourceVirtualNetwork": {"id": "str"},
                                                                        "subnets": [{"id": "str"}],
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                        "zones": ["str"],
                                                                    },
                                                                    "provisioningState": "str",
                                                                    "publicIPAddressVersion": "str",
                                                                    "publicIPAllocationMethod": "str",
                                                                    "publicIPPrefix": {"id": "str"},
                                                                    "resourceGuid": "str",
                                                                    "servicePublicIPAddress": ...,
                                                                    "sku": {"name": "str", "tier": "str"},
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                    "zones": ["str"],
                                                                },
                                                                "subnet": ...,
                                                            }
                                                        ],
                                                        "ipamPoolPrefixAllocations": [
                                                            {
                                                                "allocatedAddressPrefixes": ["str"],
                                                                "id": "str",
                                                                "numberOfIpAddresses": "str",
                                                            }
                                                        ],
                                                        "name": "str",
                                                        "natGateway": {"id": "str"},
                                                        "networkSecurityGroup": ...,
                                                        "privateEndpointNetworkPolicies": "Disabled",
                                                        "privateEndpoints": [...],
                                                        "privateLinkServiceNetworkPolicies": "Enabled",
                                                        "provisioningState": "str",
                                                        "purpose": "str",
                                                        "resourceNavigationLinks": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "link": "str",
                                                                "linkedResourceType": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "routeTable": {
                                                            "disableBgpRoutePropagation": bool,
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "routes": [
                                                                {
                                                                    "addressPrefix": "str",
                                                                    "etag": "str",
                                                                    "hasBgpOverride": bool,
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "nextHopIpAddress": "str",
                                                                    "nextHopType": "str",
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "subnets": [...],
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        },
                                                        "serviceAssociationLinks": [
                                                            {
                                                                "allowDelete": bool,
                                                                "etag": "str",
                                                                "id": "str",
                                                                "link": "str",
                                                                "linkedResourceType": "str",
                                                                "locations": ["str"],
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "serviceEndpointPolicies": [
                                                            {
                                                                "contextualServiceEndpointPolicies": ["str"],
                                                                "etag": "str",
                                                                "id": "str",
                                                                "kind": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "serviceAlias": "str",
                                                                "serviceEndpointPolicyDefinitions": [
                                                                    {
                                                                        "description": "str",
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "service": "str",
                                                                        "serviceResources": ["str"],
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "subnets": [...],
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "serviceEndpoints": [
                                                            {
                                                                "locations": ["str"],
                                                                "networkIdentifier": {"id": "str"},
                                                                "provisioningState": "str",
                                                                "service": "str",
                                                            }
                                                        ],
                                                        "sharingScope": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            },
                                            "nicType": "str",
                                            "primary": bool,
                                            "privateEndpoint": ...,
                                            "privateLinkService": {
                                                "accessMode": "str",
                                                "alias": "str",
                                                "autoApproval": {"subscriptions": ["str"]},
                                                "destinationIPAddress": "str",
                                                "enableProxyProtocol": bool,
                                                "etag": "str",
                                                "extendedLocation": {"name": "str", "type": "str"},
                                                "fqdns": ["str"],
                                                "id": "str",
                                                "ipConfigurations": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "primary": bool,
                                                        "privateIPAddress": "str",
                                                        "privateIPAddressVersion": "str",
                                                        "privateIPAllocationMethod": "str",
                                                        "provisioningState": "str",
                                                        "subnet": {
                                                            "addressPrefix": "str",
                                                            "addressPrefixes": ["str"],
                                                            "applicationGatewayIPConfigurations": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "subnet": {"id": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "defaultOutboundAccess": bool,
                                                            "delegations": [
                                                                {
                                                                    "actions": ["str"],
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "serviceName": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "etag": "str",
                                                            "id": "str",
                                                            "ipAllocations": [{"id": "str"}],
                                                            "ipConfigurationProfiles": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "subnet": ...,
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "ipConfigurations": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "privateIPAddress": "str",
                                                                    "privateIPAllocationMethod": "str",
                                                                    "provisioningState": "str",
                                                                    "publicIPAddress": {
                                                                        "ddosSettings": {
                                                                            "ddosProtectionPlan": {"id": "str"},
                                                                            "protectionMode": "str",
                                                                        },
                                                                        "deleteOption": "str",
                                                                        "dnsSettings": {
                                                                            "domainNameLabel": "str",
                                                                            "domainNameLabelScope": "str",
                                                                            "fqdn": "str",
                                                                            "reverseFqdn": "str",
                                                                        },
                                                                        "etag": "str",
                                                                        "extendedLocation": {
                                                                            "name": "str",
                                                                            "type": "str",
                                                                        },
                                                                        "id": "str",
                                                                        "idleTimeoutInMinutes": 0,
                                                                        "ipAddress": "str",
                                                                        "ipConfiguration": ...,
                                                                        "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                        "linkedPublicIPAddress": ...,
                                                                        "location": "str",
                                                                        "migrationPhase": "str",
                                                                        "name": "str",
                                                                        "natGateway": {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "idleTimeoutInMinutes": 0,
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "publicIpAddresses": [{"id": "str"}],
                                                                            "publicIpAddressesV6": [{"id": "str"}],
                                                                            "publicIpPrefixes": [{"id": "str"}],
                                                                            "publicIpPrefixesV6": [{"id": "str"}],
                                                                            "resourceGuid": "str",
                                                                            "sku": {"name": "str"},
                                                                            "sourceVirtualNetwork": {"id": "str"},
                                                                            "subnets": [{"id": "str"}],
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                            "zones": ["str"],
                                                                        },
                                                                        "provisioningState": "str",
                                                                        "publicIPAddressVersion": "str",
                                                                        "publicIPAllocationMethod": "str",
                                                                        "publicIPPrefix": {"id": "str"},
                                                                        "resourceGuid": "str",
                                                                        "servicePublicIPAddress": ...,
                                                                        "sku": {"name": "str", "tier": "str"},
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                        "zones": ["str"],
                                                                    },
                                                                    "subnet": ...,
                                                                }
                                                            ],
                                                            "ipamPoolPrefixAllocations": [
                                                                {
                                                                    "allocatedAddressPrefixes": ["str"],
                                                                    "id": "str",
                                                                    "numberOfIpAddresses": "str",
                                                                }
                                                            ],
                                                            "name": "str",
                                                            "natGateway": {"id": "str"},
                                                            "networkSecurityGroup": {
                                                                "defaultSecurityRules": [
                                                                    {
                                                                        "access": "str",
                                                                        "description": "str",
                                                                        "destinationAddressPrefix": "str",
                                                                        "destinationAddressPrefixes": ["str"],
                                                                        "destinationApplicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "destinationPortRange": "str",
                                                                        "destinationPortRanges": ["str"],
                                                                        "direction": "str",
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "priority": 0,
                                                                        "protocol": "str",
                                                                        "provisioningState": "str",
                                                                        "sourceAddressPrefix": "str",
                                                                        "sourceAddressPrefixes": ["str"],
                                                                        "sourceApplicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "sourcePortRange": "str",
                                                                        "sourcePortRanges": ["str"],
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "etag": "str",
                                                                "flowLogs": [
                                                                    {
                                                                        "enabled": bool,
                                                                        "enabledFilteringCriteria": "str",
                                                                        "etag": "str",
                                                                        "flowAnalyticsConfiguration": {
                                                                            "networkWatcherFlowAnalyticsConfiguration": {
                                                                                "enabled": bool,
                                                                                "trafficAnalyticsInterval": 0,
                                                                                "workspaceId": "str",
                                                                                "workspaceRegion": "str",
                                                                                "workspaceResourceId": "str",
                                                                            }
                                                                        },
                                                                        "format": {"type": "str", "version": 0},
                                                                        "id": "str",
                                                                        "identity": {
                                                                            "principalId": "str",
                                                                            "tenantId": "str",
                                                                            "type": "str",
                                                                            "userAssignedIdentities": {
                                                                                "str": {
                                                                                    "clientId": "str",
                                                                                    "principalId": "str",
                                                                                }
                                                                            },
                                                                        },
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "recordTypes": "str",
                                                                        "retentionPolicy": {
                                                                            "days": 0,
                                                                            "enabled": False,
                                                                        },
                                                                        "storageId": "str",
                                                                        "tags": {"str": "str"},
                                                                        "targetResourceGuid": "str",
                                                                        "targetResourceId": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "flushConnection": bool,
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "networkInterfaces": [...],
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "securityRules": [
                                                                    {
                                                                        "access": "str",
                                                                        "description": "str",
                                                                        "destinationAddressPrefix": "str",
                                                                        "destinationAddressPrefixes": ["str"],
                                                                        "destinationApplicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "destinationPortRange": "str",
                                                                        "destinationPortRanges": ["str"],
                                                                        "direction": "str",
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "priority": 0,
                                                                        "protocol": "str",
                                                                        "provisioningState": "str",
                                                                        "sourceAddressPrefix": "str",
                                                                        "sourceAddressPrefixes": ["str"],
                                                                        "sourceApplicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "sourcePortRange": "str",
                                                                        "sourcePortRanges": ["str"],
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "subnets": [...],
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            },
                                                            "privateEndpointNetworkPolicies": "Disabled",
                                                            "privateEndpoints": [...],
                                                            "privateLinkServiceNetworkPolicies": "Enabled",
                                                            "provisioningState": "str",
                                                            "purpose": "str",
                                                            "resourceNavigationLinks": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "link": "str",
                                                                    "linkedResourceType": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "routeTable": {
                                                                "disableBgpRoutePropagation": bool,
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "routes": [
                                                                    {
                                                                        "addressPrefix": "str",
                                                                        "etag": "str",
                                                                        "hasBgpOverride": bool,
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "nextHopIpAddress": "str",
                                                                        "nextHopType": "str",
                                                                        "provisioningState": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "subnets": [...],
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            },
                                                            "serviceAssociationLinks": [
                                                                {
                                                                    "allowDelete": bool,
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "link": "str",
                                                                    "linkedResourceType": "str",
                                                                    "locations": ["str"],
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "serviceEndpointPolicies": [
                                                                {
                                                                    "contextualServiceEndpointPolicies": ["str"],
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "kind": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "serviceAlias": "str",
                                                                    "serviceEndpointPolicyDefinitions": [
                                                                        {
                                                                            "description": "str",
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "service": "str",
                                                                            "serviceResources": ["str"],
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "subnets": [...],
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "serviceEndpoints": [
                                                                {
                                                                    "locations": ["str"],
                                                                    "networkIdentifier": {"id": "str"},
                                                                    "provisioningState": "str",
                                                                    "service": "str",
                                                                }
                                                            ],
                                                            "sharingScope": "str",
                                                            "type": "str",
                                                        },
                                                        "type": "str",
                                                    }
                                                ],
                                                "loadBalancerFrontendIpConfigurations": [
                                                    {
                                                        "etag": "str",
                                                        "gatewayLoadBalancer": {"id": "str"},
                                                        "id": "str",
                                                        "inboundNatPools": [{"id": "str"}],
                                                        "inboundNatRules": [{"id": "str"}],
                                                        "loadBalancingRules": [{"id": "str"}],
                                                        "name": "str",
                                                        "outboundRules": [{"id": "str"}],
                                                        "privateIPAddress": "str",
                                                        "privateIPAddressVersion": "str",
                                                        "privateIPAllocationMethod": "str",
                                                        "provisioningState": "str",
                                                        "publicIPAddress": {
                                                            "ddosSettings": {
                                                                "ddosProtectionPlan": {"id": "str"},
                                                                "protectionMode": "str",
                                                            },
                                                            "deleteOption": "str",
                                                            "dnsSettings": {
                                                                "domainNameLabel": "str",
                                                                "domainNameLabelScope": "str",
                                                                "fqdn": "str",
                                                                "reverseFqdn": "str",
                                                            },
                                                            "etag": "str",
                                                            "extendedLocation": {"name": "str", "type": "str"},
                                                            "id": "str",
                                                            "idleTimeoutInMinutes": 0,
                                                            "ipAddress": "str",
                                                            "ipConfiguration": {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "privateIPAddress": "str",
                                                                "privateIPAllocationMethod": "str",
                                                                "provisioningState": "str",
                                                                "publicIPAddress": ...,
                                                                "subnet": {
                                                                    "addressPrefix": "str",
                                                                    "addressPrefixes": ["str"],
                                                                    "applicationGatewayIPConfigurations": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "subnet": {"id": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "defaultOutboundAccess": bool,
                                                                    "delegations": [
                                                                        {
                                                                            "actions": ["str"],
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "serviceName": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "ipAllocations": [{"id": "str"}],
                                                                    "ipConfigurationProfiles": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "subnet": ...,
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "ipConfigurations": [...],
                                                                    "ipamPoolPrefixAllocations": [
                                                                        {
                                                                            "allocatedAddressPrefixes": ["str"],
                                                                            "id": "str",
                                                                            "numberOfIpAddresses": "str",
                                                                        }
                                                                    ],
                                                                    "name": "str",
                                                                    "natGateway": {"id": "str"},
                                                                    "networkSecurityGroup": {
                                                                        "defaultSecurityRules": [
                                                                            {
                                                                                "access": "str",
                                                                                "description": "str",
                                                                                "destinationAddressPrefix": "str",
                                                                                "destinationAddressPrefixes": ["str"],
                                                                                "destinationApplicationSecurityGroups": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "resourceGuid": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "destinationPortRange": "str",
                                                                                "destinationPortRanges": ["str"],
                                                                                "direction": "str",
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "priority": 0,
                                                                                "protocol": "str",
                                                                                "provisioningState": "str",
                                                                                "sourceAddressPrefix": "str",
                                                                                "sourceAddressPrefixes": ["str"],
                                                                                "sourceApplicationSecurityGroups": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "resourceGuid": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "sourcePortRange": "str",
                                                                                "sourcePortRanges": ["str"],
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "etag": "str",
                                                                        "flowLogs": [
                                                                            {
                                                                                "enabled": bool,
                                                                                "enabledFilteringCriteria": "str",
                                                                                "etag": "str",
                                                                                "flowAnalyticsConfiguration": {
                                                                                    "networkWatcherFlowAnalyticsConfiguration": {
                                                                                        "enabled": bool,
                                                                                        "trafficAnalyticsInterval": 0,
                                                                                        "workspaceId": "str",
                                                                                        "workspaceRegion": "str",
                                                                                        "workspaceResourceId": "str",
                                                                                    }
                                                                                },
                                                                                "format": {"type": "str", "version": 0},
                                                                                "id": "str",
                                                                                "identity": {
                                                                                    "principalId": "str",
                                                                                    "tenantId": "str",
                                                                                    "type": "str",
                                                                                    "userAssignedIdentities": {
                                                                                        "str": {
                                                                                            "clientId": "str",
                                                                                            "principalId": "str",
                                                                                        }
                                                                                    },
                                                                                },
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "recordTypes": "str",
                                                                                "retentionPolicy": {
                                                                                    "days": 0,
                                                                                    "enabled": False,
                                                                                },
                                                                                "storageId": "str",
                                                                                "tags": {"str": "str"},
                                                                                "targetResourceGuid": "str",
                                                                                "targetResourceId": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "flushConnection": bool,
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "networkInterfaces": [...],
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "securityRules": [
                                                                            {
                                                                                "access": "str",
                                                                                "description": "str",
                                                                                "destinationAddressPrefix": "str",
                                                                                "destinationAddressPrefixes": ["str"],
                                                                                "destinationApplicationSecurityGroups": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "resourceGuid": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "destinationPortRange": "str",
                                                                                "destinationPortRanges": ["str"],
                                                                                "direction": "str",
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "priority": 0,
                                                                                "protocol": "str",
                                                                                "provisioningState": "str",
                                                                                "sourceAddressPrefix": "str",
                                                                                "sourceAddressPrefixes": ["str"],
                                                                                "sourceApplicationSecurityGroups": [
                                                                                    {
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "location": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "resourceGuid": "str",
                                                                                        "tags": {"str": "str"},
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "sourcePortRange": "str",
                                                                                "sourcePortRanges": ["str"],
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "subnets": [...],
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    },
                                                                    "privateEndpointNetworkPolicies": "Disabled",
                                                                    "privateEndpoints": [...],
                                                                    "privateLinkServiceNetworkPolicies": "Enabled",
                                                                    "provisioningState": "str",
                                                                    "purpose": "str",
                                                                    "resourceNavigationLinks": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "link": "str",
                                                                            "linkedResourceType": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "routeTable": {
                                                                        "disableBgpRoutePropagation": bool,
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "routes": [
                                                                            {
                                                                                "addressPrefix": "str",
                                                                                "etag": "str",
                                                                                "hasBgpOverride": bool,
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "nextHopIpAddress": "str",
                                                                                "nextHopType": "str",
                                                                                "provisioningState": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "subnets": [...],
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    },
                                                                    "serviceAssociationLinks": [
                                                                        {
                                                                            "allowDelete": bool,
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "link": "str",
                                                                            "linkedResourceType": "str",
                                                                            "locations": ["str"],
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "serviceEndpointPolicies": [
                                                                        {
                                                                            "contextualServiceEndpointPolicies": [
                                                                                "str"
                                                                            ],
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "kind": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "serviceAlias": "str",
                                                                            "serviceEndpointPolicyDefinitions": [
                                                                                {
                                                                                    "description": "str",
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "service": "str",
                                                                                    "serviceResources": ["str"],
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "subnets": [...],
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "serviceEndpoints": [
                                                                        {
                                                                            "locations": ["str"],
                                                                            "networkIdentifier": {"id": "str"},
                                                                            "provisioningState": "str",
                                                                            "service": "str",
                                                                        }
                                                                    ],
                                                                    "sharingScope": "str",
                                                                    "type": "str",
                                                                },
                                                            },
                                                            "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                            "linkedPublicIPAddress": ...,
                                                            "location": "str",
                                                            "migrationPhase": "str",
                                                            "name": "str",
                                                            "natGateway": {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "idleTimeoutInMinutes": 0,
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "publicIpAddresses": [{"id": "str"}],
                                                                "publicIpAddressesV6": [{"id": "str"}],
                                                                "publicIpPrefixes": [{"id": "str"}],
                                                                "publicIpPrefixesV6": [{"id": "str"}],
                                                                "resourceGuid": "str",
                                                                "sku": {"name": "str"},
                                                                "sourceVirtualNetwork": {"id": "str"},
                                                                "subnets": [{"id": "str"}],
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                                "zones": ["str"],
                                                            },
                                                            "provisioningState": "str",
                                                            "publicIPAddressVersion": "str",
                                                            "publicIPAllocationMethod": "str",
                                                            "publicIPPrefix": {"id": "str"},
                                                            "resourceGuid": "str",
                                                            "servicePublicIPAddress": ...,
                                                            "sku": {"name": "str", "tier": "str"},
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                            "zones": ["str"],
                                                        },
                                                        "publicIPPrefix": {"id": "str"},
                                                        "subnet": {
                                                            "addressPrefix": "str",
                                                            "addressPrefixes": ["str"],
                                                            "applicationGatewayIPConfigurations": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "subnet": {"id": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "defaultOutboundAccess": bool,
                                                            "delegations": [
                                                                {
                                                                    "actions": ["str"],
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "serviceName": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "etag": "str",
                                                            "id": "str",
                                                            "ipAllocations": [{"id": "str"}],
                                                            "ipConfigurationProfiles": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "subnet": ...,
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "ipConfigurations": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "privateIPAddress": "str",
                                                                    "privateIPAllocationMethod": "str",
                                                                    "provisioningState": "str",
                                                                    "publicIPAddress": {
                                                                        "ddosSettings": {
                                                                            "ddosProtectionPlan": {"id": "str"},
                                                                            "protectionMode": "str",
                                                                        },
                                                                        "deleteOption": "str",
                                                                        "dnsSettings": {
                                                                            "domainNameLabel": "str",
                                                                            "domainNameLabelScope": "str",
                                                                            "fqdn": "str",
                                                                            "reverseFqdn": "str",
                                                                        },
                                                                        "etag": "str",
                                                                        "extendedLocation": {
                                                                            "name": "str",
                                                                            "type": "str",
                                                                        },
                                                                        "id": "str",
                                                                        "idleTimeoutInMinutes": 0,
                                                                        "ipAddress": "str",
                                                                        "ipConfiguration": ...,
                                                                        "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                        "linkedPublicIPAddress": ...,
                                                                        "location": "str",
                                                                        "migrationPhase": "str",
                                                                        "name": "str",
                                                                        "natGateway": {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "idleTimeoutInMinutes": 0,
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "publicIpAddresses": [{"id": "str"}],
                                                                            "publicIpAddressesV6": [{"id": "str"}],
                                                                            "publicIpPrefixes": [{"id": "str"}],
                                                                            "publicIpPrefixesV6": [{"id": "str"}],
                                                                            "resourceGuid": "str",
                                                                            "sku": {"name": "str"},
                                                                            "sourceVirtualNetwork": {"id": "str"},
                                                                            "subnets": [{"id": "str"}],
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                            "zones": ["str"],
                                                                        },
                                                                        "provisioningState": "str",
                                                                        "publicIPAddressVersion": "str",
                                                                        "publicIPAllocationMethod": "str",
                                                                        "publicIPPrefix": {"id": "str"},
                                                                        "resourceGuid": "str",
                                                                        "servicePublicIPAddress": ...,
                                                                        "sku": {"name": "str", "tier": "str"},
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                        "zones": ["str"],
                                                                    },
                                                                    "subnet": ...,
                                                                }
                                                            ],
                                                            "ipamPoolPrefixAllocations": [
                                                                {
                                                                    "allocatedAddressPrefixes": ["str"],
                                                                    "id": "str",
                                                                    "numberOfIpAddresses": "str",
                                                                }
                                                            ],
                                                            "name": "str",
                                                            "natGateway": {"id": "str"},
                                                            "networkSecurityGroup": {
                                                                "defaultSecurityRules": [
                                                                    {
                                                                        "access": "str",
                                                                        "description": "str",
                                                                        "destinationAddressPrefix": "str",
                                                                        "destinationAddressPrefixes": ["str"],
                                                                        "destinationApplicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "destinationPortRange": "str",
                                                                        "destinationPortRanges": ["str"],
                                                                        "direction": "str",
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "priority": 0,
                                                                        "protocol": "str",
                                                                        "provisioningState": "str",
                                                                        "sourceAddressPrefix": "str",
                                                                        "sourceAddressPrefixes": ["str"],
                                                                        "sourceApplicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "sourcePortRange": "str",
                                                                        "sourcePortRanges": ["str"],
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "etag": "str",
                                                                "flowLogs": [
                                                                    {
                                                                        "enabled": bool,
                                                                        "enabledFilteringCriteria": "str",
                                                                        "etag": "str",
                                                                        "flowAnalyticsConfiguration": {
                                                                            "networkWatcherFlowAnalyticsConfiguration": {
                                                                                "enabled": bool,
                                                                                "trafficAnalyticsInterval": 0,
                                                                                "workspaceId": "str",
                                                                                "workspaceRegion": "str",
                                                                                "workspaceResourceId": "str",
                                                                            }
                                                                        },
                                                                        "format": {"type": "str", "version": 0},
                                                                        "id": "str",
                                                                        "identity": {
                                                                            "principalId": "str",
                                                                            "tenantId": "str",
                                                                            "type": "str",
                                                                            "userAssignedIdentities": {
                                                                                "str": {
                                                                                    "clientId": "str",
                                                                                    "principalId": "str",
                                                                                }
                                                                            },
                                                                        },
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "recordTypes": "str",
                                                                        "retentionPolicy": {
                                                                            "days": 0,
                                                                            "enabled": False,
                                                                        },
                                                                        "storageId": "str",
                                                                        "tags": {"str": "str"},
                                                                        "targetResourceGuid": "str",
                                                                        "targetResourceId": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "flushConnection": bool,
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "networkInterfaces": [...],
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "securityRules": [
                                                                    {
                                                                        "access": "str",
                                                                        "description": "str",
                                                                        "destinationAddressPrefix": "str",
                                                                        "destinationAddressPrefixes": ["str"],
                                                                        "destinationApplicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "destinationPortRange": "str",
                                                                        "destinationPortRanges": ["str"],
                                                                        "direction": "str",
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "priority": 0,
                                                                        "protocol": "str",
                                                                        "provisioningState": "str",
                                                                        "sourceAddressPrefix": "str",
                                                                        "sourceAddressPrefixes": ["str"],
                                                                        "sourceApplicationSecurityGroups": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "sourcePortRange": "str",
                                                                        "sourcePortRanges": ["str"],
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "subnets": [...],
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            },
                                                            "privateEndpointNetworkPolicies": "Disabled",
                                                            "privateEndpoints": [...],
                                                            "privateLinkServiceNetworkPolicies": "Enabled",
                                                            "provisioningState": "str",
                                                            "purpose": "str",
                                                            "resourceNavigationLinks": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "link": "str",
                                                                    "linkedResourceType": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "routeTable": {
                                                                "disableBgpRoutePropagation": bool,
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "routes": [
                                                                    {
                                                                        "addressPrefix": "str",
                                                                        "etag": "str",
                                                                        "hasBgpOverride": bool,
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "nextHopIpAddress": "str",
                                                                        "nextHopType": "str",
                                                                        "provisioningState": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "subnets": [...],
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            },
                                                            "serviceAssociationLinks": [
                                                                {
                                                                    "allowDelete": bool,
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "link": "str",
                                                                    "linkedResourceType": "str",
                                                                    "locations": ["str"],
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "serviceEndpointPolicies": [
                                                                {
                                                                    "contextualServiceEndpointPolicies": ["str"],
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "kind": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "serviceAlias": "str",
                                                                    "serviceEndpointPolicyDefinitions": [
                                                                        {
                                                                            "description": "str",
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "service": "str",
                                                                            "serviceResources": ["str"],
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "subnets": [...],
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "serviceEndpoints": [
                                                                {
                                                                    "locations": ["str"],
                                                                    "networkIdentifier": {"id": "str"},
                                                                    "provisioningState": "str",
                                                                    "service": "str",
                                                                }
                                                            ],
                                                            "sharingScope": "str",
                                                            "type": "str",
                                                        },
                                                        "type": "str",
                                                        "zones": ["str"],
                                                    }
                                                ],
                                                "location": "str",
                                                "name": "str",
                                                "networkInterfaces": [...],
                                                "privateEndpointConnections": [
                                                    {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "linkIdentifier": "str",
                                                        "name": "str",
                                                        "privateEndpoint": ...,
                                                        "privateEndpointLocation": "str",
                                                        "privateLinkServiceConnectionState": {
                                                            "actionsRequired": "str",
                                                            "description": "str",
                                                            "status": "str",
                                                        },
                                                        "provisioningState": "str",
                                                        "type": "str",
                                                    }
                                                ],
                                                "provisioningState": "str",
                                                "tags": {"str": "str"},
                                                "type": "str",
                                                "visibility": {"subscriptions": ["str"]},
                                            },
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "tags": {"str": "str"},
                                            "tapConfigurations": [
                                                {
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "type": "str",
                                                    "virtualNetworkTap": {
                                                        "destinationLoadBalancerFrontEndIPConfiguration": {
                                                            "etag": "str",
                                                            "gatewayLoadBalancer": {"id": "str"},
                                                            "id": "str",
                                                            "inboundNatPools": [{"id": "str"}],
                                                            "inboundNatRules": [{"id": "str"}],
                                                            "loadBalancingRules": [{"id": "str"}],
                                                            "name": "str",
                                                            "outboundRules": [{"id": "str"}],
                                                            "privateIPAddress": "str",
                                                            "privateIPAddressVersion": "str",
                                                            "privateIPAllocationMethod": "str",
                                                            "provisioningState": "str",
                                                            "publicIPAddress": {
                                                                "ddosSettings": {
                                                                    "ddosProtectionPlan": {"id": "str"},
                                                                    "protectionMode": "str",
                                                                },
                                                                "deleteOption": "str",
                                                                "dnsSettings": {
                                                                    "domainNameLabel": "str",
                                                                    "domainNameLabelScope": "str",
                                                                    "fqdn": "str",
                                                                    "reverseFqdn": "str",
                                                                },
                                                                "etag": "str",
                                                                "extendedLocation": {"name": "str", "type": "str"},
                                                                "id": "str",
                                                                "idleTimeoutInMinutes": 0,
                                                                "ipAddress": "str",
                                                                "ipConfiguration": {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "privateIPAddress": "str",
                                                                    "privateIPAllocationMethod": "str",
                                                                    "provisioningState": "str",
                                                                    "publicIPAddress": ...,
                                                                    "subnet": {
                                                                        "addressPrefix": "str",
                                                                        "addressPrefixes": ["str"],
                                                                        "applicationGatewayIPConfigurations": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "subnet": {"id": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "defaultOutboundAccess": bool,
                                                                        "delegations": [
                                                                            {
                                                                                "actions": ["str"],
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "serviceName": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "ipAllocations": [{"id": "str"}],
                                                                        "ipConfigurationProfiles": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "subnet": ...,
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "ipConfigurations": [...],
                                                                        "ipamPoolPrefixAllocations": [
                                                                            {
                                                                                "allocatedAddressPrefixes": ["str"],
                                                                                "id": "str",
                                                                                "numberOfIpAddresses": "str",
                                                                            }
                                                                        ],
                                                                        "name": "str",
                                                                        "natGateway": {"id": "str"},
                                                                        "networkSecurityGroup": {
                                                                            "defaultSecurityRules": [
                                                                                {
                                                                                    "access": "str",
                                                                                    "description": "str",
                                                                                    "destinationAddressPrefix": "str",
                                                                                    "destinationAddressPrefixes": [
                                                                                        "str"
                                                                                    ],
                                                                                    "destinationApplicationSecurityGroups": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "location": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "resourceGuid": "str",
                                                                                            "tags": {"str": "str"},
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "destinationPortRange": "str",
                                                                                    "destinationPortRanges": ["str"],
                                                                                    "direction": "str",
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "priority": 0,
                                                                                    "protocol": "str",
                                                                                    "provisioningState": "str",
                                                                                    "sourceAddressPrefix": "str",
                                                                                    "sourceAddressPrefixes": ["str"],
                                                                                    "sourceApplicationSecurityGroups": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "location": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "resourceGuid": "str",
                                                                                            "tags": {"str": "str"},
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "sourcePortRange": "str",
                                                                                    "sourcePortRanges": ["str"],
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "etag": "str",
                                                                            "flowLogs": [
                                                                                {
                                                                                    "enabled": bool,
                                                                                    "enabledFilteringCriteria": "str",
                                                                                    "etag": "str",
                                                                                    "flowAnalyticsConfiguration": {
                                                                                        "networkWatcherFlowAnalyticsConfiguration": {
                                                                                            "enabled": bool,
                                                                                            "trafficAnalyticsInterval": 0,
                                                                                            "workspaceId": "str",
                                                                                            "workspaceRegion": "str",
                                                                                            "workspaceResourceId": "str",
                                                                                        }
                                                                                    },
                                                                                    "format": {
                                                                                        "type": "str",
                                                                                        "version": 0,
                                                                                    },
                                                                                    "id": "str",
                                                                                    "identity": {
                                                                                        "principalId": "str",
                                                                                        "tenantId": "str",
                                                                                        "type": "str",
                                                                                        "userAssignedIdentities": {
                                                                                            "str": {
                                                                                                "clientId": "str",
                                                                                                "principalId": "str",
                                                                                            }
                                                                                        },
                                                                                    },
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "recordTypes": "str",
                                                                                    "retentionPolicy": {
                                                                                        "days": 0,
                                                                                        "enabled": False,
                                                                                    },
                                                                                    "storageId": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "targetResourceGuid": "str",
                                                                                    "targetResourceId": "str",
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "flushConnection": bool,
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "networkInterfaces": [...],
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "securityRules": [
                                                                                {
                                                                                    "access": "str",
                                                                                    "description": "str",
                                                                                    "destinationAddressPrefix": "str",
                                                                                    "destinationAddressPrefixes": [
                                                                                        "str"
                                                                                    ],
                                                                                    "destinationApplicationSecurityGroups": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "location": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "resourceGuid": "str",
                                                                                            "tags": {"str": "str"},
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "destinationPortRange": "str",
                                                                                    "destinationPortRanges": ["str"],
                                                                                    "direction": "str",
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "priority": 0,
                                                                                    "protocol": "str",
                                                                                    "provisioningState": "str",
                                                                                    "sourceAddressPrefix": "str",
                                                                                    "sourceAddressPrefixes": ["str"],
                                                                                    "sourceApplicationSecurityGroups": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "location": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "resourceGuid": "str",
                                                                                            "tags": {"str": "str"},
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "sourcePortRange": "str",
                                                                                    "sourcePortRanges": ["str"],
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "subnets": [...],
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        },
                                                                        "privateEndpointNetworkPolicies": "Disabled",
                                                                        "privateEndpoints": [...],
                                                                        "privateLinkServiceNetworkPolicies": "Enabled",
                                                                        "provisioningState": "str",
                                                                        "purpose": "str",
                                                                        "resourceNavigationLinks": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "link": "str",
                                                                                "linkedResourceType": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "routeTable": {
                                                                            "disableBgpRoutePropagation": bool,
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "routes": [
                                                                                {
                                                                                    "addressPrefix": "str",
                                                                                    "etag": "str",
                                                                                    "hasBgpOverride": bool,
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "nextHopIpAddress": "str",
                                                                                    "nextHopType": "str",
                                                                                    "provisioningState": "str",
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "subnets": [...],
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        },
                                                                        "serviceAssociationLinks": [
                                                                            {
                                                                                "allowDelete": bool,
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "link": "str",
                                                                                "linkedResourceType": "str",
                                                                                "locations": ["str"],
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "serviceEndpointPolicies": [
                                                                            {
                                                                                "contextualServiceEndpointPolicies": [
                                                                                    "str"
                                                                                ],
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "kind": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "serviceAlias": "str",
                                                                                "serviceEndpointPolicyDefinitions": [
                                                                                    {
                                                                                        "description": "str",
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "service": "str",
                                                                                        "serviceResources": ["str"],
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "subnets": [...],
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "serviceEndpoints": [
                                                                            {
                                                                                "locations": ["str"],
                                                                                "networkIdentifier": {"id": "str"},
                                                                                "provisioningState": "str",
                                                                                "service": "str",
                                                                            }
                                                                        ],
                                                                        "sharingScope": "str",
                                                                        "type": "str",
                                                                    },
                                                                },
                                                                "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                "linkedPublicIPAddress": ...,
                                                                "location": "str",
                                                                "migrationPhase": "str",
                                                                "name": "str",
                                                                "natGateway": {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "idleTimeoutInMinutes": 0,
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "publicIpAddresses": [{"id": "str"}],
                                                                    "publicIpAddressesV6": [{"id": "str"}],
                                                                    "publicIpPrefixes": [{"id": "str"}],
                                                                    "publicIpPrefixesV6": [{"id": "str"}],
                                                                    "resourceGuid": "str",
                                                                    "sku": {"name": "str"},
                                                                    "sourceVirtualNetwork": {"id": "str"},
                                                                    "subnets": [{"id": "str"}],
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                    "zones": ["str"],
                                                                },
                                                                "provisioningState": "str",
                                                                "publicIPAddressVersion": "str",
                                                                "publicIPAllocationMethod": "str",
                                                                "publicIPPrefix": {"id": "str"},
                                                                "resourceGuid": "str",
                                                                "servicePublicIPAddress": ...,
                                                                "sku": {"name": "str", "tier": "str"},
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                                "zones": ["str"],
                                                            },
                                                            "publicIPPrefix": {"id": "str"},
                                                            "subnet": {
                                                                "addressPrefix": "str",
                                                                "addressPrefixes": ["str"],
                                                                "applicationGatewayIPConfigurations": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "subnet": {"id": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "defaultOutboundAccess": bool,
                                                                "delegations": [
                                                                    {
                                                                        "actions": ["str"],
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "serviceName": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "etag": "str",
                                                                "id": "str",
                                                                "ipAllocations": [{"id": "str"}],
                                                                "ipConfigurationProfiles": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "subnet": ...,
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "ipConfigurations": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "privateIPAddress": "str",
                                                                        "privateIPAllocationMethod": "str",
                                                                        "provisioningState": "str",
                                                                        "publicIPAddress": {
                                                                            "ddosSettings": {
                                                                                "ddosProtectionPlan": {"id": "str"},
                                                                                "protectionMode": "str",
                                                                            },
                                                                            "deleteOption": "str",
                                                                            "dnsSettings": {
                                                                                "domainNameLabel": "str",
                                                                                "domainNameLabelScope": "str",
                                                                                "fqdn": "str",
                                                                                "reverseFqdn": "str",
                                                                            },
                                                                            "etag": "str",
                                                                            "extendedLocation": {
                                                                                "name": "str",
                                                                                "type": "str",
                                                                            },
                                                                            "id": "str",
                                                                            "idleTimeoutInMinutes": 0,
                                                                            "ipAddress": "str",
                                                                            "ipConfiguration": ...,
                                                                            "ipTags": [
                                                                                {"ipTagType": "str", "tag": "str"}
                                                                            ],
                                                                            "linkedPublicIPAddress": ...,
                                                                            "location": "str",
                                                                            "migrationPhase": "str",
                                                                            "name": "str",
                                                                            "natGateway": {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "idleTimeoutInMinutes": 0,
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "publicIpAddresses": [{"id": "str"}],
                                                                                "publicIpAddressesV6": [{"id": "str"}],
                                                                                "publicIpPrefixes": [{"id": "str"}],
                                                                                "publicIpPrefixesV6": [{"id": "str"}],
                                                                                "resourceGuid": "str",
                                                                                "sku": {"name": "str"},
                                                                                "sourceVirtualNetwork": {"id": "str"},
                                                                                "subnets": [{"id": "str"}],
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                                "zones": ["str"],
                                                                            },
                                                                            "provisioningState": "str",
                                                                            "publicIPAddressVersion": "str",
                                                                            "publicIPAllocationMethod": "str",
                                                                            "publicIPPrefix": {"id": "str"},
                                                                            "resourceGuid": "str",
                                                                            "servicePublicIPAddress": ...,
                                                                            "sku": {"name": "str", "tier": "str"},
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                            "zones": ["str"],
                                                                        },
                                                                        "subnet": ...,
                                                                    }
                                                                ],
                                                                "ipamPoolPrefixAllocations": [
                                                                    {
                                                                        "allocatedAddressPrefixes": ["str"],
                                                                        "id": "str",
                                                                        "numberOfIpAddresses": "str",
                                                                    }
                                                                ],
                                                                "name": "str",
                                                                "natGateway": {"id": "str"},
                                                                "networkSecurityGroup": {
                                                                    "defaultSecurityRules": [
                                                                        {
                                                                            "access": "str",
                                                                            "description": "str",
                                                                            "destinationAddressPrefix": "str",
                                                                            "destinationAddressPrefixes": ["str"],
                                                                            "destinationApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "destinationPortRange": "str",
                                                                            "destinationPortRanges": ["str"],
                                                                            "direction": "str",
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "priority": 0,
                                                                            "protocol": "str",
                                                                            "provisioningState": "str",
                                                                            "sourceAddressPrefix": "str",
                                                                            "sourceAddressPrefixes": ["str"],
                                                                            "sourceApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "sourcePortRange": "str",
                                                                            "sourcePortRanges": ["str"],
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "etag": "str",
                                                                    "flowLogs": [
                                                                        {
                                                                            "enabled": bool,
                                                                            "enabledFilteringCriteria": "str",
                                                                            "etag": "str",
                                                                            "flowAnalyticsConfiguration": {
                                                                                "networkWatcherFlowAnalyticsConfiguration": {
                                                                                    "enabled": bool,
                                                                                    "trafficAnalyticsInterval": 0,
                                                                                    "workspaceId": "str",
                                                                                    "workspaceRegion": "str",
                                                                                    "workspaceResourceId": "str",
                                                                                }
                                                                            },
                                                                            "format": {"type": "str", "version": 0},
                                                                            "id": "str",
                                                                            "identity": {
                                                                                "principalId": "str",
                                                                                "tenantId": "str",
                                                                                "type": "str",
                                                                                "userAssignedIdentities": {
                                                                                    "str": {
                                                                                        "clientId": "str",
                                                                                        "principalId": "str",
                                                                                    }
                                                                                },
                                                                            },
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "recordTypes": "str",
                                                                            "retentionPolicy": {
                                                                                "days": 0,
                                                                                "enabled": False,
                                                                            },
                                                                            "storageId": "str",
                                                                            "tags": {"str": "str"},
                                                                            "targetResourceGuid": "str",
                                                                            "targetResourceId": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "flushConnection": bool,
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "networkInterfaces": [...],
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "securityRules": [
                                                                        {
                                                                            "access": "str",
                                                                            "description": "str",
                                                                            "destinationAddressPrefix": "str",
                                                                            "destinationAddressPrefixes": ["str"],
                                                                            "destinationApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "destinationPortRange": "str",
                                                                            "destinationPortRanges": ["str"],
                                                                            "direction": "str",
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "priority": 0,
                                                                            "protocol": "str",
                                                                            "provisioningState": "str",
                                                                            "sourceAddressPrefix": "str",
                                                                            "sourceAddressPrefixes": ["str"],
                                                                            "sourceApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "sourcePortRange": "str",
                                                                            "sourcePortRanges": ["str"],
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "subnets": [...],
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                },
                                                                "privateEndpointNetworkPolicies": "Disabled",
                                                                "privateEndpoints": [...],
                                                                "privateLinkServiceNetworkPolicies": "Enabled",
                                                                "provisioningState": "str",
                                                                "purpose": "str",
                                                                "resourceNavigationLinks": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "link": "str",
                                                                        "linkedResourceType": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "routeTable": {
                                                                    "disableBgpRoutePropagation": bool,
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "routes": [
                                                                        {
                                                                            "addressPrefix": "str",
                                                                            "etag": "str",
                                                                            "hasBgpOverride": bool,
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "nextHopIpAddress": "str",
                                                                            "nextHopType": "str",
                                                                            "provisioningState": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "subnets": [...],
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                },
                                                                "serviceAssociationLinks": [
                                                                    {
                                                                        "allowDelete": bool,
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "link": "str",
                                                                        "linkedResourceType": "str",
                                                                        "locations": ["str"],
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "serviceEndpointPolicies": [
                                                                    {
                                                                        "contextualServiceEndpointPolicies": ["str"],
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "kind": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "serviceAlias": "str",
                                                                        "serviceEndpointPolicyDefinitions": [
                                                                            {
                                                                                "description": "str",
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "service": "str",
                                                                                "serviceResources": ["str"],
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "subnets": [...],
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "serviceEndpoints": [
                                                                    {
                                                                        "locations": ["str"],
                                                                        "networkIdentifier": {"id": "str"},
                                                                        "provisioningState": "str",
                                                                        "service": "str",
                                                                    }
                                                                ],
                                                                "sharingScope": "str",
                                                                "type": "str",
                                                            },
                                                            "type": "str",
                                                            "zones": ["str"],
                                                        },
                                                        "destinationNetworkInterfaceIPConfiguration": {
                                                            "applicationGatewayBackendAddressPools": [
                                                                {
                                                                    "backendAddresses": [
                                                                        {"fqdn": "str", "ipAddress": "str"}
                                                                    ],
                                                                    "backendIPConfigurations": [...],
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "applicationSecurityGroups": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "etag": "str",
                                                            "gatewayLoadBalancer": {"id": "str"},
                                                            "id": "str",
                                                            "loadBalancerBackendAddressPools": [
                                                                {
                                                                    "backendIPConfigurations": [...],
                                                                    "drainPeriodInSeconds": 0,
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "inboundNatRules": [{"id": "str"}],
                                                                    "loadBalancerBackendAddresses": [
                                                                        {
                                                                            "adminState": "str",
                                                                            "inboundNatRulesPortMapping": [
                                                                                {
                                                                                    "backendPort": 0,
                                                                                    "frontendPort": 0,
                                                                                    "inboundNatRuleName": "str",
                                                                                }
                                                                            ],
                                                                            "ipAddress": "str",
                                                                            "loadBalancerFrontendIPConfiguration": {
                                                                                "id": "str"
                                                                            },
                                                                            "name": "str",
                                                                            "networkInterfaceIPConfiguration": {
                                                                                "id": "str"
                                                                            },
                                                                            "subnet": {"id": "str"},
                                                                            "virtualNetwork": {"id": "str"},
                                                                        }
                                                                    ],
                                                                    "loadBalancingRules": [{"id": "str"}],
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "outboundRule": {"id": "str"},
                                                                    "outboundRules": [{"id": "str"}],
                                                                    "provisioningState": "str",
                                                                    "syncMode": "str",
                                                                    "tunnelInterfaces": [
                                                                        {
                                                                            "identifier": 0,
                                                                            "port": 0,
                                                                            "protocol": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "type": "str",
                                                                    "virtualNetwork": {"id": "str"},
                                                                }
                                                            ],
                                                            "loadBalancerInboundNatRules": [
                                                                {
                                                                    "backendAddressPool": {"id": "str"},
                                                                    "backendIPConfiguration": ...,
                                                                    "backendPort": 0,
                                                                    "enableFloatingIP": bool,
                                                                    "enableTcpReset": bool,
                                                                    "etag": "str",
                                                                    "frontendIPConfiguration": {"id": "str"},
                                                                    "frontendPort": 0,
                                                                    "frontendPortRangeEnd": 0,
                                                                    "frontendPortRangeStart": 0,
                                                                    "id": "str",
                                                                    "idleTimeoutInMinutes": 0,
                                                                    "name": "str",
                                                                    "protocol": "str",
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "name": "str",
                                                            "primary": bool,
                                                            "privateIPAddress": "str",
                                                            "privateIPAddressPrefixLength": 0,
                                                            "privateIPAddressVersion": "str",
                                                            "privateIPAllocationMethod": "str",
                                                            "privateLinkConnectionProperties": {
                                                                "fqdns": ["str"],
                                                                "groupId": "str",
                                                                "requiredMemberName": "str",
                                                            },
                                                            "provisioningState": "str",
                                                            "publicIPAddress": {
                                                                "ddosSettings": {
                                                                    "ddosProtectionPlan": {"id": "str"},
                                                                    "protectionMode": "str",
                                                                },
                                                                "deleteOption": "str",
                                                                "dnsSettings": {
                                                                    "domainNameLabel": "str",
                                                                    "domainNameLabelScope": "str",
                                                                    "fqdn": "str",
                                                                    "reverseFqdn": "str",
                                                                },
                                                                "etag": "str",
                                                                "extendedLocation": {"name": "str", "type": "str"},
                                                                "id": "str",
                                                                "idleTimeoutInMinutes": 0,
                                                                "ipAddress": "str",
                                                                "ipConfiguration": {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "privateIPAddress": "str",
                                                                    "privateIPAllocationMethod": "str",
                                                                    "provisioningState": "str",
                                                                    "publicIPAddress": ...,
                                                                    "subnet": {
                                                                        "addressPrefix": "str",
                                                                        "addressPrefixes": ["str"],
                                                                        "applicationGatewayIPConfigurations": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "subnet": {"id": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "defaultOutboundAccess": bool,
                                                                        "delegations": [
                                                                            {
                                                                                "actions": ["str"],
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "serviceName": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "ipAllocations": [{"id": "str"}],
                                                                        "ipConfigurationProfiles": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "subnet": ...,
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "ipConfigurations": [...],
                                                                        "ipamPoolPrefixAllocations": [
                                                                            {
                                                                                "allocatedAddressPrefixes": ["str"],
                                                                                "id": "str",
                                                                                "numberOfIpAddresses": "str",
                                                                            }
                                                                        ],
                                                                        "name": "str",
                                                                        "natGateway": {"id": "str"},
                                                                        "networkSecurityGroup": {
                                                                            "defaultSecurityRules": [
                                                                                {
                                                                                    "access": "str",
                                                                                    "description": "str",
                                                                                    "destinationAddressPrefix": "str",
                                                                                    "destinationAddressPrefixes": [
                                                                                        "str"
                                                                                    ],
                                                                                    "destinationApplicationSecurityGroups": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "location": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "resourceGuid": "str",
                                                                                            "tags": {"str": "str"},
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "destinationPortRange": "str",
                                                                                    "destinationPortRanges": ["str"],
                                                                                    "direction": "str",
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "priority": 0,
                                                                                    "protocol": "str",
                                                                                    "provisioningState": "str",
                                                                                    "sourceAddressPrefix": "str",
                                                                                    "sourceAddressPrefixes": ["str"],
                                                                                    "sourceApplicationSecurityGroups": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "location": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "resourceGuid": "str",
                                                                                            "tags": {"str": "str"},
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "sourcePortRange": "str",
                                                                                    "sourcePortRanges": ["str"],
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "etag": "str",
                                                                            "flowLogs": [
                                                                                {
                                                                                    "enabled": bool,
                                                                                    "enabledFilteringCriteria": "str",
                                                                                    "etag": "str",
                                                                                    "flowAnalyticsConfiguration": {
                                                                                        "networkWatcherFlowAnalyticsConfiguration": {
                                                                                            "enabled": bool,
                                                                                            "trafficAnalyticsInterval": 0,
                                                                                            "workspaceId": "str",
                                                                                            "workspaceRegion": "str",
                                                                                            "workspaceResourceId": "str",
                                                                                        }
                                                                                    },
                                                                                    "format": {
                                                                                        "type": "str",
                                                                                        "version": 0,
                                                                                    },
                                                                                    "id": "str",
                                                                                    "identity": {
                                                                                        "principalId": "str",
                                                                                        "tenantId": "str",
                                                                                        "type": "str",
                                                                                        "userAssignedIdentities": {
                                                                                            "str": {
                                                                                                "clientId": "str",
                                                                                                "principalId": "str",
                                                                                            }
                                                                                        },
                                                                                    },
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "recordTypes": "str",
                                                                                    "retentionPolicy": {
                                                                                        "days": 0,
                                                                                        "enabled": False,
                                                                                    },
                                                                                    "storageId": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "targetResourceGuid": "str",
                                                                                    "targetResourceId": "str",
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "flushConnection": bool,
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "networkInterfaces": [...],
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "securityRules": [
                                                                                {
                                                                                    "access": "str",
                                                                                    "description": "str",
                                                                                    "destinationAddressPrefix": "str",
                                                                                    "destinationAddressPrefixes": [
                                                                                        "str"
                                                                                    ],
                                                                                    "destinationApplicationSecurityGroups": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "location": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "resourceGuid": "str",
                                                                                            "tags": {"str": "str"},
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "destinationPortRange": "str",
                                                                                    "destinationPortRanges": ["str"],
                                                                                    "direction": "str",
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "priority": 0,
                                                                                    "protocol": "str",
                                                                                    "provisioningState": "str",
                                                                                    "sourceAddressPrefix": "str",
                                                                                    "sourceAddressPrefixes": ["str"],
                                                                                    "sourceApplicationSecurityGroups": [
                                                                                        {
                                                                                            "etag": "str",
                                                                                            "id": "str",
                                                                                            "location": "str",
                                                                                            "name": "str",
                                                                                            "provisioningState": "str",
                                                                                            "resourceGuid": "str",
                                                                                            "tags": {"str": "str"},
                                                                                            "type": "str",
                                                                                        }
                                                                                    ],
                                                                                    "sourcePortRange": "str",
                                                                                    "sourcePortRanges": ["str"],
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "subnets": [...],
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        },
                                                                        "privateEndpointNetworkPolicies": "Disabled",
                                                                        "privateEndpoints": [...],
                                                                        "privateLinkServiceNetworkPolicies": "Enabled",
                                                                        "provisioningState": "str",
                                                                        "purpose": "str",
                                                                        "resourceNavigationLinks": [
                                                                            {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "link": "str",
                                                                                "linkedResourceType": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "routeTable": {
                                                                            "disableBgpRoutePropagation": bool,
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "routes": [
                                                                                {
                                                                                    "addressPrefix": "str",
                                                                                    "etag": "str",
                                                                                    "hasBgpOverride": bool,
                                                                                    "id": "str",
                                                                                    "name": "str",
                                                                                    "nextHopIpAddress": "str",
                                                                                    "nextHopType": "str",
                                                                                    "provisioningState": "str",
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "subnets": [...],
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        },
                                                                        "serviceAssociationLinks": [
                                                                            {
                                                                                "allowDelete": bool,
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "link": "str",
                                                                                "linkedResourceType": "str",
                                                                                "locations": ["str"],
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "serviceEndpointPolicies": [
                                                                            {
                                                                                "contextualServiceEndpointPolicies": [
                                                                                    "str"
                                                                                ],
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "kind": "str",
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "resourceGuid": "str",
                                                                                "serviceAlias": "str",
                                                                                "serviceEndpointPolicyDefinitions": [
                                                                                    {
                                                                                        "description": "str",
                                                                                        "etag": "str",
                                                                                        "id": "str",
                                                                                        "name": "str",
                                                                                        "provisioningState": "str",
                                                                                        "service": "str",
                                                                                        "serviceResources": ["str"],
                                                                                        "type": "str",
                                                                                    }
                                                                                ],
                                                                                "subnets": [...],
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "serviceEndpoints": [
                                                                            {
                                                                                "locations": ["str"],
                                                                                "networkIdentifier": {"id": "str"},
                                                                                "provisioningState": "str",
                                                                                "service": "str",
                                                                            }
                                                                        ],
                                                                        "sharingScope": "str",
                                                                        "type": "str",
                                                                    },
                                                                },
                                                                "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                "linkedPublicIPAddress": ...,
                                                                "location": "str",
                                                                "migrationPhase": "str",
                                                                "name": "str",
                                                                "natGateway": {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "idleTimeoutInMinutes": 0,
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "publicIpAddresses": [{"id": "str"}],
                                                                    "publicIpAddressesV6": [{"id": "str"}],
                                                                    "publicIpPrefixes": [{"id": "str"}],
                                                                    "publicIpPrefixesV6": [{"id": "str"}],
                                                                    "resourceGuid": "str",
                                                                    "sku": {"name": "str"},
                                                                    "sourceVirtualNetwork": {"id": "str"},
                                                                    "subnets": [{"id": "str"}],
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                    "zones": ["str"],
                                                                },
                                                                "provisioningState": "str",
                                                                "publicIPAddressVersion": "str",
                                                                "publicIPAllocationMethod": "str",
                                                                "publicIPPrefix": {"id": "str"},
                                                                "resourceGuid": "str",
                                                                "servicePublicIPAddress": ...,
                                                                "sku": {"name": "str", "tier": "str"},
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                                "zones": ["str"],
                                                            },
                                                            "subnet": {
                                                                "addressPrefix": "str",
                                                                "addressPrefixes": ["str"],
                                                                "applicationGatewayIPConfigurations": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "subnet": {"id": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "defaultOutboundAccess": bool,
                                                                "delegations": [
                                                                    {
                                                                        "actions": ["str"],
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "serviceName": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "etag": "str",
                                                                "id": "str",
                                                                "ipAllocations": [{"id": "str"}],
                                                                "ipConfigurationProfiles": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "subnet": ...,
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "ipConfigurations": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "privateIPAddress": "str",
                                                                        "privateIPAllocationMethod": "str",
                                                                        "provisioningState": "str",
                                                                        "publicIPAddress": {
                                                                            "ddosSettings": {
                                                                                "ddosProtectionPlan": {"id": "str"},
                                                                                "protectionMode": "str",
                                                                            },
                                                                            "deleteOption": "str",
                                                                            "dnsSettings": {
                                                                                "domainNameLabel": "str",
                                                                                "domainNameLabelScope": "str",
                                                                                "fqdn": "str",
                                                                                "reverseFqdn": "str",
                                                                            },
                                                                            "etag": "str",
                                                                            "extendedLocation": {
                                                                                "name": "str",
                                                                                "type": "str",
                                                                            },
                                                                            "id": "str",
                                                                            "idleTimeoutInMinutes": 0,
                                                                            "ipAddress": "str",
                                                                            "ipConfiguration": ...,
                                                                            "ipTags": [
                                                                                {"ipTagType": "str", "tag": "str"}
                                                                            ],
                                                                            "linkedPublicIPAddress": ...,
                                                                            "location": "str",
                                                                            "migrationPhase": "str",
                                                                            "name": "str",
                                                                            "natGateway": {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "idleTimeoutInMinutes": 0,
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "publicIpAddresses": [{"id": "str"}],
                                                                                "publicIpAddressesV6": [{"id": "str"}],
                                                                                "publicIpPrefixes": [{"id": "str"}],
                                                                                "publicIpPrefixesV6": [{"id": "str"}],
                                                                                "resourceGuid": "str",
                                                                                "sku": {"name": "str"},
                                                                                "sourceVirtualNetwork": {"id": "str"},
                                                                                "subnets": [{"id": "str"}],
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                                "zones": ["str"],
                                                                            },
                                                                            "provisioningState": "str",
                                                                            "publicIPAddressVersion": "str",
                                                                            "publicIPAllocationMethod": "str",
                                                                            "publicIPPrefix": {"id": "str"},
                                                                            "resourceGuid": "str",
                                                                            "servicePublicIPAddress": ...,
                                                                            "sku": {"name": "str", "tier": "str"},
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                            "zones": ["str"],
                                                                        },
                                                                        "subnet": ...,
                                                                    }
                                                                ],
                                                                "ipamPoolPrefixAllocations": [
                                                                    {
                                                                        "allocatedAddressPrefixes": ["str"],
                                                                        "id": "str",
                                                                        "numberOfIpAddresses": "str",
                                                                    }
                                                                ],
                                                                "name": "str",
                                                                "natGateway": {"id": "str"},
                                                                "networkSecurityGroup": {
                                                                    "defaultSecurityRules": [
                                                                        {
                                                                            "access": "str",
                                                                            "description": "str",
                                                                            "destinationAddressPrefix": "str",
                                                                            "destinationAddressPrefixes": ["str"],
                                                                            "destinationApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "destinationPortRange": "str",
                                                                            "destinationPortRanges": ["str"],
                                                                            "direction": "str",
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "priority": 0,
                                                                            "protocol": "str",
                                                                            "provisioningState": "str",
                                                                            "sourceAddressPrefix": "str",
                                                                            "sourceAddressPrefixes": ["str"],
                                                                            "sourceApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "sourcePortRange": "str",
                                                                            "sourcePortRanges": ["str"],
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "etag": "str",
                                                                    "flowLogs": [
                                                                        {
                                                                            "enabled": bool,
                                                                            "enabledFilteringCriteria": "str",
                                                                            "etag": "str",
                                                                            "flowAnalyticsConfiguration": {
                                                                                "networkWatcherFlowAnalyticsConfiguration": {
                                                                                    "enabled": bool,
                                                                                    "trafficAnalyticsInterval": 0,
                                                                                    "workspaceId": "str",
                                                                                    "workspaceRegion": "str",
                                                                                    "workspaceResourceId": "str",
                                                                                }
                                                                            },
                                                                            "format": {"type": "str", "version": 0},
                                                                            "id": "str",
                                                                            "identity": {
                                                                                "principalId": "str",
                                                                                "tenantId": "str",
                                                                                "type": "str",
                                                                                "userAssignedIdentities": {
                                                                                    "str": {
                                                                                        "clientId": "str",
                                                                                        "principalId": "str",
                                                                                    }
                                                                                },
                                                                            },
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "recordTypes": "str",
                                                                            "retentionPolicy": {
                                                                                "days": 0,
                                                                                "enabled": False,
                                                                            },
                                                                            "storageId": "str",
                                                                            "tags": {"str": "str"},
                                                                            "targetResourceGuid": "str",
                                                                            "targetResourceId": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "flushConnection": bool,
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "networkInterfaces": [...],
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "securityRules": [
                                                                        {
                                                                            "access": "str",
                                                                            "description": "str",
                                                                            "destinationAddressPrefix": "str",
                                                                            "destinationAddressPrefixes": ["str"],
                                                                            "destinationApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "destinationPortRange": "str",
                                                                            "destinationPortRanges": ["str"],
                                                                            "direction": "str",
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "priority": 0,
                                                                            "protocol": "str",
                                                                            "provisioningState": "str",
                                                                            "sourceAddressPrefix": "str",
                                                                            "sourceAddressPrefixes": ["str"],
                                                                            "sourceApplicationSecurityGroups": [
                                                                                {
                                                                                    "etag": "str",
                                                                                    "id": "str",
                                                                                    "location": "str",
                                                                                    "name": "str",
                                                                                    "provisioningState": "str",
                                                                                    "resourceGuid": "str",
                                                                                    "tags": {"str": "str"},
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "sourcePortRange": "str",
                                                                            "sourcePortRanges": ["str"],
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "subnets": [...],
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                },
                                                                "privateEndpointNetworkPolicies": "Disabled",
                                                                "privateEndpoints": [...],
                                                                "privateLinkServiceNetworkPolicies": "Enabled",
                                                                "provisioningState": "str",
                                                                "purpose": "str",
                                                                "resourceNavigationLinks": [
                                                                    {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "link": "str",
                                                                        "linkedResourceType": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "routeTable": {
                                                                    "disableBgpRoutePropagation": bool,
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "routes": [
                                                                        {
                                                                            "addressPrefix": "str",
                                                                            "etag": "str",
                                                                            "hasBgpOverride": bool,
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "nextHopIpAddress": "str",
                                                                            "nextHopType": "str",
                                                                            "provisioningState": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "subnets": [...],
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                },
                                                                "serviceAssociationLinks": [
                                                                    {
                                                                        "allowDelete": bool,
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "link": "str",
                                                                        "linkedResourceType": "str",
                                                                        "locations": ["str"],
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "serviceEndpointPolicies": [
                                                                    {
                                                                        "contextualServiceEndpointPolicies": ["str"],
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "kind": "str",
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "resourceGuid": "str",
                                                                        "serviceAlias": "str",
                                                                        "serviceEndpointPolicyDefinitions": [
                                                                            {
                                                                                "description": "str",
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "service": "str",
                                                                                "serviceResources": ["str"],
                                                                                "type": "str",
                                                                            }
                                                                        ],
                                                                        "subnets": [...],
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                    }
                                                                ],
                                                                "serviceEndpoints": [
                                                                    {
                                                                        "locations": ["str"],
                                                                        "networkIdentifier": {"id": "str"},
                                                                        "provisioningState": "str",
                                                                        "service": "str",
                                                                    }
                                                                ],
                                                                "sharingScope": "str",
                                                                "type": "str",
                                                            },
                                                            "type": "str",
                                                            "virtualNetworkTaps": [...],
                                                        },
                                                        "destinationPort": 0,
                                                        "etag": "str",
                                                        "id": "str",
                                                        "location": "str",
                                                        "name": "str",
                                                        "networkInterfaceTapConfigurations": [...],
                                                        "provisioningState": "str",
                                                        "resourceGuid": "str",
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                    },
                                                }
                                            ],
                                            "type": "str",
                                            "virtualMachine": {"id": "str"},
                                            "vnetEncryptionSupported": bool,
                                            "workloadType": "str",
                                        }
                                    ],
                                    "privateLinkServiceConnections": [
                                        {
                                            "etag": "str",
                                            "groupIds": ["str"],
                                            "id": "str",
                                            "name": "str",
                                            "privateLinkServiceConnectionState": {
                                                "actionsRequired": "str",
                                                "description": "str",
                                                "status": "str",
                                            },
                                            "privateLinkServiceId": "str",
                                            "provisioningState": "str",
                                            "requestMessage": "str",
                                            "type": "str",
                                        }
                                    ],
                                    "provisioningState": "str",
                                    "subnet": {
                                        "addressPrefix": "str",
                                        "addressPrefixes": ["str"],
                                        "applicationGatewayIPConfigurations": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "subnet": {"id": "str"},
                                                "type": "str",
                                            }
                                        ],
                                        "defaultOutboundAccess": bool,
                                        "delegations": [
                                            {
                                                "actions": ["str"],
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "serviceName": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "etag": "str",
                                        "id": "str",
                                        "ipAllocations": [{"id": "str"}],
                                        "ipConfigurationProfiles": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "subnet": ...,
                                                "type": "str",
                                            }
                                        ],
                                        "ipConfigurations": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "name": "str",
                                                "privateIPAddress": "str",
                                                "privateIPAllocationMethod": "str",
                                                "provisioningState": "str",
                                                "publicIPAddress": {
                                                    "ddosSettings": {
                                                        "ddosProtectionPlan": {"id": "str"},
                                                        "protectionMode": "str",
                                                    },
                                                    "deleteOption": "str",
                                                    "dnsSettings": {
                                                        "domainNameLabel": "str",
                                                        "domainNameLabelScope": "str",
                                                        "fqdn": "str",
                                                        "reverseFqdn": "str",
                                                    },
                                                    "etag": "str",
                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                    "id": "str",
                                                    "idleTimeoutInMinutes": 0,
                                                    "ipAddress": "str",
                                                    "ipConfiguration": ...,
                                                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                    "linkedPublicIPAddress": ...,
                                                    "location": "str",
                                                    "migrationPhase": "str",
                                                    "name": "str",
                                                    "natGateway": {
                                                        "etag": "str",
                                                        "id": "str",
                                                        "idleTimeoutInMinutes": 0,
                                                        "location": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "publicIpAddresses": [{"id": "str"}],
                                                        "publicIpAddressesV6": [{"id": "str"}],
                                                        "publicIpPrefixes": [{"id": "str"}],
                                                        "publicIpPrefixesV6": [{"id": "str"}],
                                                        "resourceGuid": "str",
                                                        "sku": {"name": "str"},
                                                        "sourceVirtualNetwork": {"id": "str"},
                                                        "subnets": [{"id": "str"}],
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                        "zones": ["str"],
                                                    },
                                                    "provisioningState": "str",
                                                    "publicIPAddressVersion": "str",
                                                    "publicIPAllocationMethod": "str",
                                                    "publicIPPrefix": {"id": "str"},
                                                    "resourceGuid": "str",
                                                    "servicePublicIPAddress": ...,
                                                    "sku": {"name": "str", "tier": "str"},
                                                    "tags": {"str": "str"},
                                                    "type": "str",
                                                    "zones": ["str"],
                                                },
                                                "subnet": ...,
                                            }
                                        ],
                                        "ipamPoolPrefixAllocations": [
                                            {
                                                "allocatedAddressPrefixes": ["str"],
                                                "id": "str",
                                                "numberOfIpAddresses": "str",
                                            }
                                        ],
                                        "name": "str",
                                        "natGateway": {"id": "str"},
                                        "networkSecurityGroup": {
                                            "defaultSecurityRules": [
                                                {
                                                    "access": "str",
                                                    "description": "str",
                                                    "destinationAddressPrefix": "str",
                                                    "destinationAddressPrefixes": ["str"],
                                                    "destinationApplicationSecurityGroups": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "destinationPortRange": "str",
                                                    "destinationPortRanges": ["str"],
                                                    "direction": "str",
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "priority": 0,
                                                    "protocol": "str",
                                                    "provisioningState": "str",
                                                    "sourceAddressPrefix": "str",
                                                    "sourceAddressPrefixes": ["str"],
                                                    "sourceApplicationSecurityGroups": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "sourcePortRange": "str",
                                                    "sourcePortRanges": ["str"],
                                                    "type": "str",
                                                }
                                            ],
                                            "etag": "str",
                                            "flowLogs": [
                                                {
                                                    "enabled": bool,
                                                    "enabledFilteringCriteria": "str",
                                                    "etag": "str",
                                                    "flowAnalyticsConfiguration": {
                                                        "networkWatcherFlowAnalyticsConfiguration": {
                                                            "enabled": bool,
                                                            "trafficAnalyticsInterval": 0,
                                                            "workspaceId": "str",
                                                            "workspaceRegion": "str",
                                                            "workspaceResourceId": "str",
                                                        }
                                                    },
                                                    "format": {"type": "str", "version": 0},
                                                    "id": "str",
                                                    "identity": {
                                                        "principalId": "str",
                                                        "tenantId": "str",
                                                        "type": "str",
                                                        "userAssignedIdentities": {
                                                            "str": {"clientId": "str", "principalId": "str"}
                                                        },
                                                    },
                                                    "location": "str",
                                                    "name": "str",
                                                    "provisioningState": "str",
                                                    "recordTypes": "str",
                                                    "retentionPolicy": {"days": 0, "enabled": False},
                                                    "storageId": "str",
                                                    "tags": {"str": "str"},
                                                    "targetResourceGuid": "str",
                                                    "targetResourceId": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "flushConnection": bool,
                                            "id": "str",
                                            "location": "str",
                                            "name": "str",
                                            "networkInterfaces": [
                                                {
                                                    "auxiliaryMode": "str",
                                                    "auxiliarySku": "str",
                                                    "defaultOutboundConnectivityEnabled": bool,
                                                    "disableTcpStateTracking": bool,
                                                    "dnsSettings": {
                                                        "appliedDnsServers": ["str"],
                                                        "dnsServers": ["str"],
                                                        "internalDnsNameLabel": "str",
                                                        "internalDomainNameSuffix": "str",
                                                        "internalFqdn": "str",
                                                    },
                                                    "dscpConfiguration": {"id": "str"},
                                                    "enableAcceleratedNetworking": bool,
                                                    "enableIPForwarding": bool,
                                                    "etag": "str",
                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                    "hostedWorkloads": ["str"],
                                                    "id": "str",
                                                    "ipConfigurations": [
                                                        {
                                                            "applicationGatewayBackendAddressPools": [
                                                                {
                                                                    "backendAddresses": [
                                                                        {"fqdn": "str", "ipAddress": "str"}
                                                                    ],
                                                                    "backendIPConfigurations": [...],
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "applicationSecurityGroups": [
                                                                {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "etag": "str",
                                                            "gatewayLoadBalancer": {"id": "str"},
                                                            "id": "str",
                                                            "loadBalancerBackendAddressPools": [
                                                                {
                                                                    "backendIPConfigurations": [...],
                                                                    "drainPeriodInSeconds": 0,
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "inboundNatRules": [{"id": "str"}],
                                                                    "loadBalancerBackendAddresses": [
                                                                        {
                                                                            "adminState": "str",
                                                                            "inboundNatRulesPortMapping": [
                                                                                {
                                                                                    "backendPort": 0,
                                                                                    "frontendPort": 0,
                                                                                    "inboundNatRuleName": "str",
                                                                                }
                                                                            ],
                                                                            "ipAddress": "str",
                                                                            "loadBalancerFrontendIPConfiguration": {
                                                                                "id": "str"
                                                                            },
                                                                            "name": "str",
                                                                            "networkInterfaceIPConfiguration": {
                                                                                "id": "str"
                                                                            },
                                                                            "subnet": {"id": "str"},
                                                                            "virtualNetwork": {"id": "str"},
                                                                        }
                                                                    ],
                                                                    "loadBalancingRules": [{"id": "str"}],
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "outboundRule": {"id": "str"},
                                                                    "outboundRules": [{"id": "str"}],
                                                                    "provisioningState": "str",
                                                                    "syncMode": "str",
                                                                    "tunnelInterfaces": [
                                                                        {
                                                                            "identifier": 0,
                                                                            "port": 0,
                                                                            "protocol": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "type": "str",
                                                                    "virtualNetwork": {"id": "str"},
                                                                }
                                                            ],
                                                            "loadBalancerInboundNatRules": [
                                                                {
                                                                    "backendAddressPool": {"id": "str"},
                                                                    "backendIPConfiguration": ...,
                                                                    "backendPort": 0,
                                                                    "enableFloatingIP": bool,
                                                                    "enableTcpReset": bool,
                                                                    "etag": "str",
                                                                    "frontendIPConfiguration": {"id": "str"},
                                                                    "frontendPort": 0,
                                                                    "frontendPortRangeEnd": 0,
                                                                    "frontendPortRangeStart": 0,
                                                                    "id": "str",
                                                                    "idleTimeoutInMinutes": 0,
                                                                    "name": "str",
                                                                    "protocol": "str",
                                                                    "provisioningState": "str",
                                                                    "type": "str",
                                                                }
                                                            ],
                                                            "name": "str",
                                                            "primary": bool,
                                                            "privateIPAddress": "str",
                                                            "privateIPAddressPrefixLength": 0,
                                                            "privateIPAddressVersion": "str",
                                                            "privateIPAllocationMethod": "str",
                                                            "privateLinkConnectionProperties": {
                                                                "fqdns": ["str"],
                                                                "groupId": "str",
                                                                "requiredMemberName": "str",
                                                            },
                                                            "provisioningState": "str",
                                                            "publicIPAddress": {
                                                                "ddosSettings": {
                                                                    "ddosProtectionPlan": {"id": "str"},
                                                                    "protectionMode": "str",
                                                                },
                                                                "deleteOption": "str",
                                                                "dnsSettings": {
                                                                    "domainNameLabel": "str",
                                                                    "domainNameLabelScope": "str",
                                                                    "fqdn": "str",
                                                                    "reverseFqdn": "str",
                                                                },
                                                                "etag": "str",
                                                                "extendedLocation": {"name": "str", "type": "str"},
                                                                "id": "str",
                                                                "idleTimeoutInMinutes": 0,
                                                                "ipAddress": "str",
                                                                "ipConfiguration": {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "name": "str",
                                                                    "privateIPAddress": "str",
                                                                    "privateIPAllocationMethod": "str",
                                                                    "provisioningState": "str",
                                                                    "publicIPAddress": ...,
                                                                    "subnet": ...,
                                                                },
                                                                "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                "linkedPublicIPAddress": ...,
                                                                "location": "str",
                                                                "migrationPhase": "str",
                                                                "name": "str",
                                                                "natGateway": {
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "idleTimeoutInMinutes": 0,
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "provisioningState": "str",
                                                                    "publicIpAddresses": [{"id": "str"}],
                                                                    "publicIpAddressesV6": [{"id": "str"}],
                                                                    "publicIpPrefixes": [{"id": "str"}],
                                                                    "publicIpPrefixesV6": [{"id": "str"}],
                                                                    "resourceGuid": "str",
                                                                    "sku": {"name": "str"},
                                                                    "sourceVirtualNetwork": {"id": "str"},
                                                                    "subnets": [{"id": "str"}],
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                    "zones": ["str"],
                                                                },
                                                                "provisioningState": "str",
                                                                "publicIPAddressVersion": "str",
                                                                "publicIPAllocationMethod": "str",
                                                                "publicIPPrefix": {"id": "str"},
                                                                "resourceGuid": "str",
                                                                "servicePublicIPAddress": ...,
                                                                "sku": {"name": "str", "tier": "str"},
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                                "zones": ["str"],
                                                            },
                                                            "subnet": ...,
                                                            "type": "str",
                                                            "virtualNetworkTaps": [
                                                                {
                                                                    "destinationLoadBalancerFrontEndIPConfiguration": {
                                                                        "etag": "str",
                                                                        "gatewayLoadBalancer": {"id": "str"},
                                                                        "id": "str",
                                                                        "inboundNatPools": [{"id": "str"}],
                                                                        "inboundNatRules": [{"id": "str"}],
                                                                        "loadBalancingRules": [{"id": "str"}],
                                                                        "name": "str",
                                                                        "outboundRules": [{"id": "str"}],
                                                                        "privateIPAddress": "str",
                                                                        "privateIPAddressVersion": "str",
                                                                        "privateIPAllocationMethod": "str",
                                                                        "provisioningState": "str",
                                                                        "publicIPAddress": {
                                                                            "ddosSettings": {
                                                                                "ddosProtectionPlan": {"id": "str"},
                                                                                "protectionMode": "str",
                                                                            },
                                                                            "deleteOption": "str",
                                                                            "dnsSettings": {
                                                                                "domainNameLabel": "str",
                                                                                "domainNameLabelScope": "str",
                                                                                "fqdn": "str",
                                                                                "reverseFqdn": "str",
                                                                            },
                                                                            "etag": "str",
                                                                            "extendedLocation": {
                                                                                "name": "str",
                                                                                "type": "str",
                                                                            },
                                                                            "id": "str",
                                                                            "idleTimeoutInMinutes": 0,
                                                                            "ipAddress": "str",
                                                                            "ipConfiguration": {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "name": "str",
                                                                                "privateIPAddress": "str",
                                                                                "privateIPAllocationMethod": "str",
                                                                                "provisioningState": "str",
                                                                                "publicIPAddress": ...,
                                                                                "subnet": ...,
                                                                            },
                                                                            "ipTags": [
                                                                                {"ipTagType": "str", "tag": "str"}
                                                                            ],
                                                                            "linkedPublicIPAddress": ...,
                                                                            "location": "str",
                                                                            "migrationPhase": "str",
                                                                            "name": "str",
                                                                            "natGateway": {
                                                                                "etag": "str",
                                                                                "id": "str",
                                                                                "idleTimeoutInMinutes": 0,
                                                                                "location": "str",
                                                                                "name": "str",
                                                                                "provisioningState": "str",
                                                                                "publicIpAddresses": [{"id": "str"}],
                                                                                "publicIpAddressesV6": [{"id": "str"}],
                                                                                "publicIpPrefixes": [{"id": "str"}],
                                                                                "publicIpPrefixesV6": [{"id": "str"}],
                                                                                "resourceGuid": "str",
                                                                                "sku": {"name": "str"},
                                                                                "sourceVirtualNetwork": {"id": "str"},
                                                                                "subnets": [{"id": "str"}],
                                                                                "tags": {"str": "str"},
                                                                                "type": "str",
                                                                                "zones": ["str"],
                                                                            },
                                                                            "provisioningState": "str",
                                                                            "publicIPAddressVersion": "str",
                                                                            "publicIPAllocationMethod": "str",
                                                                            "publicIPPrefix": {"id": "str"},
                                                                            "resourceGuid": "str",
                                                                            "servicePublicIPAddress": ...,
                                                                            "sku": {"name": "str", "tier": "str"},
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                            "zones": ["str"],
                                                                        },
                                                                        "publicIPPrefix": {"id": "str"},
                                                                        "subnet": ...,
                                                                        "type": "str",
                                                                        "zones": ["str"],
                                                                    },
                                                                    "destinationNetworkInterfaceIPConfiguration": ...,
                                                                    "destinationPort": 0,
                                                                    "etag": "str",
                                                                    "id": "str",
                                                                    "location": "str",
                                                                    "name": "str",
                                                                    "networkInterfaceTapConfigurations": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "type": "str",
                                                                            "virtualNetworkTap": ...,
                                                                        }
                                                                    ],
                                                                    "provisioningState": "str",
                                                                    "resourceGuid": "str",
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                }
                                                            ],
                                                        }
                                                    ],
                                                    "location": "str",
                                                    "macAddress": "str",
                                                    "migrationPhase": "str",
                                                    "name": "str",
                                                    "networkSecurityGroup": ...,
                                                    "nicType": "str",
                                                    "primary": bool,
                                                    "privateEndpoint": ...,
                                                    "privateLinkService": {
                                                        "accessMode": "str",
                                                        "alias": "str",
                                                        "autoApproval": {"subscriptions": ["str"]},
                                                        "destinationIPAddress": "str",
                                                        "enableProxyProtocol": bool,
                                                        "etag": "str",
                                                        "extendedLocation": {"name": "str", "type": "str"},
                                                        "fqdns": ["str"],
                                                        "id": "str",
                                                        "ipConfigurations": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "name": "str",
                                                                "primary": bool,
                                                                "privateIPAddress": "str",
                                                                "privateIPAddressVersion": "str",
                                                                "privateIPAllocationMethod": "str",
                                                                "provisioningState": "str",
                                                                "subnet": ...,
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "loadBalancerFrontendIpConfigurations": [
                                                            {
                                                                "etag": "str",
                                                                "gatewayLoadBalancer": {"id": "str"},
                                                                "id": "str",
                                                                "inboundNatPools": [{"id": "str"}],
                                                                "inboundNatRules": [{"id": "str"}],
                                                                "loadBalancingRules": [{"id": "str"}],
                                                                "name": "str",
                                                                "outboundRules": [{"id": "str"}],
                                                                "privateIPAddress": "str",
                                                                "privateIPAddressVersion": "str",
                                                                "privateIPAllocationMethod": "str",
                                                                "provisioningState": "str",
                                                                "publicIPAddress": {
                                                                    "ddosSettings": {
                                                                        "ddosProtectionPlan": {"id": "str"},
                                                                        "protectionMode": "str",
                                                                    },
                                                                    "deleteOption": "str",
                                                                    "dnsSettings": {
                                                                        "domainNameLabel": "str",
                                                                        "domainNameLabelScope": "str",
                                                                        "fqdn": "str",
                                                                        "reverseFqdn": "str",
                                                                    },
                                                                    "etag": "str",
                                                                    "extendedLocation": {"name": "str", "type": "str"},
                                                                    "id": "str",
                                                                    "idleTimeoutInMinutes": 0,
                                                                    "ipAddress": "str",
                                                                    "ipConfiguration": {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "name": "str",
                                                                        "privateIPAddress": "str",
                                                                        "privateIPAllocationMethod": "str",
                                                                        "provisioningState": "str",
                                                                        "publicIPAddress": ...,
                                                                        "subnet": ...,
                                                                    },
                                                                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                    "linkedPublicIPAddress": ...,
                                                                    "location": "str",
                                                                    "migrationPhase": "str",
                                                                    "name": "str",
                                                                    "natGateway": {
                                                                        "etag": "str",
                                                                        "id": "str",
                                                                        "idleTimeoutInMinutes": 0,
                                                                        "location": "str",
                                                                        "name": "str",
                                                                        "provisioningState": "str",
                                                                        "publicIpAddresses": [{"id": "str"}],
                                                                        "publicIpAddressesV6": [{"id": "str"}],
                                                                        "publicIpPrefixes": [{"id": "str"}],
                                                                        "publicIpPrefixesV6": [{"id": "str"}],
                                                                        "resourceGuid": "str",
                                                                        "sku": {"name": "str"},
                                                                        "sourceVirtualNetwork": {"id": "str"},
                                                                        "subnets": [{"id": "str"}],
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                        "zones": ["str"],
                                                                    },
                                                                    "provisioningState": "str",
                                                                    "publicIPAddressVersion": "str",
                                                                    "publicIPAllocationMethod": "str",
                                                                    "publicIPPrefix": {"id": "str"},
                                                                    "resourceGuid": "str",
                                                                    "servicePublicIPAddress": ...,
                                                                    "sku": {"name": "str", "tier": "str"},
                                                                    "tags": {"str": "str"},
                                                                    "type": "str",
                                                                    "zones": ["str"],
                                                                },
                                                                "publicIPPrefix": {"id": "str"},
                                                                "subnet": ...,
                                                                "type": "str",
                                                                "zones": ["str"],
                                                            }
                                                        ],
                                                        "location": "str",
                                                        "name": "str",
                                                        "networkInterfaces": [...],
                                                        "privateEndpointConnections": [
                                                            {
                                                                "etag": "str",
                                                                "id": "str",
                                                                "linkIdentifier": "str",
                                                                "name": "str",
                                                                "privateEndpoint": ...,
                                                                "privateEndpointLocation": "str",
                                                                "privateLinkServiceConnectionState": {
                                                                    "actionsRequired": "str",
                                                                    "description": "str",
                                                                    "status": "str",
                                                                },
                                                                "provisioningState": "str",
                                                                "type": "str",
                                                            }
                                                        ],
                                                        "provisioningState": "str",
                                                        "tags": {"str": "str"},
                                                        "type": "str",
                                                        "visibility": {"subscriptions": ["str"]},
                                                    },
                                                    "provisioningState": "str",
                                                    "resourceGuid": "str",
                                                    "tags": {"str": "str"},
                                                    "tapConfigurations": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "type": "str",
                                                            "virtualNetworkTap": {
                                                                "destinationLoadBalancerFrontEndIPConfiguration": {
                                                                    "etag": "str",
                                                                    "gatewayLoadBalancer": {"id": "str"},
                                                                    "id": "str",
                                                                    "inboundNatPools": [{"id": "str"}],
                                                                    "inboundNatRules": [{"id": "str"}],
                                                                    "loadBalancingRules": [{"id": "str"}],
                                                                    "name": "str",
                                                                    "outboundRules": [{"id": "str"}],
                                                                    "privateIPAddress": "str",
                                                                    "privateIPAddressVersion": "str",
                                                                    "privateIPAllocationMethod": "str",
                                                                    "provisioningState": "str",
                                                                    "publicIPAddress": {
                                                                        "ddosSettings": {
                                                                            "ddosProtectionPlan": {"id": "str"},
                                                                            "protectionMode": "str",
                                                                        },
                                                                        "deleteOption": "str",
                                                                        "dnsSettings": {
                                                                            "domainNameLabel": "str",
                                                                            "domainNameLabelScope": "str",
                                                                            "fqdn": "str",
                                                                            "reverseFqdn": "str",
                                                                        },
                                                                        "etag": "str",
                                                                        "extendedLocation": {
                                                                            "name": "str",
                                                                            "type": "str",
                                                                        },
                                                                        "id": "str",
                                                                        "idleTimeoutInMinutes": 0,
                                                                        "ipAddress": "str",
                                                                        "ipConfiguration": {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "privateIPAddress": "str",
                                                                            "privateIPAllocationMethod": "str",
                                                                            "provisioningState": "str",
                                                                            "publicIPAddress": ...,
                                                                            "subnet": ...,
                                                                        },
                                                                        "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                        "linkedPublicIPAddress": ...,
                                                                        "location": "str",
                                                                        "migrationPhase": "str",
                                                                        "name": "str",
                                                                        "natGateway": {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "idleTimeoutInMinutes": 0,
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "publicIpAddresses": [{"id": "str"}],
                                                                            "publicIpAddressesV6": [{"id": "str"}],
                                                                            "publicIpPrefixes": [{"id": "str"}],
                                                                            "publicIpPrefixesV6": [{"id": "str"}],
                                                                            "resourceGuid": "str",
                                                                            "sku": {"name": "str"},
                                                                            "sourceVirtualNetwork": {"id": "str"},
                                                                            "subnets": [{"id": "str"}],
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                            "zones": ["str"],
                                                                        },
                                                                        "provisioningState": "str",
                                                                        "publicIPAddressVersion": "str",
                                                                        "publicIPAllocationMethod": "str",
                                                                        "publicIPPrefix": {"id": "str"},
                                                                        "resourceGuid": "str",
                                                                        "servicePublicIPAddress": ...,
                                                                        "sku": {"name": "str", "tier": "str"},
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                        "zones": ["str"],
                                                                    },
                                                                    "publicIPPrefix": {"id": "str"},
                                                                    "subnet": ...,
                                                                    "type": "str",
                                                                    "zones": ["str"],
                                                                },
                                                                "destinationNetworkInterfaceIPConfiguration": {
                                                                    "applicationGatewayBackendAddressPools": [
                                                                        {
                                                                            "backendAddresses": [
                                                                                {"fqdn": "str", "ipAddress": "str"}
                                                                            ],
                                                                            "backendIPConfigurations": [...],
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "applicationSecurityGroups": [
                                                                        {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "resourceGuid": "str",
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "etag": "str",
                                                                    "gatewayLoadBalancer": {"id": "str"},
                                                                    "id": "str",
                                                                    "loadBalancerBackendAddressPools": [
                                                                        {
                                                                            "backendIPConfigurations": [...],
                                                                            "drainPeriodInSeconds": 0,
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "inboundNatRules": [{"id": "str"}],
                                                                            "loadBalancerBackendAddresses": [
                                                                                {
                                                                                    "adminState": "str",
                                                                                    "inboundNatRulesPortMapping": [
                                                                                        {
                                                                                            "backendPort": 0,
                                                                                            "frontendPort": 0,
                                                                                            "inboundNatRuleName": "str",
                                                                                        }
                                                                                    ],
                                                                                    "ipAddress": "str",
                                                                                    "loadBalancerFrontendIPConfiguration": {
                                                                                        "id": "str"
                                                                                    },
                                                                                    "name": "str",
                                                                                    "networkInterfaceIPConfiguration": {
                                                                                        "id": "str"
                                                                                    },
                                                                                    "subnet": {"id": "str"},
                                                                                    "virtualNetwork": {"id": "str"},
                                                                                }
                                                                            ],
                                                                            "loadBalancingRules": [{"id": "str"}],
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "outboundRule": {"id": "str"},
                                                                            "outboundRules": [{"id": "str"}],
                                                                            "provisioningState": "str",
                                                                            "syncMode": "str",
                                                                            "tunnelInterfaces": [
                                                                                {
                                                                                    "identifier": 0,
                                                                                    "port": 0,
                                                                                    "protocol": "str",
                                                                                    "type": "str",
                                                                                }
                                                                            ],
                                                                            "type": "str",
                                                                            "virtualNetwork": {"id": "str"},
                                                                        }
                                                                    ],
                                                                    "loadBalancerInboundNatRules": [
                                                                        {
                                                                            "backendAddressPool": {"id": "str"},
                                                                            "backendIPConfiguration": ...,
                                                                            "backendPort": 0,
                                                                            "enableFloatingIP": bool,
                                                                            "enableTcpReset": bool,
                                                                            "etag": "str",
                                                                            "frontendIPConfiguration": {"id": "str"},
                                                                            "frontendPort": 0,
                                                                            "frontendPortRangeEnd": 0,
                                                                            "frontendPortRangeStart": 0,
                                                                            "id": "str",
                                                                            "idleTimeoutInMinutes": 0,
                                                                            "name": "str",
                                                                            "protocol": "str",
                                                                            "provisioningState": "str",
                                                                            "type": "str",
                                                                        }
                                                                    ],
                                                                    "name": "str",
                                                                    "primary": bool,
                                                                    "privateIPAddress": "str",
                                                                    "privateIPAddressPrefixLength": 0,
                                                                    "privateIPAddressVersion": "str",
                                                                    "privateIPAllocationMethod": "str",
                                                                    "privateLinkConnectionProperties": {
                                                                        "fqdns": ["str"],
                                                                        "groupId": "str",
                                                                        "requiredMemberName": "str",
                                                                    },
                                                                    "provisioningState": "str",
                                                                    "publicIPAddress": {
                                                                        "ddosSettings": {
                                                                            "ddosProtectionPlan": {"id": "str"},
                                                                            "protectionMode": "str",
                                                                        },
                                                                        "deleteOption": "str",
                                                                        "dnsSettings": {
                                                                            "domainNameLabel": "str",
                                                                            "domainNameLabelScope": "str",
                                                                            "fqdn": "str",
                                                                            "reverseFqdn": "str",
                                                                        },
                                                                        "etag": "str",
                                                                        "extendedLocation": {
                                                                            "name": "str",
                                                                            "type": "str",
                                                                        },
                                                                        "id": "str",
                                                                        "idleTimeoutInMinutes": 0,
                                                                        "ipAddress": "str",
                                                                        "ipConfiguration": {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "name": "str",
                                                                            "privateIPAddress": "str",
                                                                            "privateIPAllocationMethod": "str",
                                                                            "provisioningState": "str",
                                                                            "publicIPAddress": ...,
                                                                            "subnet": ...,
                                                                        },
                                                                        "ipTags": [{"ipTagType": "str", "tag": "str"}],
                                                                        "linkedPublicIPAddress": ...,
                                                                        "location": "str",
                                                                        "migrationPhase": "str",
                                                                        "name": "str",
                                                                        "natGateway": {
                                                                            "etag": "str",
                                                                            "id": "str",
                                                                            "idleTimeoutInMinutes": 0,
                                                                            "location": "str",
                                                                            "name": "str",
                                                                            "provisioningState": "str",
                                                                            "publicIpAddresses": [{"id": "str"}],
                                                                            "publicIpAddressesV6": [{"id": "str"}],
                                                                            "publicIpPrefixes": [{"id": "str"}],
                                                                            "publicIpPrefixesV6": [{"id": "str"}],
                                                                            "resourceGuid": "str",
                                                                            "sku": {"name": "str"},
                                                                            "sourceVirtualNetwork": {"id": "str"},
                                                                            "subnets": [{"id": "str"}],
                                                                            "tags": {"str": "str"},
                                                                            "type": "str",
                                                                            "zones": ["str"],
                                                                        },
                                                                        "provisioningState": "str",
                                                                        "publicIPAddressVersion": "str",
                                                                        "publicIPAllocationMethod": "str",
                                                                        "publicIPPrefix": {"id": "str"},
                                                                        "resourceGuid": "str",
                                                                        "servicePublicIPAddress": ...,
                                                                        "sku": {"name": "str", "tier": "str"},
                                                                        "tags": {"str": "str"},
                                                                        "type": "str",
                                                                        "zones": ["str"],
                                                                    },
                                                                    "subnet": ...,
                                                                    "type": "str",
                                                                    "virtualNetworkTaps": [...],
                                                                },
                                                                "destinationPort": 0,
                                                                "etag": "str",
                                                                "id": "str",
                                                                "location": "str",
                                                                "name": "str",
                                                                "networkInterfaceTapConfigurations": [...],
                                                                "provisioningState": "str",
                                                                "resourceGuid": "str",
                                                                "tags": {"str": "str"},
                                                                "type": "str",
                                                            },
                                                        }
                                                    ],
                                                    "type": "str",
                                                    "virtualMachine": {"id": "str"},
                                                    "vnetEncryptionSupported": bool,
                                                    "workloadType": "str",
                                                }
                                            ],
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "securityRules": [
                                                {
                                                    "access": "str",
                                                    "description": "str",
                                                    "destinationAddressPrefix": "str",
                                                    "destinationAddressPrefixes": ["str"],
                                                    "destinationApplicationSecurityGroups": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "destinationPortRange": "str",
                                                    "destinationPortRanges": ["str"],
                                                    "direction": "str",
                                                    "etag": "str",
                                                    "id": "str",
                                                    "name": "str",
                                                    "priority": 0,
                                                    "protocol": "str",
                                                    "provisioningState": "str",
                                                    "sourceAddressPrefix": "str",
                                                    "sourceAddressPrefixes": ["str"],
                                                    "sourceApplicationSecurityGroups": [
                                                        {
                                                            "etag": "str",
                                                            "id": "str",
                                                            "location": "str",
                                                            "name": "str",
                                                            "provisioningState": "str",
                                                            "resourceGuid": "str",
                                                            "tags": {"str": "str"},
                                                            "type": "str",
                                                        }
                                                    ],
                                                    "sourcePortRange": "str",
                                                    "sourcePortRanges": ["str"],
                                                    "type": "str",
                                                }
                                            ],
                                            "subnets": [...],
                                            "tags": {"str": "str"},
                                            "type": "str",
                                        },
                                        "privateEndpointNetworkPolicies": "Disabled",
                                        "privateEndpoints": [...],
                                        "privateLinkServiceNetworkPolicies": "Enabled",
                                        "provisioningState": "str",
                                        "purpose": "str",
                                        "resourceNavigationLinks": [
                                            {
                                                "etag": "str",
                                                "id": "str",
                                                "link": "str",
                                                "linkedResourceType": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "routeTable": {
                                            "disableBgpRoutePropagation": bool,
                                            "etag": "str",
                                            "id": "str",
                                            "location": "str",
                                            "name": "str",
                                            "provisioningState": "str",
                                            "resourceGuid": "str",
                                            "routes": [
                                                {
                                                    "addressPrefix": "str",
                                                    "etag": "str",
                                                    "hasBgpOverride": bool,
                                                    "id": "str",
                                                    "name": "str",
                                                    "nextHopIpAddress": "str",
                                                    "nextHopType": "str",
                                                    "provisioningState": "str",
                                                    "type": "str",
                                                }
                                            ],
                                            "subnets": [...],
                                            "tags": {"str": "str"},
                                            "type": "str",
                                        },
                                        "serviceAssociationLinks": [
                                            {
                                                "allowDelete": bool,
                                                "etag": "str",
                                                "id": "str",
                                                "link": "str",
                                                "linkedResourceType": "str",
                                                "locations": ["str"],
                                                "name": "str",
                                                "provisioningState": "str",
                                                "type": "str",
                                            }
                                        ],
                                        "serviceEndpointPolicies": [
                                            {
                                                "contextualServiceEndpointPolicies": ["str"],
                                                "etag": "str",
                                                "id": "str",
                                                "kind": "str",
                                                "location": "str",
                                                "name": "str",
                                                "provisioningState": "str",
                                                "resourceGuid": "str",
                                                "serviceAlias": "str",
                                                "serviceEndpointPolicyDefinitions": [
                                                    {
                                                        "description": "str",
                                                        "etag": "str",
                                                        "id": "str",
                                                        "name": "str",
                                                        "provisioningState": "str",
                                                        "service": "str",
                                                        "serviceResources": ["str"],
                                                        "type": "str",
                                                    }
                                                ],
                                                "subnets": [...],
                                                "tags": {"str": "str"},
                                                "type": "str",
                                            }
                                        ],
                                        "serviceEndpoints": [
                                            {
                                                "locations": ["str"],
                                                "networkIdentifier": {"id": "str"},
                                                "provisioningState": "str",
                                                "service": "str",
                                            }
                                        ],
                                        "sharingScope": "str",
                                        "type": "str",
                                    },
                                    "tags": {"str": "str"},
                                    "type": "str",
                                },
                                "privateLinkServiceConnectionState": {
                                    "actionsRequired": "str",
                                    "description": "str",
                                    "status": "str",
                                },
                                "provisioningState": "str",
                                "type": "str",
                            }
                        ],
                        "privateLinkConfigurations": [
                            {
                                "etag": "str",
                                "id": "str",
                                "ipConfigurations": [
                                    {
                                        "etag": "str",
                                        "id": "str",
                                        "name": "str",
                                        "primary": bool,
                                        "privateIPAddress": "str",
                                        "privateIPAllocationMethod": "str",
                                        "provisioningState": "str",
                                        "subnet": {"id": "str"},
                                        "type": "str",
                                    }
                                ],
                                "name": "str",
                                "provisioningState": "str",
                                "type": "str",
                            }
                        ],
                        "probes": [
                            {
                                "enableProbeProxyProtocolHeader": bool,
                                "etag": "str",
                                "host": "str",
                                "id": "str",
                                "interval": 0,
                                "match": {"body": "str", "statusCodes": ["str"]},
                                "minServers": 0,
                                "name": "str",
                                "path": "str",
                                "pickHostNameFromBackendHttpSettings": bool,
                                "pickHostNameFromBackendSettings": bool,
                                "port": 0,
                                "protocol": "str",
                                "provisioningState": "str",
                                "timeout": 0,
                                "type": "str",
                                "unhealthyThreshold": 0,
                            }
                        ],
                        "provisioningState": "str",
                        "redirectConfigurations": [
                            {
                                "etag": "str",
                                "id": "str",
                                "includePath": bool,
                                "includeQueryString": bool,
                                "name": "str",
                                "pathRules": [{"id": "str"}],
                                "redirectType": "str",
                                "requestRoutingRules": [{"id": "str"}],
                                "targetListener": {"id": "str"},
                                "targetUrl": "str",
                                "type": "str",
                                "urlPathMaps": [{"id": "str"}],
                            }
                        ],
                        "requestRoutingRules": [
                            {
                                "backendAddressPool": {"id": "str"},
                                "backendHttpSettings": {"id": "str"},
                                "entraJWTValidationConfig": {"id": "str"},
                                "etag": "str",
                                "httpListener": {"id": "str"},
                                "id": "str",
                                "loadDistributionPolicy": {"id": "str"},
                                "name": "str",
                                "priority": 0,
                                "provisioningState": "str",
                                "redirectConfiguration": {"id": "str"},
                                "rewriteRuleSet": {"id": "str"},
                                "ruleType": "str",
                                "type": "str",
                                "urlPathMap": {"id": "str"},
                            }
                        ],
                        "resourceGuid": "str",
                        "rewriteRuleSets": [
                            {
                                "etag": "str",
                                "id": "str",
                                "name": "str",
                                "provisioningState": "str",
                                "rewriteRules": [
                                    {
                                        "actionSet": {
                                            "requestHeaderConfigurations": [
                                                {
                                                    "headerName": "str",
                                                    "headerValue": "str",
                                                    "headerValueMatcher": {
                                                        "ignoreCase": bool,
                                                        "negate": bool,
                                                        "pattern": "str",
                                                    },
                                                }
                                            ],
                                            "responseHeaderConfigurations": [
                                                {
                                                    "headerName": "str",
                                                    "headerValue": "str",
                                                    "headerValueMatcher": {
                                                        "ignoreCase": bool,
                                                        "negate": bool,
                                                        "pattern": "str",
                                                    },
                                                }
                                            ],
                                            "urlConfiguration": {
                                                "modifiedPath": "str",
                                                "modifiedQueryString": "str",
                                                "reroute": bool,
                                            },
                                        },
                                        "conditions": [
                                            {"ignoreCase": bool, "negate": bool, "pattern": "str", "variable": "str"}
                                        ],
                                        "name": "str",
                                        "ruleSequence": 0,
                                    }
                                ],
                            }
                        ],
                        "routingRules": [
                            {
                                "backendAddressPool": {"id": "str"},
                                "backendSettings": {"id": "str"},
                                "etag": "str",
                                "id": "str",
                                "listener": {"id": "str"},
                                "name": "str",
                                "priority": 0,
                                "provisioningState": "str",
                                "ruleType": "str",
                                "type": "str",
                            }
                        ],
                        "sku": {"capacity": 0, "family": "str", "name": "str", "tier": "str"},
                        "sslCertificates": [
                            {
                                "data": "str",
                                "etag": "str",
                                "id": "str",
                                "keyVaultSecretId": "str",
                                "name": "str",
                                "password": "str",
                                "provisioningState": "str",
                                "publicCertData": "str",
                                "type": "str",
                            }
                        ],
                        "sslPolicy": {
                            "cipherSuites": ["str"],
                            "disabledSslProtocols": ["str"],
                            "minProtocolVersion": "str",
                            "policyName": "str",
                            "policyType": "str",
                        },
                        "sslProfiles": [
                            {
                                "clientAuthConfiguration": {
                                    "verifyClientAuthMode": "str",
                                    "verifyClientCertIssuerDN": bool,
                                    "verifyClientRevocation": "str",
                                },
                                "etag": "str",
                                "id": "str",
                                "name": "str",
                                "provisioningState": "str",
                                "sslPolicy": {
                                    "cipherSuites": ["str"],
                                    "disabledSslProtocols": ["str"],
                                    "minProtocolVersion": "str",
                                    "policyName": "str",
                                    "policyType": "str",
                                },
                                "trustedClientCertificates": [{"id": "str"}],
                                "type": "str",
                            }
                        ],
                        "tags": {"str": "str"},
                        "trustedClientCertificates": [
                            {
                                "clientCertIssuerDN": "str",
                                "data": "str",
                                "etag": "str",
                                "id": "str",
                                "name": "str",
                                "provisioningState": "str",
                                "type": "str",
                                "validatedCertData": "str",
                            }
                        ],
                        "trustedRootCertificates": [
                            {
                                "data": "str",
                                "etag": "str",
                                "id": "str",
                                "keyVaultSecretId": "str",
                                "name": "str",
                                "provisioningState": "str",
                                "type": "str",
                            }
                        ],
                        "type": "str",
                        "urlPathMaps": [
                            {
                                "defaultBackendAddressPool": {"id": "str"},
                                "defaultBackendHttpSettings": {"id": "str"},
                                "defaultLoadDistributionPolicy": {"id": "str"},
                                "defaultRedirectConfiguration": {"id": "str"},
                                "defaultRewriteRuleSet": {"id": "str"},
                                "etag": "str",
                                "id": "str",
                                "name": "str",
                                "pathRules": [
                                    {
                                        "backendAddressPool": {"id": "str"},
                                        "backendHttpSettings": {"id": "str"},
                                        "etag": "str",
                                        "firewallPolicy": {"id": "str"},
                                        "id": "str",
                                        "loadDistributionPolicy": {"id": "str"},
                                        "name": "str",
                                        "paths": ["str"],
                                        "provisioningState": "str",
                                        "redirectConfiguration": {"id": "str"},
                                        "rewriteRuleSet": {"id": "str"},
                                        "type": "str",
                                    }
                                ],
                                "provisioningState": "str",
                                "type": "str",
                            }
                        ],
                        "webApplicationFirewallConfiguration": {
                            "enabled": bool,
                            "firewallMode": "str",
                            "ruleSetType": "str",
                            "ruleSetVersion": "str",
                            "disabledRuleGroups": [{"ruleGroupName": "str", "rules": [0]}],
                            "exclusions": [{"matchVariable": "str", "selector": "str", "selectorMatchOperator": "str"}],
                            "fileUploadLimitInMb": 0,
                            "maxRequestBodySize": 0,
                            "maxRequestBodySizeInKb": 0,
                            "requestBodyCheck": bool,
                        },
                        "zones": ["str"],
                    }
                ],
                "customRules": [
                    {
                        "action": "str",
                        "matchConditions": [
                            {
                                "matchValues": ["str"],
                                "matchVariables": [{"variableName": "str", "selector": "str"}],
                                "operator": "str",
                                "negationConditon": bool,
                                "transforms": ["str"],
                            }
                        ],
                        "priority": 0,
                        "ruleType": "str",
                        "etag": "str",
                        "groupByUserSession": [{"groupByVariables": [{"variableName": "str"}]}],
                        "name": "str",
                        "rateLimitDuration": "str",
                        "rateLimitThreshold": 0,
                        "state": "str",
                    }
                ],
                "etag": "str",
                "httpListeners": [{"id": "str"}],
                "id": "str",
                "location": "str",
                "managedRules": {
                    "managedRuleSets": [
                        {
                            "ruleSetType": "str",
                            "ruleSetVersion": "str",
                            "computedDisabledRules": [{"ruleGroupName": "str", "rules": ["str"]}],
                            "ruleGroupOverrides": [
                                {
                                    "ruleGroupName": "str",
                                    "rules": [{"ruleId": "str", "action": "str", "sensitivity": "str", "state": "str"}],
                                }
                            ],
                        }
                    ],
                    "exceptions": [
                        {
                            "matchVariable": "str",
                            "valueMatchOperator": "str",
                            "exceptionManagedRuleSets": [
                                {
                                    "ruleSetType": "str",
                                    "ruleSetVersion": "str",
                                    "ruleGroups": [{"ruleGroupName": "str", "rules": [{"ruleId": "str"}]}],
                                }
                            ],
                            "selector": "str",
                            "selectorMatchOperator": "str",
                            "values": ["str"],
                        }
                    ],
                    "exclusions": [
                        {
                            "matchVariable": "str",
                            "selector": "str",
                            "selectorMatchOperator": "str",
                            "exclusionManagedRuleSets": [
                                {
                                    "ruleSetType": "str",
                                    "ruleSetVersion": "str",
                                    "ruleGroups": [{"ruleGroupName": "str", "rules": [{"ruleId": "str"}]}],
                                }
                            ],
                        }
                    ],
                },
                "name": "str",
                "pathBasedRules": [{"id": "str"}],
                "policySettings": {
                    "customBlockResponseBody": "str",
                    "customBlockResponseStatusCode": 0,
                    "fileUploadEnforcement": True,
                    "fileUploadLimitInMb": 0,
                    "jsChallengeCookieExpirationInMins": 0,
                    "logScrubbing": {
                        "scrubbingRules": [
                            {"matchVariable": "str", "selectorMatchOperator": "str", "selector": "str", "state": "str"}
                        ],
                        "state": "str",
                    },
                    "maxRequestBodySizeInKb": 0,
                    "mode": "str",
                    "requestBodyCheck": bool,
                    "requestBodyEnforcement": True,
                    "requestBodyInspectLimitInKB": 0,
                    "state": "str",
                },
                "provisioningState": "str",
                "resourceState": "str",
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_web_application_firewall_policies_begin_delete(self, resource_group):
        response = self.client.web_application_firewall_policies.begin_delete(
            resource_group_name=resource_group.name,
            policy_name="str",
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
