/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.torque.engine.database.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.turbine.torque.engine.database.model.Table;
import org.xml.sax.Attributes;

public class ForeignKey {
    private String foreignTableName;
    private Table parentTable;
    private List localColumns = new ArrayList(3);
    private List foreignColumns = new ArrayList(3);

    public void loadFromXML(Attributes attrib) {
        this.foreignTableName = attrib.getValue("foreignTable");
    }

    public String getForeignTableName() {
        return this.foreignTableName;
    }

    public void setForeignTableName(String tableName) {
        this.foreignTableName = tableName;
    }

    public void setTable(Table parent) {
        this.parentTable = parent;
    }

    public Table getTable() {
        return this.parentTable;
    }

    public String getTableName() {
        return this.parentTable.getName();
    }

    public void addReference(Attributes attrib) {
        this.addReference(attrib.getValue("local"), attrib.getValue("foreign"));
    }

    public void addReference(String local, String foreign) {
        this.localColumns.add(local);
        this.foreignColumns.add(foreign);
    }

    private String makeColumnList(List cols) {
        StringBuffer res = new StringBuffer(cols.get(0).toString());
        int i = 1;
        while (i < cols.size()) {
            res.append(", ").append(cols.get(i).toString());
            ++i;
        }
        return res.toString();
    }

    public String getLocalColumnNames() {
        return this.makeColumnList(this.localColumns);
    }

    public String getForeignColumnNames() {
        return this.makeColumnList(this.foreignColumns);
    }

    public List getLocalColumns() {
        return this.localColumns;
    }

    public Hashtable getLocalForeignMapping() {
        Hashtable h = new Hashtable();
        int i = 0;
        while (i < this.localColumns.size()) {
            h.put(this.localColumns.get(i), this.foreignColumns.get(i));
            ++i;
        }
        return h;
    }

    public List getForeignColumns() {
        return this.foreignColumns;
    }

    public Hashtable getForeignLocalMapping() {
        Hashtable h = new Hashtable();
        int i = 0;
        while (i < this.localColumns.size()) {
            h.put(this.foreignColumns.get(i), this.localColumns.get(i));
            ++i;
        }
        return h;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("    <foreign-key foreignTable=\"").append(this.foreignTableName).append("\"");
        result.append(">\n");
        int i = 0;
        while (i < this.localColumns.size()) {
            result.append("        <reference local=\"").append(this.localColumns.get(i)).append("\" foreign=\"").append(this.foreignColumns.get(i)).append("\"/>\n");
            ++i;
        }
        result.append("    </foreign-key>\n");
        return result.toString();
    }
}

