/**
 * \file pappsomspp/core/processing/cbor/mzcbor/cvparammap.cpp
 * \date 02/02/2026
 * \author Olivier Langella
 * \brief cvParam map
 */

/*******************************************************************************
 * Copyright (c) 2026 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#include "cvparammap.h"
#include "pappsomspp/core/pappsoexception.h"
#include <qjsonarray.h>

void
pappso::cbor::mzcbor::CvParamMap::fromCbor(CborStreamReader &reader)
{

  qDebug();
  if(!reader.isArray())
    {
      throw pappso::PappsoException("this is not an array of cvParams");
    }
  reader.enterContainer(); // start array

  while(reader.hasNext())
    {
      qDebug();
      CvParam cv_param;
      cv_param.fromCbor(reader);
      insert({cv_param.accession, cv_param});

      qDebug() << cv_param.accession;
    }

  reader.leaveContainer(); // end array
  qDebug();
}


QJsonArray
pappso::cbor::mzcbor::CvParamMap::toJsonArray() const
{
  QJsonArray cv_array;
  for(auto const &[key, val] : *this)
    {
      cv_array.append(val.toJsonObject());
    }

  return cv_array;
}
