#!/bin/sh

set -e

assert() {
	msg="$1"
	shift
	if ! test "$@"; then
		echo "assertion failure: $msg"
		echo "check failed: $*"
		exit 1
	fi
}

CMD="$1"

case "${CMD##*/}" in
	austin)
		min_samples=1000
		min_timeit_fraction=2
	;;
	austinp)
		min_samples=30
		min_timeit_fraction=3
	;;
	*)
		echo "invalid command $CMD"
		exit 1
	;;
esac

"$CMD" -o out python3 -m timeit "'-'.join(str(n) for n in range(100))"

samples=$(grep -c '^P' out)
timeit_samples=$(grep -c '^P.*:Timer.timeit:' out)

assert "$CMD: samples > $min_samples" "$samples" -gt "$min_samples"
assert "$CMD: timeit_samples * $min_timeit_fraction >= samples" "$((timeit_samples * min_timeit_fraction))" -ge "$samples"
