#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Inner World
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240828.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='the-inner-world-1'
GAME_NAME='The Inner World'

ARCHIVE_BASE_1_NAME='setup_the_inner_world_1.2.1_(26675).exe'
ARCHIVE_BASE_1_MD5='2379e9c64c4fe06d6892474637aa405b'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='1500000'
ARCHIVE_BASE_1_VERSION='1.2.1-gog26675'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/the_inner_world'

ARCHIVE_BASE_0_NAME='setup_the_inner_world_2.0.0.2.exe'
ARCHIVE_BASE_0_MD5='b5778aa9770ba7fc7d1a3884154c136b'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1500000'
ARCHIVE_BASE_0_VERSION='1.2.1-gog2.0.0.2'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_GAME_BIN_FILES='
adobe air
meta-inf
mimetype
*.exe
*.swf'
CONTENT_GAME_DATA_FILES='
media
*.url'
CONTENT_DOC_DATA_FILES='
*.rtf'

USER_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/TheInnerWorld'

APP_MAIN_EXE='theinnerworld.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
## Ensure easy upgrades from packages generated with pre-20240430.1 game scripts.
PKG_BIN_PROVIDES="${PKG_BIN_PROVIDES:-}
the-inner-world"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
## Ensure easy upgrades from packages generated with pre-20240430.1 game scripts.
PKG_DATA_PROVIDES="${PKG_DATA_PROVIDES:-}
the-inner-world-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
