/*
 * Copyright (C) 2025 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <WebCore/DDFloat3.h>
#include <WebCore/DDFloat4x4.h>
#include <WebCore/DDMeshDescriptor.h>
#include <WebCore/DDMeshPart.h>

namespace WebCore::DDModel {

struct DDSkinningData {
    uint8_t influencePerVertexCount;
    Vector<DDFloat4x4> jointTransforms;
    Vector<DDFloat4x4> inverseBindPoses;
    Vector<uint32_t> influenceJointIndices;
    Vector<float> influenceWeights;
    DDFloat4x4 geometryBindTransform;
};

struct DDBlendShapeData {
    Vector<float> weights;
    Vector<Vector<DDFloat3>> positionOffsets;
    Vector<Vector<DDFloat3>> normalOffsets;
};

struct DDRenormalizationData {
    Vector<uint32_t> vertexIndicesPerTriangle;
    Vector<uint32_t> vertexAdjacencies;
    Vector<uint32_t> vertexAdjacencyEndIndices;
};

struct DDDeformationData {
    std::optional<DDSkinningData> skinningData;
    std::optional<DDBlendShapeData> blendShapeData;
    std::optional<DDRenormalizationData> renormalizationData;
};

struct DDUpdateMeshDescriptor {
    String identifier;
    uint8_t updateType;
    DDMeshDescriptor descriptor;
    Vector<DDMeshPart> parts;
    Vector<uint8_t> indexData;
    Vector<Vector<uint8_t>> vertexData;
    DDFloat4x4 transform;
    Vector<DDFloat4x4> instanceTransforms;
    Vector<String> materialPrims;
    std::optional<DDDeformationData> deformationData;
};

}
