// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{EventController, Gesture, GestureSingle, PropagationPhase, Widget};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkGestureDrag")]
    pub struct GestureDrag(Object<ffi::GtkGestureDrag, ffi::GtkGestureDragClass>) @extends GestureSingle, Gesture, EventController;

    match fn {
        type_ => || ffi::gtk_gesture_drag_get_type(),
    }
}

impl GestureDrag {
    pub const NONE: Option<&'static GestureDrag> = None;

    #[doc(alias = "gtk_gesture_drag_new")]
    pub fn new(widget: &impl IsA<Widget>) -> GestureDrag {
        skip_assert_initialized!();
        unsafe {
            Gesture::from_glib_full(ffi::gtk_gesture_drag_new(widget.as_ref().to_glib_none().0))
                .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`GestureDrag`] objects.
    ///
    /// This method returns an instance of [`GestureDragBuilder`](crate::builders::GestureDragBuilder) which can be used to create [`GestureDrag`] objects.
    pub fn builder() -> GestureDragBuilder {
        GestureDragBuilder::new()
    }
}

impl Default for GestureDrag {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`GestureDrag`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct GestureDragBuilder {
    builder: glib::object::ObjectBuilder<'static, GestureDrag>,
}

impl GestureDragBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn button(self, button: u32) -> Self {
        Self {
            builder: self.builder.property("button", button),
        }
    }

    pub fn exclusive(self, exclusive: bool) -> Self {
        Self {
            builder: self.builder.property("exclusive", exclusive),
        }
    }

    pub fn touch_only(self, touch_only: bool) -> Self {
        Self {
            builder: self.builder.property("touch-only", touch_only),
        }
    }

    pub fn n_points(self, n_points: u32) -> Self {
        Self {
            builder: self.builder.property("n-points", n_points),
        }
    }

    pub fn window(self, window: &gdk::Window) -> Self {
        Self {
            builder: self.builder.property("window", window.clone()),
        }
    }

    pub fn propagation_phase(self, propagation_phase: PropagationPhase) -> Self {
        Self {
            builder: self
                .builder
                .property("propagation-phase", propagation_phase),
        }
    }

    pub fn widget(self, widget: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("widget", widget.clone().upcast()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`GestureDrag`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> GestureDrag {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::GestureDrag>> Sealed for T {}
}

pub trait GestureDragExt: IsA<GestureDrag> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_gesture_drag_get_offset")]
    #[doc(alias = "get_offset")]
    fn offset(&self) -> Option<(f64, f64)> {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_gesture_drag_get_offset(
                self.as_ref().to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            ));
            if ret {
                Some((x.assume_init(), y.assume_init()))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_gesture_drag_get_start_point")]
    #[doc(alias = "get_start_point")]
    fn start_point(&self) -> Option<(f64, f64)> {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_gesture_drag_get_start_point(
                self.as_ref().to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            ));
            if ret {
                Some((x.assume_init(), y.assume_init()))
            } else {
                None
            }
        }
    }

    #[doc(alias = "drag-begin")]
    fn connect_drag_begin<F: Fn(&Self, f64, f64) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn drag_begin_trampoline<
            P: IsA<GestureDrag>,
            F: Fn(&P, f64, f64) + 'static,
        >(
            this: *mut ffi::GtkGestureDrag,
            start_x: libc::c_double,
            start_y: libc::c_double,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                GestureDrag::from_glib_borrow(this).unsafe_cast_ref(),
                start_x,
                start_y,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-begin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    drag_begin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "drag-end")]
    fn connect_drag_end<F: Fn(&Self, f64, f64) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn drag_end_trampoline<
            P: IsA<GestureDrag>,
            F: Fn(&P, f64, f64) + 'static,
        >(
            this: *mut ffi::GtkGestureDrag,
            offset_x: libc::c_double,
            offset_y: libc::c_double,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                GestureDrag::from_glib_borrow(this).unsafe_cast_ref(),
                offset_x,
                offset_y,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-end\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    drag_end_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "drag-update")]
    fn connect_drag_update<F: Fn(&Self, f64, f64) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn drag_update_trampoline<
            P: IsA<GestureDrag>,
            F: Fn(&P, f64, f64) + 'static,
        >(
            this: *mut ffi::GtkGestureDrag,
            offset_x: libc::c_double,
            offset_y: libc::c_double,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                GestureDrag::from_glib_borrow(this).unsafe_cast_ref(),
                offset_x,
                offset_y,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"drag-update\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    drag_update_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<GestureDrag>> GestureDragExt for O {}

impl fmt::Display for GestureDrag {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("GestureDrag")
    }
}
